"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serializeError = void 0;
const serializeError = (error) => {
    if (error instanceof Error) {
        return JSON.stringify({ message: error.toString(), stackTrace: error.stack });
    }
    if (typeof error === 'object') {
        return JSON.stringify(error);
    }
    return `${error}`;
};
exports.serializeError = serializeError;
//# sourceMappingURL=serializeError.js.map