export type ScheduledAction<T> = (signal?: AbortSignal) => Promise<T>;
type AttemptParams = {
    timeout?: number;
    gap?: number;
};
export type ScheduleActionParams = {
    delay?: number;
    deadline?: number;
    attempts?: number | readonly AttemptParams[];
    signal?: AbortSignal;
    graceful?: boolean;
    attemptFailureHandler?: (error: Error) => Error | void;
} & AttemptParams;
export declare const SCHEDULE_ACTION_ABORTED_ERROR_MESSAGE: "Aborted by signal";
export declare class RejectWhenAbortedError extends Error {
    constructor();
}
export declare const SCHEDULE_ACTION_TIMEOUT_ERROR_MESSAGE: "Aborted by timeout";
export declare class ScheduleActionTimeoutError extends Error {
    constructor();
}
export declare const SCHEDULE_ACTION_DEADLINE_ERROR_MESSAGE: "Aborted by deadline";
export declare class ScheduleActionDeadlineError extends Error {
    constructor();
}
export declare const scheduleAction: <T>(action: ScheduledAction<T>, params: ScheduleActionParams) => Promise<T>;
export {};
//# sourceMappingURL=scheduleAction.d.ts.map