"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isWhitelistedHost = void 0;
const isWhitelistedHost = (hostname, whitelist = ['127.0.0.1', 'localhost']) => {
    if (typeof hostname !== 'string') {
        return false;
    }
    if (hostname.trim() === '') {
        return false;
    }
    return whitelist.some(whitelistedUrl => whitelistedUrl === hostname ||
        hostname.endsWith(`.${whitelistedUrl}`));
};
exports.isWhitelistedHost = isWhitelistedHost;
//# sourceMappingURL=isWhitelistedHost.js.map