"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getMutex = void 0;
const getMutex = () => {
    const DEFAULT_ID = Symbol();
    const locks = {};
    return async (lockId = DEFAULT_ID) => {
        while (locks[lockId]) {
            await locks[lockId];
        }
        let resolve = () => { };
        locks[lockId] = new Promise(res => {
            resolve = res;
        }).finally(() => {
            delete locks[lockId];
        });
        return resolve;
    };
};
exports.getMutex = getMutex;
//# sourceMappingURL=getMutex.js.map