"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = void 0;
class Cache {
    store;
    constructor() {
        this.store = new Map();
    }
    set(key, value, ttl) {
        this.store.set(key, { value, ttl: Date.now() + ttl });
    }
    get(key) {
        const entry = this.store.get(key);
        if (!entry)
            return;
        if (entry.ttl < Date.now()) {
            this.store.delete(key);
            return;
        }
        return entry.value;
    }
    delete(key) {
        this.store.delete(key);
    }
}
exports.Cache = Cache;
//# sourceMappingURL=cache.js.map