import { decodeMessage } from '@trezor/protobuf';
import { TransportProtocol } from '@trezor/protocol';
import { AbstractApi } from '../api/abstract';
type Receiver = () => ReturnType<AbstractApi['read']>;
export declare function receive<T extends Receiver>(receiver: T, protocol: TransportProtocol): Promise<{
    success: false;
    error: "Unable to open device" | "A transfer error has occurred." | "device not found" | "device disconnected during action" | "unexpected error" | "Aborted by signal" | "Aborted by timeout";
    message?: string;
} | import("../types").Success<{
    messageType: string | number;
    payload: Buffer<ArrayBuffer>;
    header: Buffer<ArrayBufferLike>;
    length: number;
}>>;
export declare function receiveAndParse<T extends Receiver>(messages: Parameters<typeof decodeMessage>[0], receiver: T, protocol: TransportProtocol): Promise<{
    success: false;
    error: "Unable to open device" | "A transfer error has occurred." | "device not found" | "device disconnected during action" | "unexpected error" | "Aborted by signal" | "Aborted by timeout";
    message?: string;
} | import("../types").Success<{
    type: "TextMemo";
    message: import("@trezor/protobuf/lib/messages").TextMemo;
} | {
    type: "RefundMemo";
    message: import("@trezor/protobuf/lib/messages").RefundMemo;
} | {
    type: "CoinPurchaseMemo";
    message: import("@trezor/protobuf/lib/messages").CoinPurchaseMemo;
} | {
    type: "TextDetailsMemo";
    message: import("@trezor/protobuf/lib/messages").TextDetailsMemo;
} | {
    type: "PaymentRequestMemo";
    message: import("@trezor/protobuf/lib/messages").PaymentRequestMemo;
} | {
    type: "PaymentRequest";
    message: import("@trezor/protobuf/lib/messages").PaymentRequest;
} | {
    type: "HDNodeType";
    message: import("@trezor/protobuf/lib/messages").HDNodeType;
} | {
    type: "HDNodePathType";
    message: import("@trezor/protobuf/lib/messages").HDNodePathType;
} | {
    type: "MultisigRedeemScriptType";
    message: import("@trezor/protobuf/lib/messages").MultisigRedeemScriptType;
} | {
    type: "GetPublicKey";
    message: import("@trezor/protobuf/lib/messages").GetPublicKey;
} | {
    type: "PublicKey";
    message: import("@trezor/protobuf/lib/messages").PublicKey;
} | {
    type: "GetAddress";
    message: import("@trezor/protobuf/lib/messages").GetAddress;
} | {
    type: "Address";
    message: import("@trezor/protobuf/lib/messages").Address;
} | {
    type: "GetOwnershipId";
    message: import("@trezor/protobuf/lib/messages").GetOwnershipId;
} | {
    type: "OwnershipId";
    message: import("@trezor/protobuf/lib/messages").OwnershipId;
} | {
    type: "SignMessage";
    message: import("@trezor/protobuf/lib/messages").SignMessage;
} | {
    type: "MessageSignature";
    message: import("@trezor/protobuf/lib/messages").MessageSignature;
} | {
    type: "VerifyMessage";
    message: import("@trezor/protobuf/lib/messages").VerifyMessage;
} | {
    type: "CoinJoinRequest";
    message: import("@trezor/protobuf/lib/messages").CoinJoinRequest;
} | {
    type: "SignTx";
    message: import("@trezor/protobuf/lib/messages").SignTx;
} | {
    type: "TxRequestDetailsType";
    message: import("@trezor/protobuf/lib/messages").TxRequestDetailsType;
} | {
    type: "TxRequestSerializedType";
    message: import("@trezor/protobuf/lib/messages").TxRequestSerializedType;
} | {
    type: "TxRequest";
    message: import("@trezor/protobuf/lib/messages").TxRequest;
} | {
    type: "TxInputType";
    message: import("@trezor/protobuf/lib/messages").TxInputType;
} | {
    type: "TxOutputBinType";
    message: import("@trezor/protobuf/lib/messages").TxOutputBinType;
} | {
    type: "TxOutputType";
    message: import("@trezor/protobuf/lib/messages").TxOutputType;
} | {
    type: "PrevTx";
    message: import("@trezor/protobuf/lib/messages").PrevTx;
} | {
    type: "PrevInput";
    message: import("@trezor/protobuf/lib/messages").PrevInput;
} | {
    type: "PrevOutput";
    message: import("@trezor/protobuf/lib/messages").PrevOutput;
} | {
    type: "TxAck";
    message: import("@trezor/protobuf/lib/messages").TxAck;
} | {
    type: "TxAckInputWrapper";
    message: import("@trezor/protobuf/lib/messages").TxAckInputWrapper;
} | {
    type: "TxAckInput";
    message: import("@trezor/protobuf/lib/messages").TxAckInput;
} | {
    type: "TxAckOutputWrapper";
    message: import("@trezor/protobuf/lib/messages").TxAckOutputWrapper;
} | {
    type: "TxAckOutput";
    message: import("@trezor/protobuf/lib/messages").TxAckOutput;
} | {
    type: "TxAckPrevMeta";
    message: import("@trezor/protobuf/lib/messages").TxAckPrevMeta;
} | {
    type: "TxAckPrevInputWrapper";
    message: import("@trezor/protobuf/lib/messages").TxAckPrevInputWrapper;
} | {
    type: "TxAckPrevInput";
    message: import("@trezor/protobuf/lib/messages").TxAckPrevInput;
} | {
    type: "TxAckPrevOutputWrapper";
    message: import("@trezor/protobuf/lib/messages").TxAckPrevOutputWrapper;
} | {
    type: "TxAckPrevOutput";
    message: import("@trezor/protobuf/lib/messages").TxAckPrevOutput;
} | {
    type: "TxAckPrevExtraDataWrapper";
    message: import("@trezor/protobuf/lib/messages").TxAckPrevExtraDataWrapper;
} | {
    type: "TxAckPrevExtraData";
    message: import("@trezor/protobuf/lib/messages").TxAckPrevExtraData;
} | {
    type: "GetOwnershipProof";
    message: import("@trezor/protobuf/lib/messages").GetOwnershipProof;
} | {
    type: "OwnershipProof";
    message: import("@trezor/protobuf/lib/messages").OwnershipProof;
} | {
    type: "AuthorizeCoinJoin";
    message: import("@trezor/protobuf/lib/messages").AuthorizeCoinJoin;
} | {
    type: "BleUnpair";
    message: import("@trezor/protobuf/lib/messages").BleUnpair;
} | {
    type: "FirmwareErase";
    message: import("@trezor/protobuf/lib/messages").FirmwareErase;
} | {
    type: "FirmwareRequest";
    message: import("@trezor/protobuf/lib/messages").FirmwareRequest;
} | {
    type: "FirmwareUpload";
    message: import("@trezor/protobuf/lib/messages").FirmwareUpload;
} | {
    type: "ProdTestT1";
    message: import("@trezor/protobuf/lib/messages").ProdTestT1;
} | {
    type: "CardanoBlockchainPointerType";
    message: import("@trezor/protobuf/lib/messages").CardanoBlockchainPointerType;
} | {
    type: "CardanoNativeScript";
    message: import("@trezor/protobuf/lib/messages").CardanoNativeScript;
} | {
    type: "CardanoGetNativeScriptHash";
    message: import("@trezor/protobuf/lib/messages").CardanoGetNativeScriptHash;
} | {
    type: "CardanoNativeScriptHash";
    message: import("@trezor/protobuf/lib/messages").CardanoNativeScriptHash;
} | {
    type: "CardanoAddressParametersType";
    message: import("@trezor/protobuf/lib/messages").CardanoAddressParametersType;
} | {
    type: "CardanoGetAddress";
    message: import("@trezor/protobuf/lib/messages").CardanoGetAddress;
} | {
    type: "CardanoAddress";
    message: import("@trezor/protobuf/lib/messages").CardanoAddress;
} | {
    type: "CardanoGetPublicKey";
    message: import("@trezor/protobuf/lib/messages").CardanoGetPublicKey;
} | {
    type: "CardanoPublicKey";
    message: import("@trezor/protobuf/lib/messages").CardanoPublicKey;
} | {
    type: "CardanoSignTxInit";
    message: import("@trezor/protobuf/lib/messages").CardanoSignTxInit;
} | {
    type: "CardanoTxInput";
    message: import("@trezor/protobuf/lib/messages").CardanoTxInput;
} | {
    type: "CardanoTxOutput";
    message: import("@trezor/protobuf/lib/messages").CardanoTxOutput;
} | {
    type: "CardanoAssetGroup";
    message: import("@trezor/protobuf/lib/messages").CardanoAssetGroup;
} | {
    type: "CardanoToken";
    message: import("@trezor/protobuf/lib/messages").CardanoToken;
} | {
    type: "CardanoTxInlineDatumChunk";
    message: import("@trezor/protobuf/lib/messages").CardanoTxInlineDatumChunk;
} | {
    type: "CardanoTxReferenceScriptChunk";
    message: import("@trezor/protobuf/lib/messages").CardanoTxReferenceScriptChunk;
} | {
    type: "CardanoPoolOwner";
    message: import("@trezor/protobuf/lib/messages").CardanoPoolOwner;
} | {
    type: "CardanoPoolRelayParameters";
    message: import("@trezor/protobuf/lib/messages").CardanoPoolRelayParameters;
} | {
    type: "CardanoPoolMetadataType";
    message: import("@trezor/protobuf/lib/messages").CardanoPoolMetadataType;
} | {
    type: "CardanoPoolParametersType";
    message: import("@trezor/protobuf/lib/messages").CardanoPoolParametersType;
} | {
    type: "CardanoDRep";
    message: import("@trezor/protobuf/lib/messages").CardanoDRep;
} | {
    type: "CardanoTxCertificate";
    message: import("@trezor/protobuf/lib/messages").CardanoTxCertificate;
} | {
    type: "CardanoTxWithdrawal";
    message: import("@trezor/protobuf/lib/messages").CardanoTxWithdrawal;
} | {
    type: "CardanoCVoteRegistrationDelegation";
    message: import("@trezor/protobuf/lib/messages").CardanoCVoteRegistrationDelegation;
} | {
    type: "CardanoCVoteRegistrationParametersType";
    message: import("@trezor/protobuf/lib/messages").CardanoCVoteRegistrationParametersType;
} | {
    type: "CardanoTxAuxiliaryData";
    message: import("@trezor/protobuf/lib/messages").CardanoTxAuxiliaryData;
} | {
    type: "CardanoTxMint";
    message: import("@trezor/protobuf/lib/messages").CardanoTxMint;
} | {
    type: "CardanoTxCollateralInput";
    message: import("@trezor/protobuf/lib/messages").CardanoTxCollateralInput;
} | {
    type: "CardanoTxRequiredSigner";
    message: import("@trezor/protobuf/lib/messages").CardanoTxRequiredSigner;
} | {
    type: "CardanoTxReferenceInput";
    message: import("@trezor/protobuf/lib/messages").CardanoTxReferenceInput;
} | {
    type: "CardanoTxItemAck";
    message: import("@trezor/protobuf/lib/messages").CardanoTxItemAck;
} | {
    type: "CardanoTxAuxiliaryDataSupplement";
    message: import("@trezor/protobuf/lib/messages").CardanoTxAuxiliaryDataSupplement;
} | {
    type: "CardanoTxWitnessRequest";
    message: import("@trezor/protobuf/lib/messages").CardanoTxWitnessRequest;
} | {
    type: "CardanoTxWitnessResponse";
    message: import("@trezor/protobuf/lib/messages").CardanoTxWitnessResponse;
} | {
    type: "CardanoTxHostAck";
    message: import("@trezor/protobuf/lib/messages").CardanoTxHostAck;
} | {
    type: "CardanoTxBodyHash";
    message: import("@trezor/protobuf/lib/messages").CardanoTxBodyHash;
} | {
    type: "CardanoSignTxFinished";
    message: import("@trezor/protobuf/lib/messages").CardanoSignTxFinished;
} | {
    type: "CardanoSignMessageInit";
    message: import("@trezor/protobuf/lib/messages").CardanoSignMessageInit;
} | {
    type: "CardanoMessageDataRequest";
    message: import("@trezor/protobuf/lib/messages").CardanoMessageDataRequest;
} | {
    type: "CardanoMessageDataResponse";
    message: import("@trezor/protobuf/lib/messages").CardanoMessageDataResponse;
} | {
    type: "CardanoMessageSignature";
    message: import("@trezor/protobuf/lib/messages").CardanoMessageSignature;
} | {
    type: "Success";
    message: import("@trezor/protobuf/lib/messages").Success;
} | {
    type: "Failure";
    message: import("@trezor/protobuf/lib/messages").Failure;
} | {
    type: "ButtonRequest";
    message: import("@trezor/protobuf/lib/messages").ButtonRequest;
} | {
    type: "ButtonAck";
    message: import("@trezor/protobuf/lib/messages").ButtonAck;
} | {
    type: "PinMatrixRequest";
    message: import("@trezor/protobuf/lib/messages").PinMatrixRequest;
} | {
    type: "PinMatrixAck";
    message: import("@trezor/protobuf/lib/messages").PinMatrixAck;
} | {
    type: "PassphraseRequest";
    message: import("@trezor/protobuf/lib/messages").PassphraseRequest;
} | {
    type: "PassphraseAck";
    message: import("@trezor/protobuf/lib/messages").PassphraseAck;
} | {
    type: "Deprecated_PassphraseStateRequest";
    message: import("@trezor/protobuf/lib/messages").Deprecated_PassphraseStateRequest;
} | {
    type: "Deprecated_PassphraseStateAck";
    message: import("@trezor/protobuf/lib/messages").Deprecated_PassphraseStateAck;
} | {
    type: "CipherKeyValue";
    message: import("@trezor/protobuf/lib/messages").CipherKeyValue;
} | {
    type: "CipheredKeyValue";
    message: import("@trezor/protobuf/lib/messages").CipheredKeyValue;
} | {
    type: "IdentityType";
    message: import("@trezor/protobuf/lib/messages").IdentityType;
} | {
    type: "SignIdentity";
    message: import("@trezor/protobuf/lib/messages").SignIdentity;
} | {
    type: "SignedIdentity";
    message: import("@trezor/protobuf/lib/messages").SignedIdentity;
} | {
    type: "GetECDHSessionKey";
    message: import("@trezor/protobuf/lib/messages").GetECDHSessionKey;
} | {
    type: "ECDHSessionKey";
    message: import("@trezor/protobuf/lib/messages").ECDHSessionKey;
} | {
    type: "PaymentNotification";
    message: import("@trezor/protobuf/lib/messages").PaymentNotification;
} | {
    type: "DebugLinkGetPairingInfo";
    message: import("@trezor/protobuf/lib/messages").DebugLinkGetPairingInfo;
} | {
    type: "DebugLinkPairingInfo";
    message: import("@trezor/protobuf/lib/messages").DebugLinkPairingInfo;
} | {
    type: "DebugLinkResetDebugEvents";
    message: import("@trezor/protobuf/lib/messages").DebugLinkResetDebugEvents;
} | {
    type: "DebugLinkOptigaSetSecMax";
    message: import("@trezor/protobuf/lib/messages").DebugLinkOptigaSetSecMax;
} | {
    type: "DebugLinkGetGcInfo";
    message: import("@trezor/protobuf/lib/messages").DebugLinkGetGcInfo;
} | {
    type: "DebugLinkGcInfoItem";
    message: import("@trezor/protobuf/lib/messages").DebugLinkGcInfoItem;
} | {
    type: "DebugLinkGcInfo";
    message: import("@trezor/protobuf/lib/messages").DebugLinkGcInfo;
} | {
    type: "EthereumNetworkInfo";
    message: import("@trezor/protobuf/lib/messages").EthereumNetworkInfo;
} | {
    type: "EthereumTokenInfo";
    message: import("@trezor/protobuf/lib/messages").EthereumTokenInfo;
} | {
    type: "SolanaTokenInfo";
    message: import("@trezor/protobuf/lib/messages").SolanaTokenInfo;
} | {
    type: "EosGetPublicKey";
    message: import("@trezor/protobuf/lib/messages").EosGetPublicKey;
} | {
    type: "EosPublicKey";
    message: import("@trezor/protobuf/lib/messages").EosPublicKey;
} | {
    type: "EosTxHeader";
    message: import("@trezor/protobuf/lib/messages").EosTxHeader;
} | {
    type: "EosSignTx";
    message: import("@trezor/protobuf/lib/messages").EosSignTx;
} | {
    type: "EosTxActionRequest";
    message: import("@trezor/protobuf/lib/messages").EosTxActionRequest;
} | {
    type: "EosAsset";
    message: import("@trezor/protobuf/lib/messages").EosAsset;
} | {
    type: "EosPermissionLevel";
    message: import("@trezor/protobuf/lib/messages").EosPermissionLevel;
} | {
    type: "EosAuthorizationKey";
    message: import("@trezor/protobuf/lib/messages").EosAuthorizationKey;
} | {
    type: "EosAuthorizationAccount";
    message: import("@trezor/protobuf/lib/messages").EosAuthorizationAccount;
} | {
    type: "EosAuthorizationWait";
    message: import("@trezor/protobuf/lib/messages").EosAuthorizationWait;
} | {
    type: "EosAuthorization";
    message: import("@trezor/protobuf/lib/messages").EosAuthorization;
} | {
    type: "EosActionCommon";
    message: import("@trezor/protobuf/lib/messages").EosActionCommon;
} | {
    type: "EosActionTransfer";
    message: import("@trezor/protobuf/lib/messages").EosActionTransfer;
} | {
    type: "EosActionDelegate";
    message: import("@trezor/protobuf/lib/messages").EosActionDelegate;
} | {
    type: "EosActionUndelegate";
    message: import("@trezor/protobuf/lib/messages").EosActionUndelegate;
} | {
    type: "EosActionRefund";
    message: import("@trezor/protobuf/lib/messages").EosActionRefund;
} | {
    type: "EosActionBuyRam";
    message: import("@trezor/protobuf/lib/messages").EosActionBuyRam;
} | {
    type: "EosActionBuyRamBytes";
    message: import("@trezor/protobuf/lib/messages").EosActionBuyRamBytes;
} | {
    type: "EosActionSellRam";
    message: import("@trezor/protobuf/lib/messages").EosActionSellRam;
} | {
    type: "EosActionVoteProducer";
    message: import("@trezor/protobuf/lib/messages").EosActionVoteProducer;
} | {
    type: "EosActionUpdateAuth";
    message: import("@trezor/protobuf/lib/messages").EosActionUpdateAuth;
} | {
    type: "EosActionDeleteAuth";
    message: import("@trezor/protobuf/lib/messages").EosActionDeleteAuth;
} | {
    type: "EosActionLinkAuth";
    message: import("@trezor/protobuf/lib/messages").EosActionLinkAuth;
} | {
    type: "EosActionUnlinkAuth";
    message: import("@trezor/protobuf/lib/messages").EosActionUnlinkAuth;
} | {
    type: "EosActionNewAccount";
    message: import("@trezor/protobuf/lib/messages").EosActionNewAccount;
} | {
    type: "EosActionUnknown";
    message: import("@trezor/protobuf/lib/messages").EosActionUnknown;
} | {
    type: "EosTxActionAck";
    message: import("@trezor/protobuf/lib/messages").EosTxActionAck;
} | {
    type: "EosSignedTx";
    message: import("@trezor/protobuf/lib/messages").EosSignedTx;
} | {
    type: "EthereumDefinitions";
    message: import("@trezor/protobuf/lib/messages").EthereumDefinitions;
} | {
    type: "EthereumSignTypedData";
    message: import("@trezor/protobuf/lib/messages").EthereumSignTypedData;
} | {
    type: "EthereumTypedDataStructRequest";
    message: import("@trezor/protobuf/lib/messages").EthereumTypedDataStructRequest;
} | {
    type: "EthereumFieldType";
    message: import("@trezor/protobuf/lib/messages").EthereumFieldType;
} | {
    type: "EthereumStructMember";
    message: import("@trezor/protobuf/lib/messages").EthereumStructMember;
} | {
    type: "EthereumTypedDataStructAck";
    message: import("@trezor/protobuf/lib/messages").EthereumTypedDataStructAck;
} | {
    type: "EthereumTypedDataValueRequest";
    message: import("@trezor/protobuf/lib/messages").EthereumTypedDataValueRequest;
} | {
    type: "EthereumTypedDataValueAck";
    message: import("@trezor/protobuf/lib/messages").EthereumTypedDataValueAck;
} | {
    type: "EthereumGetPublicKey";
    message: import("@trezor/protobuf/lib/messages").EthereumGetPublicKey;
} | {
    type: "EthereumPublicKey";
    message: import("@trezor/protobuf/lib/messages").EthereumPublicKey;
} | {
    type: "EthereumGetAddress";
    message: import("@trezor/protobuf/lib/messages").EthereumGetAddress;
} | {
    type: "EthereumAddress";
    message: import("@trezor/protobuf/lib/messages").EthereumAddress;
} | {
    type: "EthereumSignTx";
    message: import("@trezor/protobuf/lib/messages").EthereumSignTx;
} | {
    type: "EthereumAccessList";
    message: import("@trezor/protobuf/lib/messages").EthereumAccessList;
} | {
    type: "EthereumSignTxEIP1559";
    message: import("@trezor/protobuf/lib/messages").EthereumSignTxEIP1559;
} | {
    type: "EthereumTxRequest";
    message: import("@trezor/protobuf/lib/messages").EthereumTxRequest;
} | {
    type: "EthereumTxAck";
    message: import("@trezor/protobuf/lib/messages").EthereumTxAck;
} | {
    type: "EthereumSignMessage";
    message: import("@trezor/protobuf/lib/messages").EthereumSignMessage;
} | {
    type: "EthereumMessageSignature";
    message: import("@trezor/protobuf/lib/messages").EthereumMessageSignature;
} | {
    type: "EthereumVerifyMessage";
    message: import("@trezor/protobuf/lib/messages").EthereumVerifyMessage;
} | {
    type: "EthereumSignTypedHash";
    message: import("@trezor/protobuf/lib/messages").EthereumSignTypedHash;
} | {
    type: "EthereumTypedDataSignature";
    message: import("@trezor/protobuf/lib/messages").EthereumTypedDataSignature;
} | {
    type: "EvoluGetNode";
    message: import("@trezor/protobuf/lib/messages").EvoluGetNode;
} | {
    type: "EvoluNode";
    message: import("@trezor/protobuf/lib/messages").EvoluNode;
} | {
    type: "Initialize";
    message: import("@trezor/protobuf/lib/messages").Initialize;
} | {
    type: "GetFeatures";
    message: import("@trezor/protobuf/lib/messages").GetFeatures;
} | {
    type: "RecoveryDevice";
    message: import("@trezor/protobuf/lib/messages").RecoveryDevice;
} | {
    type: "Features";
    message: import("@trezor/protobuf/lib/messages").Features;
} | {
    type: "LockDevice";
    message: import("@trezor/protobuf/lib/messages").LockDevice;
} | {
    type: "SetBusy";
    message: import("@trezor/protobuf/lib/messages").SetBusy;
} | {
    type: "EndSession";
    message: import("@trezor/protobuf/lib/messages").EndSession;
} | {
    type: "ApplySettings";
    message: import("@trezor/protobuf/lib/messages").ApplySettings;
} | {
    type: "ChangeLanguage";
    message: import("@trezor/protobuf/lib/messages").ChangeLanguage;
} | {
    type: "DataChunkRequest";
    message: import("@trezor/protobuf/lib/messages").DataChunkRequest;
} | {
    type: "DataChunkAck";
    message: import("@trezor/protobuf/lib/messages").DataChunkAck;
} | {
    type: "ApplyFlags";
    message: import("@trezor/protobuf/lib/messages").ApplyFlags;
} | {
    type: "ChangePin";
    message: import("@trezor/protobuf/lib/messages").ChangePin;
} | {
    type: "ChangeWipeCode";
    message: import("@trezor/protobuf/lib/messages").ChangeWipeCode;
} | {
    type: "SdProtect";
    message: import("@trezor/protobuf/lib/messages").SdProtect;
} | {
    type: "Ping";
    message: import("@trezor/protobuf/lib/messages").Ping;
} | {
    type: "Cancel";
    message: import("@trezor/protobuf/lib/messages").Cancel;
} | {
    type: "GetEntropy";
    message: import("@trezor/protobuf/lib/messages").GetEntropy;
} | {
    type: "Entropy";
    message: import("@trezor/protobuf/lib/messages").Entropy;
} | {
    type: "GetFirmwareHash";
    message: import("@trezor/protobuf/lib/messages").GetFirmwareHash;
} | {
    type: "FirmwareHash";
    message: import("@trezor/protobuf/lib/messages").FirmwareHash;
} | {
    type: "AuthenticateDevice";
    message: import("@trezor/protobuf/lib/messages").AuthenticateDevice;
} | {
    type: "AuthenticityProof";
    message: import("@trezor/protobuf/lib/messages").AuthenticityProof;
} | {
    type: "WipeDevice";
    message: import("@trezor/protobuf/lib/messages").WipeDevice;
} | {
    type: "LoadDevice";
    message: import("@trezor/protobuf/lib/messages").LoadDevice;
} | {
    type: "ResetDevice";
    message: import("@trezor/protobuf/lib/messages").ResetDevice;
} | {
    type: "Slip39Group";
    message: import("@trezor/protobuf/lib/messages").Slip39Group;
} | {
    type: "BackupDevice";
    message: import("@trezor/protobuf/lib/messages").BackupDevice;
} | {
    type: "EntropyRequest";
    message: import("@trezor/protobuf/lib/messages").EntropyRequest;
} | {
    type: "EntropyAck";
    message: import("@trezor/protobuf/lib/messages").EntropyAck;
} | {
    type: "EntropyCheckReady";
    message: import("@trezor/protobuf/lib/messages").EntropyCheckReady;
} | {
    type: "EntropyCheckContinue";
    message: import("@trezor/protobuf/lib/messages").EntropyCheckContinue;
} | {
    type: "WordRequest";
    message: import("@trezor/protobuf/lib/messages").WordRequest;
} | {
    type: "WordAck";
    message: import("@trezor/protobuf/lib/messages").WordAck;
} | {
    type: "SetU2FCounter";
    message: import("@trezor/protobuf/lib/messages").SetU2FCounter;
} | {
    type: "GetNextU2FCounter";
    message: import("@trezor/protobuf/lib/messages").GetNextU2FCounter;
} | {
    type: "NextU2FCounter";
    message: import("@trezor/protobuf/lib/messages").NextU2FCounter;
} | {
    type: "DoPreauthorized";
    message: import("@trezor/protobuf/lib/messages").DoPreauthorized;
} | {
    type: "PreauthorizedRequest";
    message: import("@trezor/protobuf/lib/messages").PreauthorizedRequest;
} | {
    type: "CancelAuthorization";
    message: import("@trezor/protobuf/lib/messages").CancelAuthorization;
} | {
    type: "RebootToBootloader";
    message: import("@trezor/protobuf/lib/messages").RebootToBootloader;
} | {
    type: "GetNonce";
    message: import("@trezor/protobuf/lib/messages").GetNonce;
} | {
    type: "Nonce";
    message: import("@trezor/protobuf/lib/messages").Nonce;
} | {
    type: "UnlockPath";
    message: import("@trezor/protobuf/lib/messages").UnlockPath;
} | {
    type: "UnlockedPathRequest";
    message: import("@trezor/protobuf/lib/messages").UnlockedPathRequest;
} | {
    type: "ShowDeviceTutorial";
    message: import("@trezor/protobuf/lib/messages").ShowDeviceTutorial;
} | {
    type: "UnlockBootloader";
    message: import("@trezor/protobuf/lib/messages").UnlockBootloader;
} | {
    type: "SetBrightness";
    message: import("@trezor/protobuf/lib/messages").SetBrightness;
} | {
    type: "NEMGetAddress";
    message: import("@trezor/protobuf/lib/messages").NEMGetAddress;
} | {
    type: "NEMAddress";
    message: import("@trezor/protobuf/lib/messages").NEMAddress;
} | {
    type: "NEMTransactionCommon";
    message: import("@trezor/protobuf/lib/messages").NEMTransactionCommon;
} | {
    type: "NEMMosaic";
    message: import("@trezor/protobuf/lib/messages").NEMMosaic;
} | {
    type: "NEMTransfer";
    message: import("@trezor/protobuf/lib/messages").NEMTransfer;
} | {
    type: "NEMProvisionNamespace";
    message: import("@trezor/protobuf/lib/messages").NEMProvisionNamespace;
} | {
    type: "NEMMosaicDefinition";
    message: import("@trezor/protobuf/lib/messages").NEMMosaicDefinition;
} | {
    type: "NEMMosaicCreation";
    message: import("@trezor/protobuf/lib/messages").NEMMosaicCreation;
} | {
    type: "NEMMosaicSupplyChange";
    message: import("@trezor/protobuf/lib/messages").NEMMosaicSupplyChange;
} | {
    type: "NEMCosignatoryModification";
    message: import("@trezor/protobuf/lib/messages").NEMCosignatoryModification;
} | {
    type: "NEMAggregateModification";
    message: import("@trezor/protobuf/lib/messages").NEMAggregateModification;
} | {
    type: "NEMImportanceTransfer";
    message: import("@trezor/protobuf/lib/messages").NEMImportanceTransfer;
} | {
    type: "NEMSignTx";
    message: import("@trezor/protobuf/lib/messages").NEMSignTx;
} | {
    type: "NEMSignedTx";
    message: import("@trezor/protobuf/lib/messages").NEMSignedTx;
} | {
    type: "NEMDecryptMessage";
    message: import("@trezor/protobuf/lib/messages").NEMDecryptMessage;
} | {
    type: "NEMDecryptedMessage";
    message: import("@trezor/protobuf/lib/messages").NEMDecryptedMessage;
} | {
    type: "RippleGetAddress";
    message: import("@trezor/protobuf/lib/messages").RippleGetAddress;
} | {
    type: "RippleAddress";
    message: import("@trezor/protobuf/lib/messages").RippleAddress;
} | {
    type: "RipplePayment";
    message: import("@trezor/protobuf/lib/messages").RipplePayment;
} | {
    type: "RippleSignTx";
    message: import("@trezor/protobuf/lib/messages").RippleSignTx;
} | {
    type: "RippleSignedTx";
    message: import("@trezor/protobuf/lib/messages").RippleSignedTx;
} | {
    type: "SolanaGetPublicKey";
    message: import("@trezor/protobuf/lib/messages").SolanaGetPublicKey;
} | {
    type: "SolanaPublicKey";
    message: import("@trezor/protobuf/lib/messages").SolanaPublicKey;
} | {
    type: "SolanaGetAddress";
    message: import("@trezor/protobuf/lib/messages").SolanaGetAddress;
} | {
    type: "SolanaAddress";
    message: import("@trezor/protobuf/lib/messages").SolanaAddress;
} | {
    type: "SolanaTxTokenAccountInfo";
    message: import("@trezor/protobuf/lib/messages").SolanaTxTokenAccountInfo;
} | {
    type: "SolanaTxAdditionalInfo";
    message: import("@trezor/protobuf/lib/messages").SolanaTxAdditionalInfo;
} | {
    type: "SolanaSignTx";
    message: import("@trezor/protobuf/lib/messages").SolanaSignTx;
} | {
    type: "SolanaTxSignature";
    message: import("@trezor/protobuf/lib/messages").SolanaTxSignature;
} | {
    type: "StellarAsset";
    message: import("@trezor/protobuf/lib/messages").StellarAsset;
} | {
    type: "StellarGetAddress";
    message: import("@trezor/protobuf/lib/messages").StellarGetAddress;
} | {
    type: "StellarAddress";
    message: import("@trezor/protobuf/lib/messages").StellarAddress;
} | {
    type: "StellarSignTx";
    message: import("@trezor/protobuf/lib/messages").StellarSignTx;
} | {
    type: "StellarTxOpRequest";
    message: import("@trezor/protobuf/lib/messages").StellarTxOpRequest;
} | {
    type: "StellarPaymentOp";
    message: import("@trezor/protobuf/lib/messages").StellarPaymentOp;
} | {
    type: "StellarCreateAccountOp";
    message: import("@trezor/protobuf/lib/messages").StellarCreateAccountOp;
} | {
    type: "StellarPathPaymentStrictReceiveOp";
    message: import("@trezor/protobuf/lib/messages").StellarPathPaymentStrictReceiveOp;
} | {
    type: "StellarPathPaymentStrictSendOp";
    message: import("@trezor/protobuf/lib/messages").StellarPathPaymentStrictSendOp;
} | {
    type: "StellarManageSellOfferOp";
    message: import("@trezor/protobuf/lib/messages").StellarManageSellOfferOp;
} | {
    type: "StellarManageBuyOfferOp";
    message: import("@trezor/protobuf/lib/messages").StellarManageBuyOfferOp;
} | {
    type: "StellarCreatePassiveSellOfferOp";
    message: import("@trezor/protobuf/lib/messages").StellarCreatePassiveSellOfferOp;
} | {
    type: "StellarSetOptionsOp";
    message: import("@trezor/protobuf/lib/messages").StellarSetOptionsOp;
} | {
    type: "StellarChangeTrustOp";
    message: import("@trezor/protobuf/lib/messages").StellarChangeTrustOp;
} | {
    type: "StellarAllowTrustOp";
    message: import("@trezor/protobuf/lib/messages").StellarAllowTrustOp;
} | {
    type: "StellarAccountMergeOp";
    message: import("@trezor/protobuf/lib/messages").StellarAccountMergeOp;
} | {
    type: "StellarManageDataOp";
    message: import("@trezor/protobuf/lib/messages").StellarManageDataOp;
} | {
    type: "StellarBumpSequenceOp";
    message: import("@trezor/protobuf/lib/messages").StellarBumpSequenceOp;
} | {
    type: "StellarClaimClaimableBalanceOp";
    message: import("@trezor/protobuf/lib/messages").StellarClaimClaimableBalanceOp;
} | {
    type: "StellarSignedTx";
    message: import("@trezor/protobuf/lib/messages").StellarSignedTx;
} | {
    type: "TezosGetAddress";
    message: import("@trezor/protobuf/lib/messages").TezosGetAddress;
} | {
    type: "TezosAddress";
    message: import("@trezor/protobuf/lib/messages").TezosAddress;
} | {
    type: "TezosGetPublicKey";
    message: import("@trezor/protobuf/lib/messages").TezosGetPublicKey;
} | {
    type: "TezosPublicKey";
    message: import("@trezor/protobuf/lib/messages").TezosPublicKey;
} | {
    type: "TezosContractID";
    message: import("@trezor/protobuf/lib/messages").TezosContractID;
} | {
    type: "TezosRevealOp";
    message: import("@trezor/protobuf/lib/messages").TezosRevealOp;
} | {
    type: "TezosManagerTransfer";
    message: import("@trezor/protobuf/lib/messages").TezosManagerTransfer;
} | {
    type: "TezosParametersManager";
    message: import("@trezor/protobuf/lib/messages").TezosParametersManager;
} | {
    type: "TezosTransactionOp";
    message: import("@trezor/protobuf/lib/messages").TezosTransactionOp;
} | {
    type: "TezosOriginationOp";
    message: import("@trezor/protobuf/lib/messages").TezosOriginationOp;
} | {
    type: "TezosDelegationOp";
    message: import("@trezor/protobuf/lib/messages").TezosDelegationOp;
} | {
    type: "TezosProposalOp";
    message: import("@trezor/protobuf/lib/messages").TezosProposalOp;
} | {
    type: "TezosBallotOp";
    message: import("@trezor/protobuf/lib/messages").TezosBallotOp;
} | {
    type: "TezosSignTx";
    message: import("@trezor/protobuf/lib/messages").TezosSignTx;
} | {
    type: "TezosSignedTx";
    message: import("@trezor/protobuf/lib/messages").TezosSignedTx;
}>>;
export {};
//# sourceMappingURL=receive.d.ts.map