import { AbstractTransportMethodParams, AbstractTransportParams } from './abstract';
import { AbstractApiTransport } from './abstractApi';
type WebUsbTransportParams = AbstractTransportParams & {
    sessionsBackgroundUrl?: string;
};
export declare class WebUsbTransport extends AbstractApiTransport {
    name: "WebUsbTransport";
    apiType: "usb";
    private readonly sessionsBackgroundUrl;
    constructor({ logger, sessionsBackgroundUrl, ...rest }: WebUsbTransportParams);
    private trySetSessionsBackground;
    init({ signal }?: AbstractTransportMethodParams<'init'>): Promise<{
        success: false;
        error: NonNullable<"Aborted by signal" | "Aborted by timeout">;
        message: string | undefined;
    } | {
        success: false;
        error: "unexpected error";
        message: string;
    } | import("../sessions/types").HandshakeResponse>;
}
export {};
//# sourceMappingURL=webusb.browser.d.ts.map