"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UdpTransport = void 0;
const abstractApi_1 = require("./abstractApi");
const udp_1 = require("../api/udp");
class UdpTransport extends abstractApi_1.AbstractApiTransport {
    name = 'UdpTransport';
    apiType = 'udp';
    enumerateTimeout;
    constructor(params) {
        const { logger, debugLink, ...rest } = params;
        super({
            api: new udp_1.UdpApi({ logger, debugLink }),
            logger,
            ...rest,
        });
    }
    stop() {
        if (this.enumerateTimeout) {
            clearTimeout(this.enumerateTimeout);
            this.enumerateTimeout = undefined;
        }
        return super.stop();
    }
}
exports.UdpTransport = UdpTransport;
//# sourceMappingURL=udp.js.map