"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NodeUsbTransport = void 0;
const abstract_1 = require("./abstract");
const errors_1 = require("../errors");
const resultEmpty_1 = require("../utils/resultEmpty");
class NodeUsbTransport extends abstract_1.AbstractTransport {
    name = 'NodeUsbTransport';
    apiType = 'usb';
    constructor(params) {
        super(params);
        console.error(errors_1.WRONG_ENVIRONMENT);
    }
    init = resultEmpty_1.empty;
    acquire = resultEmpty_1.empty;
    enumerate = resultEmpty_1.empty;
    call = resultEmpty_1.empty;
    receive = resultEmpty_1.empty;
    send = resultEmpty_1.empty;
    release = resultEmpty_1.empty;
    stop = resultEmpty_1.empty;
    releaseDevice = resultEmpty_1.empty;
    releaseSync = resultEmpty_1.emptySync;
    listen = resultEmpty_1.emptySync;
}
exports.NodeUsbTransport = NodeUsbTransport;
//# sourceMappingURL=nodeusb.browser.js.map