import { decodeMessage } from '@trezor/protobuf';
import { thp as protocolThp } from '@trezor/protocol';
import type { AbstractApi } from '../api/abstract';
import { Logger } from '../types';
import { receive } from '../utils/receive';
export type ReceiveThpMessageProps = {
    apiWrite: (chunk: Buffer, signal?: AbortSignal) => ReturnType<AbstractApi['write']>;
    apiRead: (signal?: AbortSignal) => ReturnType<AbstractApi['read']>;
    thpState?: protocolThp.ThpState;
    skipAck?: boolean;
    signal?: AbortSignal;
    logger?: Logger;
};
export declare const receiveThpMessage: ({ thpState, skipAck, apiRead, apiWrite, signal, logger, }: ReceiveThpMessageProps) => Promise<{
    success: false;
    error: "Unable to open device" | "A transfer error has occurred." | "device not found" | "device disconnected during action" | "unexpected error" | "Aborted by signal" | "Aborted by timeout";
    message?: string;
} | import("../types").Success<{
    messageType: string | number;
    payload: Buffer<ArrayBuffer>;
    header: Buffer<ArrayBufferLike>;
    length: number;
}> | {
    success: false;
    error: any;
    message: string | undefined;
}>;
export type ParseThpMessageProps = {
    messages: Parameters<typeof decodeMessage>[0];
    decoded: Extract<Awaited<ReturnType<typeof receive>>, {
        success: true;
    }>['payload'];
    thpState?: protocolThp.ThpState;
};
export declare const parseThpMessage: ({ decoded, messages, thpState }: ParseThpMessageProps) => protocolThp.ThpMessageResponse;
//# sourceMappingURL=receive.d.ts.map