"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AbstractApi = exports.DEVICE_TYPE = void 0;
const tslib_1 = require("tslib");
const utils_1 = require("@trezor/utils");
const ERRORS = tslib_1.__importStar(require("../errors"));
const result_1 = require("../utils/result");
var DEVICE_TYPE;
(function (DEVICE_TYPE) {
    DEVICE_TYPE[DEVICE_TYPE["TypeT1Hid"] = 0] = "TypeT1Hid";
    DEVICE_TYPE[DEVICE_TYPE["TypeT1Webusb"] = 1] = "TypeT1Webusb";
    DEVICE_TYPE[DEVICE_TYPE["TypeT1WebusbBoot"] = 2] = "TypeT1WebusbBoot";
    DEVICE_TYPE[DEVICE_TYPE["TypeT2"] = 3] = "TypeT2";
    DEVICE_TYPE[DEVICE_TYPE["TypeT2Boot"] = 4] = "TypeT2Boot";
    DEVICE_TYPE[DEVICE_TYPE["TypeEmulator"] = 5] = "TypeEmulator";
    DEVICE_TYPE[DEVICE_TYPE["TypeBluetooth"] = 6] = "TypeBluetooth";
})(DEVICE_TYPE || (exports.DEVICE_TYPE = DEVICE_TYPE = {}));
class AbstractApi extends utils_1.TypedEmitter {
    logger;
    listening = false;
    lock = {};
    constructor({ logger }) {
        super();
        this.logger = logger;
    }
    success(payload) {
        return (0, result_1.success)(payload);
    }
    error(payload) {
        return (0, result_1.error)(payload);
    }
    unknownError(err, expectedErrors = []) {
        this.logger?.error('transport: abstract api: unknown error', err);
        return (0, result_1.unknownError)(err, expectedErrors);
    }
    synchronize = (0, utils_1.getSynchronize)();
    requestAccess({ lock, path }) {
        if (!this.lock[path]) {
            this.lock[path] = { read: false, write: false };
        }
        if ((this.lock[path].read && lock.read) || (this.lock[path].write && lock.write)) {
            return this.error({ error: ERRORS.OTHER_CALL_IN_PROGRESS });
        }
        this.lock[path] = {
            read: this.lock[path].read || lock.read,
            write: this.lock[path].write || lock.write,
        };
        return this.success(undefined);
    }
    runInIsolation = async ({ lock, path }, fn) => {
        const accessRes = this.requestAccess({ lock, path });
        if (!accessRes.success) {
            return accessRes;
        }
        try {
            return await this.synchronize(fn);
        }
        catch (err) {
            this.logger?.error('transport: abstract api: runInIsolation error', err);
            return this.unknownError(err);
        }
        finally {
            this.lock[path] = {
                read: lock.read ? false : this.lock[path].read,
                write: lock.write ? false : this.lock[path].write,
            };
        }
    };
}
exports.AbstractApi = AbstractApi;
//# sourceMappingURL=abstract.js.map