"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encode = exports.getHeaders = void 0;
const constants_1 = require("./constants");
const getHeaders = () => {
    const header = Buffer.alloc(3);
    header.writeUInt8(constants_1.MESSAGE_MAGIC_HEADER_BYTE, 0);
    header.writeUInt8(constants_1.MESSAGE_HEADER_BYTE, 1);
    header.writeUInt8(constants_1.MESSAGE_HEADER_BYTE, 2);
    const chunkHeader = Buffer.alloc(1);
    chunkHeader.writeUInt8(constants_1.MESSAGE_MAGIC_HEADER_BYTE);
    return [header, chunkHeader];
};
exports.getHeaders = getHeaders;
const encode = (data, options) => {
    const { messageType } = options;
    if (typeof messageType === 'string') {
        throw new Error(`Unsupported message type ${messageType}`);
    }
    const fullSize = constants_1.HEADER_SIZE + data.length;
    const encodedBuffer = Buffer.alloc(fullSize);
    const [header] = (0, exports.getHeaders)(data);
    header.copy(encodedBuffer);
    encodedBuffer.writeUInt16BE(messageType, 3);
    encodedBuffer.writeUInt32BE(data.length, 5);
    data.copy(encodedBuffer, constants_1.HEADER_SIZE);
    return encodedBuffer;
};
exports.encode = encode;
//# sourceMappingURL=encode.js.map