"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.aesgcm = void 0;
const tslib_1 = require("tslib");
const crypto = tslib_1.__importStar(require("crypto"));
const aesgcm = (key, iv) => {
    const cipher = crypto.createCipheriv('aes-256-gcm', key, iv);
    const decipher = crypto.createDecipheriv('aes-256-gcm', key, iv);
    return {
        auth: (authData) => {
            cipher.setAAD(authData);
            decipher.setAAD(authData);
        },
        encrypt: (plainText) => {
            const encrypted = cipher.update(plainText);
            return Buffer.concat([encrypted, cipher.final()]);
        },
        decrypt: (cipherText, authTag) => {
            decipher.setAuthTag(authTag);
            const decrypted = decipher.update(cipherText);
            return Buffer.concat([decrypted, decipher.final()]);
        },
        finish: () => cipher.getAuthTag(),
    };
};
exports.aesgcm = aesgcm;
//# sourceMappingURL=aesgcm.js.map