"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.encode = exports.getHeaders = void 0;
const constants_1 = require("./constants");
const getHeaders = () => [Buffer.alloc(0), Buffer.alloc(0)];
exports.getHeaders = getHeaders;
const encode = (data, options) => {
    const { messageType } = options;
    if (typeof messageType === 'string') {
        throw new Error(`Unsupported message type ${messageType}`);
    }
    const encodedBuffer = Buffer.alloc(constants_1.HEADER_SIZE + data.length);
    encodedBuffer.writeUInt16BE(messageType);
    encodedBuffer.writeUInt32BE(data.length, 2);
    data.copy(encodedBuffer, constants_1.HEADER_SIZE);
    return encodedBuffer;
};
exports.encode = encode;
//# sourceMappingURL=encode.js.map