import { Static } from '@trezor/schema-utils';
export declare enum DeviceModelInternal {
    T1B1 = "T1B1",
    T2T1 = "T2T1",
    T2B1 = "T2B1",
    T3B1 = "T3B1",
    T3T1 = "T3T1",
    T3W1 = "T3W1",
    UNKNOWN = "UNKNOWN"
}
export type EnumDeviceModelInternal = Static<typeof EnumDeviceModelInternal>;
export declare const EnumDeviceModelInternal: import("@trezor/schema-utils").TEnum<typeof DeviceModelInternal>;
export declare enum Enum_InputScriptType {
    SPENDADDRESS = 0,
    SPENDMULTISIG = 1,
    EXTERNAL = 2,
    SPENDWITNESS = 3,
    SPENDP2SHWITNESS = 4,
    SPENDTAPROOT = 5
}
export type EnumEnum_InputScriptType = Static<typeof EnumEnum_InputScriptType>;
export declare const EnumEnum_InputScriptType: import("@trezor/schema-utils").TEnum<typeof Enum_InputScriptType>;
export type InputScriptType = Static<typeof InputScriptType>;
export declare const InputScriptType: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>;
export declare enum Enum_OutputScriptType {
    PAYTOADDRESS = 0,
    PAYTOSCRIPTHASH = 1,
    PAYTOMULTISIG = 2,
    PAYTOOPRETURN = 3,
    PAYTOWITNESS = 4,
    PAYTOP2SHWITNESS = 5,
    PAYTOTAPROOT = 6
}
export type EnumEnum_OutputScriptType = Static<typeof EnumEnum_OutputScriptType>;
export declare const EnumEnum_OutputScriptType: import("@trezor/schema-utils").TEnum<typeof Enum_OutputScriptType>;
export type OutputScriptType = Static<typeof OutputScriptType>;
export declare const OutputScriptType: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_OutputScriptType>;
export declare enum DecredStakingSpendType {
    SSGen = 0,
    SSRTX = 1
}
export type EnumDecredStakingSpendType = Static<typeof EnumDecredStakingSpendType>;
export declare const EnumDecredStakingSpendType: import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>;
export type TextMemo = Static<typeof TextMemo>;
export declare const TextMemo: import("@trezor/schema-utils").TObject<{
    text: import("@trezor/schema-utils").TString;
}>;
export type RefundMemo = Static<typeof RefundMemo>;
export declare const RefundMemo: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    mac: import("@trezor/schema-utils").TString;
}>;
export type CoinPurchaseMemo = Static<typeof CoinPurchaseMemo>;
export declare const CoinPurchaseMemo: import("@trezor/schema-utils").TObject<{
    coin_type: import("@trezor/schema-utils").TNumber;
    amount: import("@trezor/schema-utils").TString;
    address: import("@trezor/schema-utils").TString;
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    mac: import("@trezor/schema-utils").TString;
}>;
export type TextDetailsMemo = Static<typeof TextDetailsMemo>;
export declare const TextDetailsMemo: import("@trezor/schema-utils").TObject<{
    title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type PaymentRequestMemo = Static<typeof PaymentRequestMemo>;
export declare const PaymentRequestMemo: import("@trezor/schema-utils").TObject<{
    text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        text: import("@trezor/schema-utils").TString;
    }>>;
    refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        mac: import("@trezor/schema-utils").TString;
    }>>;
    coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        coin_type: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils").TString;
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        mac: import("@trezor/schema-utils").TString;
    }>>;
    text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>;
export type PaymentRequest = Static<typeof PaymentRequest>;
export declare const PaymentRequest: import("@trezor/schema-utils").TObject<{
    nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    recipient_name: import("@trezor/schema-utils").TString;
    memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            text: import("@trezor/schema-utils").TString;
        }>>;
        refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            mac: import("@trezor/schema-utils").TString;
        }>>;
        coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            coin_type: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils").TString;
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            mac: import("@trezor/schema-utils").TString;
        }>>;
        text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>>>;
    amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    signature: import("@trezor/schema-utils").TString;
}>;
export declare enum AmountUnit {
    BITCOIN = 0,
    MILLIBITCOIN = 1,
    MICROBITCOIN = 2,
    SATOSHI = 3
}
export type EnumAmountUnit = Static<typeof EnumAmountUnit>;
export declare const EnumAmountUnit: import("@trezor/schema-utils").TEnum<typeof AmountUnit>;
export declare enum MultisigPubkeysOrder {
    PRESERVED = 0,
    LEXICOGRAPHIC = 1
}
export type EnumMultisigPubkeysOrder = Static<typeof EnumMultisigPubkeysOrder>;
export declare const EnumMultisigPubkeysOrder: import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>;
export type HDNodeType = Static<typeof HDNodeType>;
export declare const HDNodeType: import("@trezor/schema-utils").TObject<{
    depth: import("@trezor/schema-utils").TNumber;
    fingerprint: import("@trezor/schema-utils").TNumber;
    child_num: import("@trezor/schema-utils").TNumber;
    chain_code: import("@trezor/schema-utils").TString;
    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    public_key: import("@trezor/schema-utils").TString;
}>;
export type HDNodePathType = Static<typeof HDNodePathType>;
export declare const HDNodePathType: import("@trezor/schema-utils").TObject<{
    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
        depth: import("@trezor/schema-utils").TNumber;
        fingerprint: import("@trezor/schema-utils").TNumber;
        child_num: import("@trezor/schema-utils").TNumber;
        chain_code: import("@trezor/schema-utils").TString;
        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        public_key: import("@trezor/schema-utils").TString;
    }>, import("@trezor/schema-utils").TString]>;
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
}>;
export type MultisigRedeemScriptType = Static<typeof MultisigRedeemScriptType>;
export declare const MultisigRedeemScriptType: import("@trezor/schema-utils").TObject<{
    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>, import("@trezor/schema-utils").TString]>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    }>>;
    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    m: import("@trezor/schema-utils").TNumber;
    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        depth: import("@trezor/schema-utils").TNumber;
        fingerprint: import("@trezor/schema-utils").TNumber;
        child_num: import("@trezor/schema-utils").TNumber;
        chain_code: import("@trezor/schema-utils").TString;
        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        public_key: import("@trezor/schema-utils").TString;
    }>>>;
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
}>;
export type GetPublicKey = Static<typeof GetPublicKey>;
export declare const GetPublicKey: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    ecdsa_curve_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
    ignore_xpub_magic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type PublicKey = Static<typeof PublicKey>;
export declare const PublicKey: import("@trezor/schema-utils").TObject<{
    node: import("@trezor/schema-utils").TObject<{
        depth: import("@trezor/schema-utils").TNumber;
        fingerprint: import("@trezor/schema-utils").TNumber;
        child_num: import("@trezor/schema-utils").TNumber;
        chain_code: import("@trezor/schema-utils").TString;
        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        public_key: import("@trezor/schema-utils").TString;
    }>;
    xpub: import("@trezor/schema-utils").TString;
    root_fingerprint: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    descriptor: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type GetAddress = Static<typeof GetAddress>;
export declare const GetAddress: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
    ignore_xpub_magic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type Address = Static<typeof Address>;
export declare const Address: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type GetOwnershipId = Static<typeof GetOwnershipId>;
export declare const GetOwnershipId: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
}>;
export type OwnershipId = Static<typeof OwnershipId>;
export declare const OwnershipId: import("@trezor/schema-utils").TObject<{
    ownership_id: import("@trezor/schema-utils").TString;
}>;
export type SignMessage = Static<typeof SignMessage>;
export declare const SignMessage: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    message: import("@trezor/schema-utils").TString;
    coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
    no_script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type MessageSignature = Static<typeof MessageSignature>;
export declare const MessageSignature: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    signature: import("@trezor/schema-utils").TString;
}>;
export type VerifyMessage = Static<typeof VerifyMessage>;
export declare const VerifyMessage: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    signature: import("@trezor/schema-utils").TString;
    message: import("@trezor/schema-utils").TString;
    coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type CoinJoinRequest = Static<typeof CoinJoinRequest>;
export declare const CoinJoinRequest: import("@trezor/schema-utils").TObject<{
    fee_rate: import("@trezor/schema-utils").TNumber;
    no_fee_threshold: import("@trezor/schema-utils").TNumber;
    min_registrable_amount: import("@trezor/schema-utils").TNumber;
    mask_public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type SignTx = Static<typeof SignTx>;
export declare const SignTx: import("@trezor/schema-utils").TObject<{
    outputs_count: import("@trezor/schema-utils").TNumber;
    inputs_count: import("@trezor/schema-utils").TNumber;
    coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    lock_time: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    expiry: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    overwintered: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    version_group_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    timestamp: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    branch_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    amount_unit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof AmountUnit>>;
    decred_staking_ticket: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    serialize: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    coinjoin_request: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        fee_rate: import("@trezor/schema-utils").TNumber;
        no_fee_threshold: import("@trezor/schema-utils").TNumber;
        min_registrable_amount: import("@trezor/schema-utils").TNumber;
        mask_public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export declare enum Enum_RequestType {
    TXINPUT = 0,
    TXOUTPUT = 1,
    TXMETA = 2,
    TXFINISHED = 3,
    TXEXTRADATA = 4,
    TXORIGINPUT = 5,
    TXORIGOUTPUT = 6,
    TXPAYMENTREQ = 7
}
export type EnumEnum_RequestType = Static<typeof EnumEnum_RequestType>;
export declare const EnumEnum_RequestType: import("@trezor/schema-utils").TEnum<typeof Enum_RequestType>;
export type RequestType = Static<typeof RequestType>;
export declare const RequestType: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RequestType>;
export type TxRequestDetailsType = Static<typeof TxRequestDetailsType>;
export declare const TxRequestDetailsType: import("@trezor/schema-utils").TObject<{
    request_index: import("@trezor/schema-utils").TNumber;
    tx_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    extra_data_offset: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type TxRequestSerializedType = Static<typeof TxRequestSerializedType>;
export declare const TxRequestSerializedType: import("@trezor/schema-utils").TObject<{
    signature_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    serialized_tx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type TxRequest = Static<typeof TxRequest>;
export declare const TxRequest: import("@trezor/schema-utils").TObject<{
    request_type: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RequestType>;
    details: import("@trezor/schema-utils").TObject<{
        request_index: import("@trezor/schema-utils").TNumber;
        tx_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        extra_data_offset: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    serialized: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        signature_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        serialized_tx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>;
export type InternalInputScriptType = Static<typeof InternalInputScriptType>;
export declare const InternalInputScriptType: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>;
export type TxInputType = Static<typeof TxInputType>;
export declare const TxInputType: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    prev_hash: import("@trezor/schema-utils").TString;
    prev_index: import("@trezor/schema-utils").TNumber;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
    script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    prev_hash: import("@trezor/schema-utils").TString;
    prev_index: import("@trezor/schema-utils").TNumber;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
    script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
    script_pubkey: import("@trezor/schema-utils").TString;
}>]>]>;
export type TxInput = Static<typeof TxInput>;
export declare const TxInput: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    prev_hash: import("@trezor/schema-utils").TString;
    prev_index: import("@trezor/schema-utils").TNumber;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
    script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    prev_hash: import("@trezor/schema-utils").TString;
    prev_index: import("@trezor/schema-utils").TNumber;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
    script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>, import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
    script_pubkey: import("@trezor/schema-utils").TString;
}>]>]>;
export type TxOutputBinType = Static<typeof TxOutputBinType>;
export declare const TxOutputBinType: import("@trezor/schema-utils").TObject<{
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    script_pubkey: import("@trezor/schema-utils").TString;
    decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type ChangeOutputScriptType = Static<typeof ChangeOutputScriptType>;
export declare const ChangeOutputScriptType: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>;
export type TxOutputType = Static<typeof TxOutputType>;
export declare const TxOutputType: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>, import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>, import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>, import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
    op_return_data: import("@trezor/schema-utils").TString;
    script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>]>;
export type TxOutput = Static<typeof TxOutput>;
export declare const TxOutput: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>, import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>, import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>, import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
    op_return_data: import("@trezor/schema-utils").TString;
    script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
    orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>]>;
export type PrevTx = Static<typeof PrevTx>;
export declare const PrevTx: import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TNumber;
    lock_time: import("@trezor/schema-utils").TNumber;
    inputs_count: import("@trezor/schema-utils").TNumber;
    outputs_count: import("@trezor/schema-utils").TNumber;
    extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    expiry: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    version_group_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    timestamp: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    branch_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type PrevInput = Static<typeof PrevInput>;
export declare const PrevInput: import("@trezor/schema-utils").TObject<{
    prev_hash: import("@trezor/schema-utils").TString;
    prev_index: import("@trezor/schema-utils").TNumber;
    script_sig: import("@trezor/schema-utils").TString;
    sequence: import("@trezor/schema-utils").TNumber;
    decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type PrevOutput = Static<typeof PrevOutput>;
export declare const PrevOutput: import("@trezor/schema-utils").TObject<{
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    script_pubkey: import("@trezor/schema-utils").TString;
    decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type TxAckResponse = Static<typeof TxAckResponse>;
export declare const TxAckResponse: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
    inputs: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
        script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
        script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
        script_pubkey: import("@trezor/schema-utils").TString;
    }>]>]>, import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
        script_sig: import("@trezor/schema-utils").TString;
        sequence: import("@trezor/schema-utils").TNumber;
        decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>]>>;
}>, import("@trezor/schema-utils").TObject<{
    bin_outputs: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        script_pubkey: import("@trezor/schema-utils").TString;
        decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>>;
}>, import("@trezor/schema-utils").TObject<{
    outputs: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
        op_return_data: import("@trezor/schema-utils").TString;
        script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>]>>;
}>, import("@trezor/schema-utils").TObject<{
    extra_data: import("@trezor/schema-utils").TString;
}>, import("@trezor/schema-utils").TObject<{
    version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    lock_time: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    inputs_cnt: import("@trezor/schema-utils").TNumber;
    outputs_cnt: import("@trezor/schema-utils").TNumber;
    extra_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    timestamp: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    version_group_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    expiry: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    branch_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>]>;
export type TxAck = Static<typeof TxAck>;
export declare const TxAck: import("@trezor/schema-utils").TObject<{
    tx: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
        inputs: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            prev_hash: import("@trezor/schema-utils").TString;
            prev_index: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
            script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
        }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            prev_hash: import("@trezor/schema-utils").TString;
            prev_index: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
            script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
            script_pubkey: import("@trezor/schema-utils").TString;
        }>]>]>, import("@trezor/schema-utils").TObject<{
            prev_hash: import("@trezor/schema-utils").TString;
            prev_index: import("@trezor/schema-utils").TNumber;
            script_sig: import("@trezor/schema-utils").TString;
            sequence: import("@trezor/schema-utils").TNumber;
            decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>]>>;
    }>, import("@trezor/schema-utils").TObject<{
        bin_outputs: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            script_pubkey: import("@trezor/schema-utils").TString;
            decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>>;
    }>, import("@trezor/schema-utils").TObject<{
        outputs: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>, import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>, import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>, import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
            op_return_data: import("@trezor/schema-utils").TString;
            script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>]>>;
    }>, import("@trezor/schema-utils").TObject<{
        extra_data: import("@trezor/schema-utils").TString;
    }>, import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        lock_time: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        inputs_cnt: import("@trezor/schema-utils").TNumber;
        outputs_cnt: import("@trezor/schema-utils").TNumber;
        extra_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        timestamp: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        version_group_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        expiry: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        branch_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>]>;
}>;
export type TxAckInputWrapper = Static<typeof TxAckInputWrapper>;
export declare const TxAckInputWrapper: import("@trezor/schema-utils").TObject<{
    input: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
        script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
        script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
        script_pubkey: import("@trezor/schema-utils").TString;
    }>]>]>;
}>;
export type TxAckInput = Static<typeof TxAckInput>;
export declare const TxAckInput: import("@trezor/schema-utils").TObject<{
    tx: import("@trezor/schema-utils").TObject<{
        input: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            prev_hash: import("@trezor/schema-utils").TString;
            prev_index: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
            script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
        }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            prev_hash: import("@trezor/schema-utils").TString;
            prev_index: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
            script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
            script_pubkey: import("@trezor/schema-utils").TString;
        }>]>]>;
    }>;
}>;
export type TxAckOutputWrapper = Static<typeof TxAckOutputWrapper>;
export declare const TxAckOutputWrapper: import("@trezor/schema-utils").TObject<{
    output: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
        op_return_data: import("@trezor/schema-utils").TString;
        script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>]>;
}>;
export type TxAckOutput = Static<typeof TxAckOutput>;
export declare const TxAckOutput: import("@trezor/schema-utils").TObject<{
    tx: import("@trezor/schema-utils").TObject<{
        output: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>, import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>, import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>, import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
            op_return_data: import("@trezor/schema-utils").TString;
            script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>]>;
    }>;
}>;
export type TxAckPrevMeta = Static<typeof TxAckPrevMeta>;
export declare const TxAckPrevMeta: import("@trezor/schema-utils").TObject<{
    tx: import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TNumber;
        lock_time: import("@trezor/schema-utils").TNumber;
        inputs_count: import("@trezor/schema-utils").TNumber;
        outputs_count: import("@trezor/schema-utils").TNumber;
        extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        expiry: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        version_group_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        timestamp: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        branch_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
}>;
export type TxAckPrevInputWrapper = Static<typeof TxAckPrevInputWrapper>;
export declare const TxAckPrevInputWrapper: import("@trezor/schema-utils").TObject<{
    input: import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
        script_sig: import("@trezor/schema-utils").TString;
        sequence: import("@trezor/schema-utils").TNumber;
        decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
}>;
export type TxAckPrevInput = Static<typeof TxAckPrevInput>;
export declare const TxAckPrevInput: import("@trezor/schema-utils").TObject<{
    tx: import("@trezor/schema-utils").TObject<{
        input: import("@trezor/schema-utils").TObject<{
            prev_hash: import("@trezor/schema-utils").TString;
            prev_index: import("@trezor/schema-utils").TNumber;
            script_sig: import("@trezor/schema-utils").TString;
            sequence: import("@trezor/schema-utils").TNumber;
            decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>;
    }>;
}>;
export type TxAckPrevOutputWrapper = Static<typeof TxAckPrevOutputWrapper>;
export declare const TxAckPrevOutputWrapper: import("@trezor/schema-utils").TObject<{
    output: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        script_pubkey: import("@trezor/schema-utils").TString;
        decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
}>;
export type TxAckPrevOutput = Static<typeof TxAckPrevOutput>;
export declare const TxAckPrevOutput: import("@trezor/schema-utils").TObject<{
    tx: import("@trezor/schema-utils").TObject<{
        output: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            script_pubkey: import("@trezor/schema-utils").TString;
            decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>;
    }>;
}>;
export type TxAckPrevExtraDataWrapper = Static<typeof TxAckPrevExtraDataWrapper>;
export declare const TxAckPrevExtraDataWrapper: import("@trezor/schema-utils").TObject<{
    extra_data_chunk: import("@trezor/schema-utils").TString;
}>;
export type TxAckPrevExtraData = Static<typeof TxAckPrevExtraData>;
export declare const TxAckPrevExtraData: import("@trezor/schema-utils").TObject<{
    tx: import("@trezor/schema-utils").TObject<{
        extra_data_chunk: import("@trezor/schema-utils").TString;
    }>;
}>;
export type GetOwnershipProof = Static<typeof GetOwnershipProof>;
export declare const GetOwnershipProof: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>>;
    user_confirmation: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    ownership_ids: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>>;
    commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type OwnershipProof = Static<typeof OwnershipProof>;
export declare const OwnershipProof: import("@trezor/schema-utils").TObject<{
    ownership_proof: import("@trezor/schema-utils").TString;
    signature: import("@trezor/schema-utils").TString;
}>;
export type AuthorizeCoinJoin = Static<typeof AuthorizeCoinJoin>;
export declare const AuthorizeCoinJoin: import("@trezor/schema-utils").TObject<{
    coordinator: import("@trezor/schema-utils").TString;
    max_rounds: import("@trezor/schema-utils").TNumber;
    max_coordinator_fee_rate: import("@trezor/schema-utils").TNumber;
    max_fee_per_kvbyte: import("@trezor/schema-utils").TNumber;
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
    amount_unit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof AmountUnit>>;
}>;
export type BleUnpair = Static<typeof BleUnpair>;
export declare const BleUnpair: import("@trezor/schema-utils").TObject<{
    all: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    addr: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type FirmwareErase = Static<typeof FirmwareErase>;
export declare const FirmwareErase: import("@trezor/schema-utils").TObject<{
    length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type FirmwareRequest = Static<typeof FirmwareRequest>;
export declare const FirmwareRequest: import("@trezor/schema-utils").TObject<{
    offset: import("@trezor/schema-utils").TNumber;
    length: import("@trezor/schema-utils").TNumber;
}>;
export type FirmwareUpload = Static<typeof FirmwareUpload>;
export declare const FirmwareUpload: import("@trezor/schema-utils").TObject<{
    payload: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/buffer").TBuffer, import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer]>;
    hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type ProdTestT1 = Static<typeof ProdTestT1>;
export declare const ProdTestT1: import("@trezor/schema-utils").TObject<{
    payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export declare enum CardanoDerivationType {
    LEDGER = 0,
    ICARUS = 1,
    ICARUS_TREZOR = 2
}
export type EnumCardanoDerivationType = Static<typeof EnumCardanoDerivationType>;
export declare const EnumCardanoDerivationType: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
export declare enum CardanoAddressType {
    BASE = 0,
    BASE_SCRIPT_KEY = 1,
    BASE_KEY_SCRIPT = 2,
    BASE_SCRIPT_SCRIPT = 3,
    POINTER = 4,
    POINTER_SCRIPT = 5,
    ENTERPRISE = 6,
    ENTERPRISE_SCRIPT = 7,
    BYRON = 8,
    REWARD = 14,
    REWARD_SCRIPT = 15
}
export type EnumCardanoAddressType = Static<typeof EnumCardanoAddressType>;
export declare const EnumCardanoAddressType: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
export declare enum CardanoNativeScriptType {
    PUB_KEY = 0,
    ALL = 1,
    ANY = 2,
    N_OF_K = 3,
    INVALID_BEFORE = 4,
    INVALID_HEREAFTER = 5
}
export type EnumCardanoNativeScriptType = Static<typeof EnumCardanoNativeScriptType>;
export declare const EnumCardanoNativeScriptType: import("@trezor/schema-utils").TEnum<typeof CardanoNativeScriptType>;
export declare enum CardanoNativeScriptHashDisplayFormat {
    HIDE = 0,
    BECH32 = 1,
    POLICY_ID = 2
}
export type EnumCardanoNativeScriptHashDisplayFormat = Static<typeof EnumCardanoNativeScriptHashDisplayFormat>;
export declare const EnumCardanoNativeScriptHashDisplayFormat: import("@trezor/schema-utils").TEnum<typeof CardanoNativeScriptHashDisplayFormat>;
export declare enum CardanoTxOutputSerializationFormat {
    ARRAY_LEGACY = 0,
    MAP_BABBAGE = 1
}
export type EnumCardanoTxOutputSerializationFormat = Static<typeof EnumCardanoTxOutputSerializationFormat>;
export declare const EnumCardanoTxOutputSerializationFormat: import("@trezor/schema-utils").TEnum<typeof CardanoTxOutputSerializationFormat>;
export declare enum CardanoCertificateType {
    STAKE_REGISTRATION = 0,
    STAKE_DEREGISTRATION = 1,
    STAKE_DELEGATION = 2,
    STAKE_POOL_REGISTRATION = 3,
    STAKE_REGISTRATION_CONWAY = 7,
    STAKE_DEREGISTRATION_CONWAY = 8,
    VOTE_DELEGATION = 9
}
export type EnumCardanoCertificateType = Static<typeof EnumCardanoCertificateType>;
export declare const EnumCardanoCertificateType: import("@trezor/schema-utils").TEnum<typeof CardanoCertificateType>;
export declare enum CardanoDRepType {
    KEY_HASH = 0,
    SCRIPT_HASH = 1,
    ABSTAIN = 2,
    NO_CONFIDENCE = 3
}
export type EnumCardanoDRepType = Static<typeof EnumCardanoDRepType>;
export declare const EnumCardanoDRepType: import("@trezor/schema-utils").TEnum<typeof CardanoDRepType>;
export declare enum CardanoPoolRelayType {
    SINGLE_HOST_IP = 0,
    SINGLE_HOST_NAME = 1,
    MULTIPLE_HOST_NAME = 2
}
export type EnumCardanoPoolRelayType = Static<typeof EnumCardanoPoolRelayType>;
export declare const EnumCardanoPoolRelayType: import("@trezor/schema-utils").TEnum<typeof CardanoPoolRelayType>;
export declare enum CardanoTxAuxiliaryDataSupplementType {
    NONE = 0,
    CVOTE_REGISTRATION_SIGNATURE = 1
}
export type EnumCardanoTxAuxiliaryDataSupplementType = Static<typeof EnumCardanoTxAuxiliaryDataSupplementType>;
export declare const EnumCardanoTxAuxiliaryDataSupplementType: import("@trezor/schema-utils").TEnum<typeof CardanoTxAuxiliaryDataSupplementType>;
export declare enum CardanoCVoteRegistrationFormat {
    CIP15 = 0,
    CIP36 = 1
}
export type EnumCardanoCVoteRegistrationFormat = Static<typeof EnumCardanoCVoteRegistrationFormat>;
export declare const EnumCardanoCVoteRegistrationFormat: import("@trezor/schema-utils").TEnum<typeof CardanoCVoteRegistrationFormat>;
export declare enum CardanoTxSigningMode {
    ORDINARY_TRANSACTION = 0,
    POOL_REGISTRATION_AS_OWNER = 1,
    MULTISIG_TRANSACTION = 2,
    PLUTUS_TRANSACTION = 3
}
export type EnumCardanoTxSigningMode = Static<typeof EnumCardanoTxSigningMode>;
export declare const EnumCardanoTxSigningMode: import("@trezor/schema-utils").TEnum<typeof CardanoTxSigningMode>;
export declare enum CardanoTxWitnessType {
    BYRON_WITNESS = 0,
    SHELLEY_WITNESS = 1
}
export type EnumCardanoTxWitnessType = Static<typeof EnumCardanoTxWitnessType>;
export declare const EnumCardanoTxWitnessType: import("@trezor/schema-utils").TEnum<typeof CardanoTxWitnessType>;
export type CardanoBlockchainPointerType = Static<typeof CardanoBlockchainPointerType>;
export declare const CardanoBlockchainPointerType: import("@trezor/schema-utils").TObject<{
    block_index: import("@trezor/schema-utils").TNumber;
    tx_index: import("@trezor/schema-utils").TNumber;
    certificate_index: import("@trezor/schema-utils").TNumber;
}>;
export type CardanoNativeScript = Static<typeof CardanoNativeScript>;
export declare const CardanoNativeScript: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TEnum<typeof CardanoNativeScriptType>;
    scripts: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TThis>>;
    key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    key_path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    required_signatures_count: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    invalid_before: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    invalid_hereafter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
}>>;
export type CardanoGetNativeScriptHash = Static<typeof CardanoGetNativeScriptHash>;
export declare const CardanoGetNativeScriptHash: import("@trezor/schema-utils").TObject<{
    script: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof CardanoNativeScriptType>;
        scripts: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TThis>>;
        key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        key_path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        required_signatures_count: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        invalid_before: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        invalid_hereafter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    }>>;
    display_format: import("@trezor/schema-utils").TEnum<typeof CardanoNativeScriptHashDisplayFormat>;
    derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
}>;
export type CardanoNativeScriptHash = Static<typeof CardanoNativeScriptHash>;
export declare const CardanoNativeScriptHash: import("@trezor/schema-utils").TObject<{
    script_hash: import("@trezor/schema-utils").TString;
}>;
export type CardanoAddressParametersType = Static<typeof CardanoAddressParametersType>;
export declare const CardanoAddressParametersType: import("@trezor/schema-utils").TObject<{
    address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        block_index: import("@trezor/schema-utils").TNumber;
        tx_index: import("@trezor/schema-utils").TNumber;
        certificate_index: import("@trezor/schema-utils").TNumber;
    }>>;
    script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoGetAddress = Static<typeof CardanoGetAddress>;
export declare const CardanoGetAddress: import("@trezor/schema-utils").TObject<{
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    protocol_magic: import("@trezor/schema-utils").TNumber;
    network_id: import("@trezor/schema-utils").TNumber;
    address_parameters: import("@trezor/schema-utils").TObject<{
        address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            block_index: import("@trezor/schema-utils").TNumber;
            tx_index: import("@trezor/schema-utils").TNumber;
            certificate_index: import("@trezor/schema-utils").TNumber;
        }>>;
        script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type CardanoAddress = Static<typeof CardanoAddress>;
export declare const CardanoAddress: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoGetPublicKey = Static<typeof CardanoGetPublicKey>;
export declare const CardanoGetPublicKey: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
}>;
export type CardanoPublicKey = Static<typeof CardanoPublicKey>;
export declare const CardanoPublicKey: import("@trezor/schema-utils").TObject<{
    xpub: import("@trezor/schema-utils").TString;
    node: import("@trezor/schema-utils").TObject<{
        depth: import("@trezor/schema-utils").TNumber;
        fingerprint: import("@trezor/schema-utils").TNumber;
        child_num: import("@trezor/schema-utils").TNumber;
        chain_code: import("@trezor/schema-utils").TString;
        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        public_key: import("@trezor/schema-utils").TString;
    }>;
}>;
export type CardanoSignTxInit = Static<typeof CardanoSignTxInit>;
export declare const CardanoSignTxInit: import("@trezor/schema-utils").TObject<{
    signing_mode: import("@trezor/schema-utils").TEnum<typeof CardanoTxSigningMode>;
    protocol_magic: import("@trezor/schema-utils").TNumber;
    network_id: import("@trezor/schema-utils").TNumber;
    inputs_count: import("@trezor/schema-utils").TNumber;
    outputs_count: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    ttl: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    certificates_count: import("@trezor/schema-utils").TNumber;
    withdrawals_count: import("@trezor/schema-utils").TNumber;
    has_auxiliary_data: import("@trezor/schema-utils").TBoolean;
    validity_interval_start: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    witness_requests_count: import("@trezor/schema-utils").TNumber;
    minting_asset_groups_count: import("@trezor/schema-utils").TNumber;
    derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
    include_network_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    script_data_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    collateral_inputs_count: import("@trezor/schema-utils").TNumber;
    required_signers_count: import("@trezor/schema-utils").TNumber;
    has_collateral_return: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    total_collateral: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    reference_inputs_count: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    tag_cbor_sets: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        recipient_name: import("@trezor/schema-utils").TString;
        memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                text: import("@trezor/schema-utils").TString;
            }>>;
            refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                coin_type: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils").TString;
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
        }>>>;
        amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        signature: import("@trezor/schema-utils").TString;
    }>>;
}>;
export type CardanoTxInput = Static<typeof CardanoTxInput>;
export declare const CardanoTxInput: import("@trezor/schema-utils").TObject<{
    prev_hash: import("@trezor/schema-utils").TString;
    prev_index: import("@trezor/schema-utils").TNumber;
}>;
export type CardanoTxOutput = Static<typeof CardanoTxOutput>;
export declare const CardanoTxOutput: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    address_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            block_index: import("@trezor/schema-utils").TNumber;
            tx_index: import("@trezor/schema-utils").TNumber;
            certificate_index: import("@trezor/schema-utils").TNumber;
        }>>;
        script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    asset_groups_count: import("@trezor/schema-utils").TNumber;
    datum_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    format: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof CardanoTxOutputSerializationFormat>>;
    inline_datum_size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    reference_script_size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type CardanoAssetGroup = Static<typeof CardanoAssetGroup>;
export declare const CardanoAssetGroup: import("@trezor/schema-utils").TObject<{
    policy_id: import("@trezor/schema-utils").TString;
    tokens_count: import("@trezor/schema-utils").TNumber;
}>;
export type CardanoToken = Static<typeof CardanoToken>;
export declare const CardanoToken: import("@trezor/schema-utils").TObject<{
    asset_name_bytes: import("@trezor/schema-utils").TString;
    amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    mint_amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
}>;
export type CardanoTxInlineDatumChunk = Static<typeof CardanoTxInlineDatumChunk>;
export declare const CardanoTxInlineDatumChunk: import("@trezor/schema-utils").TObject<{
    data: import("@trezor/schema-utils").TString;
}>;
export type CardanoTxReferenceScriptChunk = Static<typeof CardanoTxReferenceScriptChunk>;
export declare const CardanoTxReferenceScriptChunk: import("@trezor/schema-utils").TObject<{
    data: import("@trezor/schema-utils").TString;
}>;
export type CardanoPoolOwner = Static<typeof CardanoPoolOwner>;
export declare const CardanoPoolOwner: import("@trezor/schema-utils").TObject<{
    staking_key_path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoPoolRelayParameters = Static<typeof CardanoPoolRelayParameters>;
export declare const CardanoPoolRelayParameters: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TEnum<typeof CardanoPoolRelayType>;
    ipv4_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    ipv6_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    host_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    port: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type CardanoPoolMetadataType = Static<typeof CardanoPoolMetadataType>;
export declare const CardanoPoolMetadataType: import("@trezor/schema-utils").TObject<{
    url: import("@trezor/schema-utils").TString;
    hash: import("@trezor/schema-utils").TString;
}>;
export type CardanoPoolParametersType = Static<typeof CardanoPoolParametersType>;
export declare const CardanoPoolParametersType: import("@trezor/schema-utils").TObject<{
    pool_id: import("@trezor/schema-utils").TString;
    vrf_key_hash: import("@trezor/schema-utils").TString;
    pledge: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    cost: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    margin_numerator: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    margin_denominator: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    reward_account: import("@trezor/schema-utils").TString;
    metadata: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        url: import("@trezor/schema-utils").TString;
        hash: import("@trezor/schema-utils").TString;
    }>>;
    owners_count: import("@trezor/schema-utils").TNumber;
    relays_count: import("@trezor/schema-utils").TNumber;
}>;
export type CardanoDRep = Static<typeof CardanoDRep>;
export declare const CardanoDRep: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TEnum<typeof CardanoDRepType>;
    key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    script_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoTxCertificate = Static<typeof CardanoTxCertificate>;
export declare const CardanoTxCertificate: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TEnum<typeof CardanoCertificateType>;
    path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    pool: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    pool_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        pool_id: import("@trezor/schema-utils").TString;
        vrf_key_hash: import("@trezor/schema-utils").TString;
        pledge: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        cost: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        margin_numerator: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        margin_denominator: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        reward_account: import("@trezor/schema-utils").TString;
        metadata: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            url: import("@trezor/schema-utils").TString;
            hash: import("@trezor/schema-utils").TString;
        }>>;
        owners_count: import("@trezor/schema-utils").TNumber;
        relays_count: import("@trezor/schema-utils").TNumber;
    }>>;
    script_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    deposit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    drep: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof CardanoDRepType>;
        key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>;
export type CardanoTxWithdrawal = Static<typeof CardanoTxWithdrawal>;
export declare const CardanoTxWithdrawal: import("@trezor/schema-utils").TObject<{
    path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    script_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoCVoteRegistrationDelegation = Static<typeof CardanoCVoteRegistrationDelegation>;
export declare const CardanoCVoteRegistrationDelegation: import("@trezor/schema-utils").TObject<{
    vote_public_key: import("@trezor/schema-utils").TString;
    weight: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export type CardanoCVoteRegistrationParametersType = Static<typeof CardanoCVoteRegistrationParametersType>;
export declare const CardanoCVoteRegistrationParametersType: import("@trezor/schema-utils").TObject<{
    vote_public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    staking_path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    payment_address_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            block_index: import("@trezor/schema-utils").TNumber;
            tx_index: import("@trezor/schema-utils").TNumber;
            certificate_index: import("@trezor/schema-utils").TNumber;
        }>>;
        script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
    nonce: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    format: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof CardanoCVoteRegistrationFormat>>;
    delegations: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        vote_public_key: import("@trezor/schema-utils").TString;
        weight: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>>>;
    voting_purpose: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    payment_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoTxAuxiliaryData = Static<typeof CardanoTxAuxiliaryData>;
export declare const CardanoTxAuxiliaryData: import("@trezor/schema-utils").TObject<{
    cvote_registration_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        vote_public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        staking_path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        payment_address_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                block_index: import("@trezor/schema-utils").TNumber;
                tx_index: import("@trezor/schema-utils").TNumber;
                certificate_index: import("@trezor/schema-utils").TNumber;
            }>>;
            script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
        nonce: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        format: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof CardanoCVoteRegistrationFormat>>;
        delegations: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            vote_public_key: import("@trezor/schema-utils").TString;
            weight: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        }>>>;
        voting_purpose: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        payment_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
    hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoTxMint = Static<typeof CardanoTxMint>;
export declare const CardanoTxMint: import("@trezor/schema-utils").TObject<{
    asset_groups_count: import("@trezor/schema-utils").TNumber;
}>;
export type CardanoTxCollateralInput = Static<typeof CardanoTxCollateralInput>;
export declare const CardanoTxCollateralInput: import("@trezor/schema-utils").TObject<{
    prev_hash: import("@trezor/schema-utils").TString;
    prev_index: import("@trezor/schema-utils").TNumber;
}>;
export type CardanoTxRequiredSigner = Static<typeof CardanoTxRequiredSigner>;
export declare const CardanoTxRequiredSigner: import("@trezor/schema-utils").TObject<{
    key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    key_path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
}>;
export type CardanoTxReferenceInput = Static<typeof CardanoTxReferenceInput>;
export declare const CardanoTxReferenceInput: import("@trezor/schema-utils").TObject<{
    prev_hash: import("@trezor/schema-utils").TString;
    prev_index: import("@trezor/schema-utils").TNumber;
}>;
export type CardanoTxItemAck = Static<typeof CardanoTxItemAck>;
export declare const CardanoTxItemAck: import("@trezor/schema-utils").TObject<{}>;
export type CardanoTxAuxiliaryDataSupplement = Static<typeof CardanoTxAuxiliaryDataSupplement>;
export declare const CardanoTxAuxiliaryDataSupplement: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TEnum<typeof CardanoTxAuxiliaryDataSupplementType>;
    auxiliary_data_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    cvote_registration_signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoTxWitnessRequest = Static<typeof CardanoTxWitnessRequest>;
export declare const CardanoTxWitnessRequest: import("@trezor/schema-utils").TObject<{
    path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
}>;
export type CardanoTxWitnessResponse = Static<typeof CardanoTxWitnessResponse>;
export declare const CardanoTxWitnessResponse: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TEnum<typeof CardanoTxWitnessType>;
    pub_key: import("@trezor/schema-utils").TString;
    signature: import("@trezor/schema-utils").TString;
    chain_code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoTxHostAck = Static<typeof CardanoTxHostAck>;
export declare const CardanoTxHostAck: import("@trezor/schema-utils").TObject<{}>;
export type CardanoTxBodyHash = Static<typeof CardanoTxBodyHash>;
export declare const CardanoTxBodyHash: import("@trezor/schema-utils").TObject<{
    tx_hash: import("@trezor/schema-utils").TString;
}>;
export type CardanoSignTxFinished = Static<typeof CardanoSignTxFinished>;
export declare const CardanoSignTxFinished: import("@trezor/schema-utils").TObject<{}>;
export type CardanoSignMessageInit = Static<typeof CardanoSignMessageInit>;
export declare const CardanoSignMessageInit: import("@trezor/schema-utils").TObject<{
    protocol_magic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    network_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    signing_path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    payload_size: import("@trezor/schema-utils").TNumber;
    prefer_hex_display: import("@trezor/schema-utils").TBoolean;
    address_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            block_index: import("@trezor/schema-utils").TNumber;
            tx_index: import("@trezor/schema-utils").TNumber;
            certificate_index: import("@trezor/schema-utils").TNumber;
        }>>;
        script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
    derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
}>;
export type CardanoMessageDataRequest = Static<typeof CardanoMessageDataRequest>;
export declare const CardanoMessageDataRequest: import("@trezor/schema-utils").TObject<{
    length: import("@trezor/schema-utils").TNumber;
    offset: import("@trezor/schema-utils").TNumber;
}>;
export type CardanoMessageDataResponse = Static<typeof CardanoMessageDataResponse>;
export declare const CardanoMessageDataResponse: import("@trezor/schema-utils").TObject<{
    data: import("@trezor/schema-utils").TString;
}>;
export type CardanoMessageSignature = Static<typeof CardanoMessageSignature>;
export declare const CardanoMessageSignature: import("@trezor/schema-utils").TObject<{
    signature: import("@trezor/schema-utils").TString;
    address: import("@trezor/schema-utils").TString;
    pub_key: import("@trezor/schema-utils").TString;
}>;
export type Success = Static<typeof Success>;
export declare const Success: import("@trezor/schema-utils").TObject<{
    message: import("@trezor/schema-utils").TString;
}>;
export declare enum Enum_FailureType {
    Failure_UnexpectedMessage = 1,
    Failure_ButtonExpected = 2,
    Failure_DataError = 3,
    Failure_ActionCancelled = 4,
    Failure_PinExpected = 5,
    Failure_PinCancelled = 6,
    Failure_PinInvalid = 7,
    Failure_InvalidSignature = 8,
    Failure_ProcessError = 9,
    Failure_NotEnoughFunds = 10,
    Failure_NotInitialized = 11,
    Failure_PinMismatch = 12,
    Failure_WipeCodeMismatch = 13,
    Failure_InvalidSession = 14,
    Failure_Busy = 15,
    Failure_ThpUnallocatedSession = 16,
    Failure_InvalidProtocol = 17,
    Failure_BufferError = 18,
    Failure_FirmwareError = 99
}
export type EnumEnum_FailureType = Static<typeof EnumEnum_FailureType>;
export declare const EnumEnum_FailureType: import("@trezor/schema-utils").TEnum<typeof Enum_FailureType>;
export type FailureType = Static<typeof FailureType>;
export declare const FailureType: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_FailureType>;
export type Failure = Static<typeof Failure>;
export declare const Failure: import("@trezor/schema-utils").TObject<{
    code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_FailureType>>;
    message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export declare enum Enum_ButtonRequestType {
    ButtonRequest_Other = 1,
    ButtonRequest_FeeOverThreshold = 2,
    ButtonRequest_ConfirmOutput = 3,
    ButtonRequest_ResetDevice = 4,
    ButtonRequest_ConfirmWord = 5,
    ButtonRequest_WipeDevice = 6,
    ButtonRequest_ProtectCall = 7,
    ButtonRequest_SignTx = 8,
    ButtonRequest_FirmwareCheck = 9,
    ButtonRequest_Address = 10,
    ButtonRequest_PublicKey = 11,
    ButtonRequest_MnemonicWordCount = 12,
    ButtonRequest_MnemonicInput = 13,
    _Deprecated_ButtonRequest_PassphraseType = 14,
    ButtonRequest_UnknownDerivationPath = 15,
    ButtonRequest_RecoveryHomepage = 16,
    ButtonRequest_Success = 17,
    ButtonRequest_Warning = 18,
    ButtonRequest_PassphraseEntry = 19,
    ButtonRequest_PinEntry = 20
}
export type EnumEnum_ButtonRequestType = Static<typeof EnumEnum_ButtonRequestType>;
export declare const EnumEnum_ButtonRequestType: import("@trezor/schema-utils").TEnum<typeof Enum_ButtonRequestType>;
export type ButtonRequestType = Static<typeof ButtonRequestType>;
export declare const ButtonRequestType: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_ButtonRequestType>;
export type ButtonRequest = Static<typeof ButtonRequest>;
export declare const ButtonRequest: import("@trezor/schema-utils").TObject<{
    code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_ButtonRequestType>>;
    pages: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type ButtonAck = Static<typeof ButtonAck>;
export declare const ButtonAck: import("@trezor/schema-utils").TObject<{}>;
export declare enum Enum_PinMatrixRequestType {
    PinMatrixRequestType_Current = 1,
    PinMatrixRequestType_NewFirst = 2,
    PinMatrixRequestType_NewSecond = 3,
    PinMatrixRequestType_WipeCodeFirst = 4,
    PinMatrixRequestType_WipeCodeSecond = 5
}
export type EnumEnum_PinMatrixRequestType = Static<typeof EnumEnum_PinMatrixRequestType>;
export declare const EnumEnum_PinMatrixRequestType: import("@trezor/schema-utils").TEnum<typeof Enum_PinMatrixRequestType>;
export type PinMatrixRequestType = Static<typeof PinMatrixRequestType>;
export declare const PinMatrixRequestType: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_PinMatrixRequestType>;
export type PinMatrixRequest = Static<typeof PinMatrixRequest>;
export declare const PinMatrixRequest: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_PinMatrixRequestType>>;
}>;
export type PinMatrixAck = Static<typeof PinMatrixAck>;
export declare const PinMatrixAck: import("@trezor/schema-utils").TObject<{
    pin: import("@trezor/schema-utils").TString;
}>;
export type PassphraseRequest = Static<typeof PassphraseRequest>;
export declare const PassphraseRequest: import("@trezor/schema-utils").TObject<{
    _on_device: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type PassphraseAck = Static<typeof PassphraseAck>;
export declare const PassphraseAck: import("@trezor/schema-utils").TObject<{
    passphrase: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    _state: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    on_device: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type Deprecated_PassphraseStateRequest = Static<typeof Deprecated_PassphraseStateRequest>;
export declare const Deprecated_PassphraseStateRequest: import("@trezor/schema-utils").TObject<{
    state: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type Deprecated_PassphraseStateAck = Static<typeof Deprecated_PassphraseStateAck>;
export declare const Deprecated_PassphraseStateAck: import("@trezor/schema-utils").TObject<{}>;
export type CipherKeyValue = Static<typeof CipherKeyValue>;
export declare const CipherKeyValue: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    key: import("@trezor/schema-utils").TString;
    value: import("@trezor/schema-utils").TString;
    encrypt: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    ask_on_encrypt: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    ask_on_decrypt: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    iv: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CipheredKeyValue = Static<typeof CipheredKeyValue>;
export declare const CipheredKeyValue: import("@trezor/schema-utils").TObject<{
    value: import("@trezor/schema-utils").TString;
}>;
export type IdentityType = Static<typeof IdentityType>;
export declare const IdentityType: import("@trezor/schema-utils").TObject<{
    proto: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    user: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    port: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type SignIdentity = Static<typeof SignIdentity>;
export declare const SignIdentity: import("@trezor/schema-utils").TObject<{
    identity: import("@trezor/schema-utils").TObject<{
        proto: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        user: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        port: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    challenge_hidden: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    challenge_visual: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    ecdsa_curve_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type SignedIdentity = Static<typeof SignedIdentity>;
export declare const SignedIdentity: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    public_key: import("@trezor/schema-utils").TString;
    signature: import("@trezor/schema-utils").TString;
}>;
export type GetECDHSessionKey = Static<typeof GetECDHSessionKey>;
export declare const GetECDHSessionKey: import("@trezor/schema-utils").TObject<{
    identity: import("@trezor/schema-utils").TObject<{
        proto: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        user: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        port: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    peer_public_key: import("@trezor/schema-utils").TString;
    ecdsa_curve_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type ECDHSessionKey = Static<typeof ECDHSessionKey>;
export declare const ECDHSessionKey: import("@trezor/schema-utils").TObject<{
    session_key: import("@trezor/schema-utils").TString;
    public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type PaymentNotification = Static<typeof PaymentNotification>;
export declare const PaymentNotification: import("@trezor/schema-utils").TObject<{
    payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        recipient_name: import("@trezor/schema-utils").TString;
        memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                text: import("@trezor/schema-utils").TString;
            }>>;
            refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                coin_type: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils").TString;
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
        }>>>;
        amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        signature: import("@trezor/schema-utils").TString;
    }>>;
}>;
export declare enum DebugButton {
    NO = 0,
    YES = 1,
    INFO = 2
}
export type EnumDebugButton = Static<typeof EnumDebugButton>;
export declare const EnumDebugButton: import("@trezor/schema-utils").TEnum<typeof DebugButton>;
export declare enum DebugPhysicalButton {
    LEFT_BTN = 0,
    MIDDLE_BTN = 1,
    RIGHT_BTN = 2
}
export type EnumDebugPhysicalButton = Static<typeof EnumDebugPhysicalButton>;
export declare const EnumDebugPhysicalButton: import("@trezor/schema-utils").TEnum<typeof DebugPhysicalButton>;
export declare enum DebugTouchEventType {
    TOUCH_FULL_CLICK = 0,
    TOUCH_START = 1,
    TOUCH_END = 2
}
export type EnumDebugTouchEventType = Static<typeof EnumDebugTouchEventType>;
export declare const EnumDebugTouchEventType: import("@trezor/schema-utils").TEnum<typeof DebugTouchEventType>;
export declare enum DebugWaitType {
    IMMEDIATE = 0,
    NEXT_LAYOUT = 1,
    CURRENT_LAYOUT = 2
}
export type EnumDebugWaitType = Static<typeof EnumDebugWaitType>;
export declare const EnumDebugWaitType: import("@trezor/schema-utils").TEnum<typeof DebugWaitType>;
export type DebugLinkGetPairingInfo = Static<typeof DebugLinkGetPairingInfo>;
export declare const DebugLinkGetPairingInfo: import("@trezor/schema-utils").TObject<{
    channel_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    handshake_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    nfc_secret_host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type DebugLinkPairingInfo = Static<typeof DebugLinkPairingInfo>;
export declare const DebugLinkPairingInfo: import("@trezor/schema-utils").TObject<{
    channel_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    handshake_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    code_entry_code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    code_qr_code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    nfc_secret_trezor: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type DebugLinkResetDebugEvents = Static<typeof DebugLinkResetDebugEvents>;
export declare const DebugLinkResetDebugEvents: import("@trezor/schema-utils").TObject<{}>;
export type DebugLinkOptigaSetSecMax = Static<typeof DebugLinkOptigaSetSecMax>;
export declare const DebugLinkOptigaSetSecMax: import("@trezor/schema-utils").TObject<{}>;
export type DebugLinkGetGcInfo = Static<typeof DebugLinkGetGcInfo>;
export declare const DebugLinkGetGcInfo: import("@trezor/schema-utils").TObject<{}>;
export type DebugLinkGcInfoItem = Static<typeof DebugLinkGcInfoItem>;
export declare const DebugLinkGcInfoItem: import("@trezor/schema-utils").TObject<{
    name: import("@trezor/schema-utils").TString;
    value: import("@trezor/schema-utils").TNumber;
}>;
export type DebugLinkGcInfo = Static<typeof DebugLinkGcInfo>;
export declare const DebugLinkGcInfo: import("@trezor/schema-utils").TObject<{
    items: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        name: import("@trezor/schema-utils").TString;
        value: import("@trezor/schema-utils").TNumber;
    }>>;
}>;
export declare enum DefinitionType {
    ETHEREUM_NETWORK = 0,
    ETHEREUM_TOKEN = 1,
    SOLANA_TOKEN = 2
}
export type EnumDefinitionType = Static<typeof EnumDefinitionType>;
export declare const EnumDefinitionType: import("@trezor/schema-utils").TEnum<typeof DefinitionType>;
export type EthereumNetworkInfo = Static<typeof EthereumNetworkInfo>;
export declare const EthereumNetworkInfo: import("@trezor/schema-utils").TObject<{
    chain_id: import("@trezor/schema-utils").TNumber;
    symbol: import("@trezor/schema-utils").TString;
    slip44: import("@trezor/schema-utils").TNumber;
    name: import("@trezor/schema-utils").TString;
}>;
export type EthereumTokenInfo = Static<typeof EthereumTokenInfo>;
export declare const EthereumTokenInfo: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    chain_id: import("@trezor/schema-utils").TNumber;
    symbol: import("@trezor/schema-utils").TString;
    decimals: import("@trezor/schema-utils").TNumber;
    name: import("@trezor/schema-utils").TString;
}>;
export type SolanaTokenInfo = Static<typeof SolanaTokenInfo>;
export declare const SolanaTokenInfo: import("@trezor/schema-utils").TObject<{
    mint: import("@trezor/schema-utils").TString;
    symbol: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
}>;
export type EosGetPublicKey = Static<typeof EosGetPublicKey>;
export declare const EosGetPublicKey: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type EosPublicKey = Static<typeof EosPublicKey>;
export declare const EosPublicKey: import("@trezor/schema-utils").TObject<{
    wif_public_key: import("@trezor/schema-utils").TString;
    raw_public_key: import("@trezor/schema-utils").TString;
}>;
export type EosTxHeader = Static<typeof EosTxHeader>;
export declare const EosTxHeader: import("@trezor/schema-utils").TObject<{
    expiration: import("@trezor/schema-utils").TNumber;
    ref_block_num: import("@trezor/schema-utils").TNumber;
    ref_block_prefix: import("@trezor/schema-utils").TNumber;
    max_net_usage_words: import("@trezor/schema-utils").TNumber;
    max_cpu_usage_ms: import("@trezor/schema-utils").TNumber;
    delay_sec: import("@trezor/schema-utils").TNumber;
}>;
export type EosSignTx = Static<typeof EosSignTx>;
export declare const EosSignTx: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    chain_id: import("@trezor/schema-utils").TString;
    header: import("@trezor/schema-utils").TObject<{
        expiration: import("@trezor/schema-utils").TNumber;
        ref_block_num: import("@trezor/schema-utils").TNumber;
        ref_block_prefix: import("@trezor/schema-utils").TNumber;
        max_net_usage_words: import("@trezor/schema-utils").TNumber;
        max_cpu_usage_ms: import("@trezor/schema-utils").TNumber;
        delay_sec: import("@trezor/schema-utils").TNumber;
    }>;
    num_actions: import("@trezor/schema-utils").TNumber;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type EosTxActionRequest = Static<typeof EosTxActionRequest>;
export declare const EosTxActionRequest: import("@trezor/schema-utils").TObject<{
    data_size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type EosAsset = Static<typeof EosAsset>;
export declare const EosAsset: import("@trezor/schema-utils").TObject<{
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    symbol: import("@trezor/schema-utils").TString;
}>;
export type EosPermissionLevel = Static<typeof EosPermissionLevel>;
export declare const EosPermissionLevel: import("@trezor/schema-utils").TObject<{
    actor: import("@trezor/schema-utils").TString;
    permission: import("@trezor/schema-utils").TString;
}>;
export type EosAuthorizationKey = Static<typeof EosAuthorizationKey>;
export declare const EosAuthorizationKey: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    key: import("@trezor/schema-utils").TString;
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    weight: import("@trezor/schema-utils").TNumber;
}>;
export type EosAuthorizationAccount = Static<typeof EosAuthorizationAccount>;
export declare const EosAuthorizationAccount: import("@trezor/schema-utils").TObject<{
    account: import("@trezor/schema-utils").TObject<{
        actor: import("@trezor/schema-utils").TString;
        permission: import("@trezor/schema-utils").TString;
    }>;
    weight: import("@trezor/schema-utils").TNumber;
}>;
export type EosAuthorizationWait = Static<typeof EosAuthorizationWait>;
export declare const EosAuthorizationWait: import("@trezor/schema-utils").TObject<{
    wait_sec: import("@trezor/schema-utils").TNumber;
    weight: import("@trezor/schema-utils").TNumber;
}>;
export type EosAuthorization = Static<typeof EosAuthorization>;
export declare const EosAuthorization: import("@trezor/schema-utils").TObject<{
    threshold: import("@trezor/schema-utils").TNumber;
    keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        key: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        weight: import("@trezor/schema-utils").TNumber;
    }>>;
    accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TObject<{
            actor: import("@trezor/schema-utils").TString;
            permission: import("@trezor/schema-utils").TString;
        }>;
        weight: import("@trezor/schema-utils").TNumber;
    }>>;
    waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        wait_sec: import("@trezor/schema-utils").TNumber;
        weight: import("@trezor/schema-utils").TNumber;
    }>>;
}>;
export type EosActionCommon = Static<typeof EosActionCommon>;
export declare const EosActionCommon: import("@trezor/schema-utils").TObject<{
    account: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
    authorization: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        actor: import("@trezor/schema-utils").TString;
        permission: import("@trezor/schema-utils").TString;
    }>>;
}>;
export type EosActionTransfer = Static<typeof EosActionTransfer>;
export declare const EosActionTransfer: import("@trezor/schema-utils").TObject<{
    sender: import("@trezor/schema-utils").TString;
    receiver: import("@trezor/schema-utils").TString;
    quantity: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        symbol: import("@trezor/schema-utils").TString;
    }>;
    memo: import("@trezor/schema-utils").TString;
}>;
export type EosActionDelegate = Static<typeof EosActionDelegate>;
export declare const EosActionDelegate: import("@trezor/schema-utils").TObject<{
    sender: import("@trezor/schema-utils").TString;
    receiver: import("@trezor/schema-utils").TString;
    net_quantity: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        symbol: import("@trezor/schema-utils").TString;
    }>;
    cpu_quantity: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        symbol: import("@trezor/schema-utils").TString;
    }>;
    transfer: import("@trezor/schema-utils").TBoolean;
}>;
export type EosActionUndelegate = Static<typeof EosActionUndelegate>;
export declare const EosActionUndelegate: import("@trezor/schema-utils").TObject<{
    sender: import("@trezor/schema-utils").TString;
    receiver: import("@trezor/schema-utils").TString;
    net_quantity: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        symbol: import("@trezor/schema-utils").TString;
    }>;
    cpu_quantity: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        symbol: import("@trezor/schema-utils").TString;
    }>;
}>;
export type EosActionRefund = Static<typeof EosActionRefund>;
export declare const EosActionRefund: import("@trezor/schema-utils").TObject<{
    owner: import("@trezor/schema-utils").TString;
}>;
export type EosActionBuyRam = Static<typeof EosActionBuyRam>;
export declare const EosActionBuyRam: import("@trezor/schema-utils").TObject<{
    payer: import("@trezor/schema-utils").TString;
    receiver: import("@trezor/schema-utils").TString;
    quantity: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        symbol: import("@trezor/schema-utils").TString;
    }>;
}>;
export type EosActionBuyRamBytes = Static<typeof EosActionBuyRamBytes>;
export declare const EosActionBuyRamBytes: import("@trezor/schema-utils").TObject<{
    payer: import("@trezor/schema-utils").TString;
    receiver: import("@trezor/schema-utils").TString;
    bytes: import("@trezor/schema-utils").TNumber;
}>;
export type EosActionSellRam = Static<typeof EosActionSellRam>;
export declare const EosActionSellRam: import("@trezor/schema-utils").TObject<{
    account: import("@trezor/schema-utils").TString;
    bytes: import("@trezor/schema-utils").TNumber;
}>;
export type EosActionVoteProducer = Static<typeof EosActionVoteProducer>;
export declare const EosActionVoteProducer: import("@trezor/schema-utils").TObject<{
    voter: import("@trezor/schema-utils").TString;
    proxy: import("@trezor/schema-utils").TString;
    producers: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
}>;
export type EosActionUpdateAuth = Static<typeof EosActionUpdateAuth>;
export declare const EosActionUpdateAuth: import("@trezor/schema-utils").TObject<{
    account: import("@trezor/schema-utils").TString;
    permission: import("@trezor/schema-utils").TString;
    parent: import("@trezor/schema-utils").TString;
    auth: import("@trezor/schema-utils").TObject<{
        threshold: import("@trezor/schema-utils").TNumber;
        keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            key: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
        accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TObject<{
                actor: import("@trezor/schema-utils").TString;
                permission: import("@trezor/schema-utils").TString;
            }>;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
        waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            wait_sec: import("@trezor/schema-utils").TNumber;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
    }>;
}>;
export type EosActionDeleteAuth = Static<typeof EosActionDeleteAuth>;
export declare const EosActionDeleteAuth: import("@trezor/schema-utils").TObject<{
    account: import("@trezor/schema-utils").TString;
    permission: import("@trezor/schema-utils").TString;
}>;
export type EosActionLinkAuth = Static<typeof EosActionLinkAuth>;
export declare const EosActionLinkAuth: import("@trezor/schema-utils").TObject<{
    account: import("@trezor/schema-utils").TString;
    code: import("@trezor/schema-utils").TString;
    type: import("@trezor/schema-utils").TString;
    requirement: import("@trezor/schema-utils").TString;
}>;
export type EosActionUnlinkAuth = Static<typeof EosActionUnlinkAuth>;
export declare const EosActionUnlinkAuth: import("@trezor/schema-utils").TObject<{
    account: import("@trezor/schema-utils").TString;
    code: import("@trezor/schema-utils").TString;
    type: import("@trezor/schema-utils").TString;
}>;
export type EosActionNewAccount = Static<typeof EosActionNewAccount>;
export declare const EosActionNewAccount: import("@trezor/schema-utils").TObject<{
    creator: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
    owner: import("@trezor/schema-utils").TObject<{
        threshold: import("@trezor/schema-utils").TNumber;
        keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            key: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
        accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TObject<{
                actor: import("@trezor/schema-utils").TString;
                permission: import("@trezor/schema-utils").TString;
            }>;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
        waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            wait_sec: import("@trezor/schema-utils").TNumber;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
    }>;
    active: import("@trezor/schema-utils").TObject<{
        threshold: import("@trezor/schema-utils").TNumber;
        keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            key: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
        accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TObject<{
                actor: import("@trezor/schema-utils").TString;
                permission: import("@trezor/schema-utils").TString;
            }>;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
        waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            wait_sec: import("@trezor/schema-utils").TNumber;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
    }>;
}>;
export type EosActionUnknown = Static<typeof EosActionUnknown>;
export declare const EosActionUnknown: import("@trezor/schema-utils").TObject<{
    data_size: import("@trezor/schema-utils").TNumber;
    data_chunk: import("@trezor/schema-utils").TString;
}>;
export type EosTxActionAck = Static<typeof EosTxActionAck>;
export declare const EosTxActionAck: import("@trezor/schema-utils").TObject<{
    common: import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
        authorization: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            actor: import("@trezor/schema-utils").TString;
            permission: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        sender: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
        memo: import("@trezor/schema-utils").TString;
    }>>;
    delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        sender: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        net_quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
        cpu_quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
        transfer: import("@trezor/schema-utils").TBoolean;
    }>>;
    undelegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        sender: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        net_quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
        cpu_quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
    }>>;
    refund: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        owner: import("@trezor/schema-utils").TString;
    }>>;
    buy_ram: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        payer: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
    }>>;
    buy_ram_bytes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        payer: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        bytes: import("@trezor/schema-utils").TNumber;
    }>>;
    sell_ram: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        bytes: import("@trezor/schema-utils").TNumber;
    }>>;
    vote_producer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        voter: import("@trezor/schema-utils").TString;
        proxy: import("@trezor/schema-utils").TString;
        producers: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
    update_auth: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        permission: import("@trezor/schema-utils").TString;
        parent: import("@trezor/schema-utils").TString;
        auth: import("@trezor/schema-utils").TObject<{
            threshold: import("@trezor/schema-utils").TNumber;
            keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                key: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                account: import("@trezor/schema-utils").TObject<{
                    actor: import("@trezor/schema-utils").TString;
                    permission: import("@trezor/schema-utils").TString;
                }>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                wait_sec: import("@trezor/schema-utils").TNumber;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
        }>;
    }>>;
    delete_auth: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        permission: import("@trezor/schema-utils").TString;
    }>>;
    link_auth: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        code: import("@trezor/schema-utils").TString;
        type: import("@trezor/schema-utils").TString;
        requirement: import("@trezor/schema-utils").TString;
    }>>;
    unlink_auth: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        code: import("@trezor/schema-utils").TString;
        type: import("@trezor/schema-utils").TString;
    }>>;
    new_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        creator: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
        owner: import("@trezor/schema-utils").TObject<{
            threshold: import("@trezor/schema-utils").TNumber;
            keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                key: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                account: import("@trezor/schema-utils").TObject<{
                    actor: import("@trezor/schema-utils").TString;
                    permission: import("@trezor/schema-utils").TString;
                }>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                wait_sec: import("@trezor/schema-utils").TNumber;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
        }>;
        active: import("@trezor/schema-utils").TObject<{
            threshold: import("@trezor/schema-utils").TNumber;
            keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                key: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                account: import("@trezor/schema-utils").TObject<{
                    actor: import("@trezor/schema-utils").TString;
                    permission: import("@trezor/schema-utils").TString;
                }>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                wait_sec: import("@trezor/schema-utils").TNumber;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
        }>;
    }>>;
    unknown: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        data_size: import("@trezor/schema-utils").TNumber;
        data_chunk: import("@trezor/schema-utils").TString;
    }>>;
}>;
export type EosSignedTx = Static<typeof EosSignedTx>;
export declare const EosSignedTx: import("@trezor/schema-utils").TObject<{
    signature: import("@trezor/schema-utils").TString;
}>;
export type EthereumDefinitions = Static<typeof EthereumDefinitions>;
export declare const EthereumDefinitions: import("@trezor/schema-utils").TObject<{
    encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
}>;
export type EthereumSignTypedData = Static<typeof EthereumSignTypedData>;
export declare const EthereumSignTypedData: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    primary_type: import("@trezor/schema-utils").TString;
    metamask_v4_compat: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    definitions: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    }>>;
    show_message_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type EthereumTypedDataStructRequest = Static<typeof EthereumTypedDataStructRequest>;
export declare const EthereumTypedDataStructRequest: import("@trezor/schema-utils").TObject<{
    name: import("@trezor/schema-utils").TString;
}>;
export declare enum EthereumDataType {
    UINT = 1,
    INT = 2,
    BYTES = 3,
    STRING = 4,
    BOOL = 5,
    ADDRESS = 6,
    ARRAY = 7,
    STRUCT = 8
}
export type EnumEthereumDataType = Static<typeof EnumEthereumDataType>;
export declare const EnumEthereumDataType: import("@trezor/schema-utils").TEnum<typeof EthereumDataType>;
export type EthereumFieldType = Static<typeof EthereumFieldType>;
export declare const EthereumFieldType: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
    data_type: import("@trezor/schema-utils").TEnum<typeof EthereumDataType>;
    size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    entry_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TThis>;
    struct_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>>;
export type EthereumStructMember = Static<typeof EthereumStructMember>;
export declare const EthereumStructMember: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
        data_type: import("@trezor/schema-utils").TEnum<typeof EthereumDataType>;
        size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        entry_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TThis>;
        struct_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
    name: import("@trezor/schema-utils").TString;
}>;
export type EthereumTypedDataStructAck = Static<typeof EthereumTypedDataStructAck>;
export declare const EthereumTypedDataStructAck: import("@trezor/schema-utils").TObject<{
    members: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
            data_type: import("@trezor/schema-utils").TEnum<typeof EthereumDataType>;
            size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            entry_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TThis>;
            struct_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
        name: import("@trezor/schema-utils").TString;
    }>>;
}>;
export type EthereumTypedDataValueRequest = Static<typeof EthereumTypedDataValueRequest>;
export declare const EthereumTypedDataValueRequest: import("@trezor/schema-utils").TObject<{
    member_path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
}>;
export type EthereumTypedDataValueAck = Static<typeof EthereumTypedDataValueAck>;
export declare const EthereumTypedDataValueAck: import("@trezor/schema-utils").TObject<{
    value: import("@trezor/schema-utils").TString;
}>;
export type EthereumGetPublicKey = Static<typeof EthereumGetPublicKey>;
export declare const EthereumGetPublicKey: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type EthereumPublicKey = Static<typeof EthereumPublicKey>;
export declare const EthereumPublicKey: import("@trezor/schema-utils").TObject<{
    node: import("@trezor/schema-utils").TObject<{
        depth: import("@trezor/schema-utils").TNumber;
        fingerprint: import("@trezor/schema-utils").TNumber;
        child_num: import("@trezor/schema-utils").TNumber;
        chain_code: import("@trezor/schema-utils").TString;
        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        public_key: import("@trezor/schema-utils").TString;
    }>;
    xpub: import("@trezor/schema-utils").TString;
}>;
export type EthereumGetAddress = Static<typeof EthereumGetAddress>;
export declare const EthereumGetAddress: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type EthereumAddress = Static<typeof EthereumAddress>;
export declare const EthereumAddress: import("@trezor/schema-utils").TObject<{
    _old_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    address: import("@trezor/schema-utils").TString;
    mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type EthereumSignTx = Static<typeof EthereumSignTx>;
export declare const EthereumSignTx: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    gas_price: import("@trezor/schema-utils").TString;
    gas_limit: import("@trezor/schema-utils").TString;
    to: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    value: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    data_initial_chunk: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    data_length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    chain_id: import("@trezor/schema-utils").TNumber;
    tx_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    definitions: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    }>>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        recipient_name: import("@trezor/schema-utils").TString;
        memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                text: import("@trezor/schema-utils").TString;
            }>>;
            refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                coin_type: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils").TString;
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
        }>>>;
        amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        signature: import("@trezor/schema-utils").TString;
    }>>;
}>;
export type EthereumAccessList = Static<typeof EthereumAccessList>;
export declare const EthereumAccessList: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    storage_keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
}>;
export type EthereumSignTxEIP1559 = Static<typeof EthereumSignTxEIP1559>;
export declare const EthereumSignTxEIP1559: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    nonce: import("@trezor/schema-utils").TString;
    max_gas_fee: import("@trezor/schema-utils").TString;
    max_priority_fee: import("@trezor/schema-utils").TString;
    gas_limit: import("@trezor/schema-utils").TString;
    to: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    value: import("@trezor/schema-utils").TString;
    data_initial_chunk: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    data_length: import("@trezor/schema-utils").TNumber;
    chain_id: import("@trezor/schema-utils").TNumber;
    access_list: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        storage_keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
    definitions: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    }>>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        recipient_name: import("@trezor/schema-utils").TString;
        memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                text: import("@trezor/schema-utils").TString;
            }>>;
            refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                coin_type: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils").TString;
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
        }>>>;
        amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        signature: import("@trezor/schema-utils").TString;
    }>>;
}>;
export type EthereumTxRequest = Static<typeof EthereumTxRequest>;
export declare const EthereumTxRequest: import("@trezor/schema-utils").TObject<{
    data_length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    signature_v: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    signature_r: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    signature_s: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type EthereumTxAck = Static<typeof EthereumTxAck>;
export declare const EthereumTxAck: import("@trezor/schema-utils").TObject<{
    data_chunk: import("@trezor/schema-utils").TString;
}>;
export type EthereumSignMessage = Static<typeof EthereumSignMessage>;
export declare const EthereumSignMessage: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    message: import("@trezor/schema-utils").TString;
    encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type EthereumMessageSignature = Static<typeof EthereumMessageSignature>;
export declare const EthereumMessageSignature: import("@trezor/schema-utils").TObject<{
    signature: import("@trezor/schema-utils").TString;
    address: import("@trezor/schema-utils").TString;
}>;
export type EthereumVerifyMessage = Static<typeof EthereumVerifyMessage>;
export declare const EthereumVerifyMessage: import("@trezor/schema-utils").TObject<{
    signature: import("@trezor/schema-utils").TString;
    message: import("@trezor/schema-utils").TString;
    address: import("@trezor/schema-utils").TString;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type EthereumSignTypedHash = Static<typeof EthereumSignTypedHash>;
export declare const EthereumSignTypedHash: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    domain_separator_hash: import("@trezor/schema-utils").TString;
    message_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
}>;
export type EthereumTypedDataSignature = Static<typeof EthereumTypedDataSignature>;
export declare const EthereumTypedDataSignature: import("@trezor/schema-utils").TObject<{
    signature: import("@trezor/schema-utils").TString;
    address: import("@trezor/schema-utils").TString;
}>;
export type EvoluGetNode = Static<typeof EvoluGetNode>;
export declare const EvoluGetNode: import("@trezor/schema-utils").TObject<{}>;
export type EvoluNode = Static<typeof EvoluNode>;
export declare const EvoluNode: import("@trezor/schema-utils").TObject<{
    data: import("@trezor/schema-utils").TString;
}>;
export declare enum Enum_BackupType {
    Bip39 = 0,
    Slip39_Basic = 1,
    Slip39_Advanced = 2,
    Slip39_Single_Extendable = 3,
    Slip39_Basic_Extendable = 4,
    Slip39_Advanced_Extendable = 5
}
export type EnumEnum_BackupType = Static<typeof EnumEnum_BackupType>;
export declare const EnumEnum_BackupType: import("@trezor/schema-utils").TEnum<typeof Enum_BackupType>;
export type BackupType = Static<typeof BackupType>;
export declare const BackupType: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_BackupType>;
export declare enum Enum_SafetyCheckLevel {
    Strict = 0,
    PromptAlways = 1,
    PromptTemporarily = 2
}
export type EnumEnum_SafetyCheckLevel = Static<typeof EnumEnum_SafetyCheckLevel>;
export declare const EnumEnum_SafetyCheckLevel: import("@trezor/schema-utils").TEnum<typeof Enum_SafetyCheckLevel>;
export type SafetyCheckLevel = Static<typeof SafetyCheckLevel>;
export declare const SafetyCheckLevel: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_SafetyCheckLevel>;
export declare enum Enum_DisplayRotation {
    North = 0,
    East = 90,
    South = 180,
    West = 270
}
export type EnumEnum_DisplayRotation = Static<typeof EnumEnum_DisplayRotation>;
export declare const EnumEnum_DisplayRotation: import("@trezor/schema-utils").TEnum<typeof Enum_DisplayRotation>;
export type DisplayRotation = Static<typeof DisplayRotation>;
export declare const DisplayRotation: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_DisplayRotation>;
export declare enum Enum_HomescreenFormat {
    Toif = 1,
    Jpeg = 2,
    ToiG = 3
}
export type EnumEnum_HomescreenFormat = Static<typeof EnumEnum_HomescreenFormat>;
export declare const EnumEnum_HomescreenFormat: import("@trezor/schema-utils").TEnum<typeof Enum_HomescreenFormat>;
export type HomescreenFormat = Static<typeof HomescreenFormat>;
export declare const HomescreenFormat: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_HomescreenFormat>;
export type Initialize = Static<typeof Initialize>;
export declare const Initialize: import("@trezor/schema-utils").TObject<{
    session_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    _skip_passphrase: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    derive_cardano: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type GetFeatures = Static<typeof GetFeatures>;
export declare const GetFeatures: import("@trezor/schema-utils").TObject<{}>;
export declare enum Enum_BackupAvailability {
    NotAvailable = 0,
    Required = 1,
    Available = 2
}
export type EnumEnum_BackupAvailability = Static<typeof EnumEnum_BackupAvailability>;
export declare const EnumEnum_BackupAvailability: import("@trezor/schema-utils").TEnum<typeof Enum_BackupAvailability>;
export type BackupAvailability = Static<typeof BackupAvailability>;
export declare const BackupAvailability: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_BackupAvailability>;
export declare enum Enum_RecoveryStatus {
    Nothing = 0,
    Recovery = 1,
    Backup = 2
}
export type EnumEnum_RecoveryStatus = Static<typeof EnumEnum_RecoveryStatus>;
export declare const EnumEnum_RecoveryStatus: import("@trezor/schema-utils").TEnum<typeof Enum_RecoveryStatus>;
export type RecoveryStatus = Static<typeof RecoveryStatus>;
export declare const RecoveryStatus: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RecoveryStatus>;
export declare enum Enum_Capability {
    Capability_Bitcoin = 1,
    Capability_Bitcoin_like = 2,
    Capability_Binance = 3,
    Capability_Cardano = 4,
    Capability_Crypto = 5,
    Capability_EOS = 6,
    Capability_Ethereum = 7,
    Capability_Lisk = 8,
    Capability_Monero = 9,
    Capability_NEM = 10,
    Capability_Ripple = 11,
    Capability_Stellar = 12,
    Capability_Tezos = 13,
    Capability_U2F = 14,
    Capability_Shamir = 15,
    Capability_ShamirGroups = 16,
    Capability_PassphraseEntry = 17,
    Capability_Solana = 18,
    Capability_Translations = 19,
    Capability_Brightness = 20,
    Capability_Haptic = 21,
    Capability_BLE = 22,
    Capability_NFC = 23
}
export type EnumEnum_Capability = Static<typeof EnumEnum_Capability>;
export declare const EnumEnum_Capability: import("@trezor/schema-utils").TEnum<typeof Enum_Capability>;
export type Capability = Static<typeof Capability>;
export declare const Capability: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_Capability>;
export declare enum RecoveryDeviceInputMethod {
    ScrambledWords = 0,
    Matrix = 1
}
export type EnumRecoveryDeviceInputMethod = Static<typeof EnumRecoveryDeviceInputMethod>;
export declare const EnumRecoveryDeviceInputMethod: import("@trezor/schema-utils").TEnum<typeof RecoveryDeviceInputMethod>;
export declare enum Enum_RecoveryType {
    NormalRecovery = 0,
    DryRun = 1,
    UnlockRepeatedBackup = 2
}
export type EnumEnum_RecoveryType = Static<typeof EnumEnum_RecoveryType>;
export declare const EnumEnum_RecoveryType: import("@trezor/schema-utils").TEnum<typeof Enum_RecoveryType>;
export type RecoveryType = Static<typeof RecoveryType>;
export declare const RecoveryType: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RecoveryType>;
export type RecoveryDevice = Static<typeof RecoveryDevice>;
export declare const RecoveryDevice: import("@trezor/schema-utils").TObject<{
    word_count: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    passphrase_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    pin_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    enforce_wordlist: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    input_method: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof RecoveryDeviceInputMethod>>;
    u2f_counter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RecoveryType>>;
}>;
export type Features = Static<typeof Features>;
export declare const Features: import("@trezor/schema-utils").TObject<{
    vendor: import("@trezor/schema-utils").TString;
    major_version: import("@trezor/schema-utils").TNumber;
    minor_version: import("@trezor/schema-utils").TNumber;
    patch_version: import("@trezor/schema-utils").TNumber;
    bootloader_mode: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    device_id: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
    pin_protection: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    passphrase_protection: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    language: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
    label: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
    initialized: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    revision: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
    bootloader_hash: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
    imported: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    unlocked: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    _passphrase_cached: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    firmware_present: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    backup_availability: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_BackupAvailability>, import("@trezor/schema-utils").TNull]>;
    flags: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
    model: import("@trezor/schema-utils").TString;
    fw_major: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
    fw_minor: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
    fw_patch: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
    fw_vendor: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
    unfinished_backup: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    no_backup: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    recovery_status: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RecoveryStatus>, import("@trezor/schema-utils").TNull]>;
    capabilities: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_Capability>>;
    backup_type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_BackupType>, import("@trezor/schema-utils").TNull]>;
    sd_card_present: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    sd_protection: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    wipe_code_protection: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    session_id: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
    passphrase_always_on_device: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    safety_checks: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_SafetyCheckLevel>, import("@trezor/schema-utils").TNull]>;
    auto_lock_delay_ms: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
    display_rotation: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_DisplayRotation>, import("@trezor/schema-utils").TNull]>;
    experimental_features: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
    busy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    homescreen_format: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_HomescreenFormat>>;
    hide_passphrase_from_host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    internal_model: import("@trezor/schema-utils").TEnum<typeof DeviceModelInternal>;
    unit_color: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    unit_btconly: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    homescreen_width: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    homescreen_height: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    bootloader_locked: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    language_version_matches: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    unit_packaging: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    haptic_feedback: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    recovery_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RecoveryType>>;
    optiga_sec: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    soc: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type LockDevice = Static<typeof LockDevice>;
export declare const LockDevice: import("@trezor/schema-utils").TObject<{}>;
export type SetBusy = Static<typeof SetBusy>;
export declare const SetBusy: import("@trezor/schema-utils").TObject<{
    expiry_ms: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type EndSession = Static<typeof EndSession>;
export declare const EndSession: import("@trezor/schema-utils").TObject<{}>;
export type ApplySettings = Static<typeof ApplySettings>;
export declare const ApplySettings: import("@trezor/schema-utils").TObject<{
    language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    use_passphrase: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    homescreen: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    _passphrase_source: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    auto_lock_delay_ms: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    display_rotation: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_DisplayRotation>, import("@trezor/schema-utils").TEnum<typeof Enum_DisplayRotation>]>>;
    passphrase_always_on_device: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    safety_checks: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_SafetyCheckLevel>>;
    experimental_features: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    hide_passphrase_from_host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    haptic_feedback: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    homescreen_length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type ChangeLanguage = Static<typeof ChangeLanguage>;
export declare const ChangeLanguage: import("@trezor/schema-utils").TObject<{
    data_length: import("@trezor/schema-utils").TNumber;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type DataChunkRequest = Static<typeof DataChunkRequest>;
export declare const DataChunkRequest: import("@trezor/schema-utils").TObject<{
    data_length: import("@trezor/schema-utils").TNumber;
    data_offset: import("@trezor/schema-utils").TNumber;
}>;
export type DataChunkAck = Static<typeof DataChunkAck>;
export declare const DataChunkAck: import("@trezor/schema-utils").TObject<{
    data_chunk: import("@trezor/schema-utils").TString;
}>;
export type ApplyFlags = Static<typeof ApplyFlags>;
export declare const ApplyFlags: import("@trezor/schema-utils").TObject<{
    flags: import("@trezor/schema-utils").TNumber;
}>;
export type ChangePin = Static<typeof ChangePin>;
export declare const ChangePin: import("@trezor/schema-utils").TObject<{
    remove: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type ChangeWipeCode = Static<typeof ChangeWipeCode>;
export declare const ChangeWipeCode: import("@trezor/schema-utils").TObject<{
    remove: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export declare enum SdProtectOperationType {
    DISABLE = 0,
    ENABLE = 1,
    REFRESH = 2
}
export type EnumSdProtectOperationType = Static<typeof EnumSdProtectOperationType>;
export declare const EnumSdProtectOperationType: import("@trezor/schema-utils").TEnum<typeof SdProtectOperationType>;
export type SdProtect = Static<typeof SdProtect>;
export declare const SdProtect: import("@trezor/schema-utils").TObject<{
    operation: import("@trezor/schema-utils").TEnum<typeof SdProtectOperationType>;
}>;
export type Ping = Static<typeof Ping>;
export declare const Ping: import("@trezor/schema-utils").TObject<{
    message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    button_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type Cancel = Static<typeof Cancel>;
export declare const Cancel: import("@trezor/schema-utils").TObject<{}>;
export type GetEntropy = Static<typeof GetEntropy>;
export declare const GetEntropy: import("@trezor/schema-utils").TObject<{
    size: import("@trezor/schema-utils").TNumber;
}>;
export type Entropy = Static<typeof Entropy>;
export declare const Entropy: import("@trezor/schema-utils").TObject<{
    entropy: import("@trezor/schema-utils").TString;
}>;
export type GetFirmwareHash = Static<typeof GetFirmwareHash>;
export declare const GetFirmwareHash: import("@trezor/schema-utils").TObject<{
    challenge: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type FirmwareHash = Static<typeof FirmwareHash>;
export declare const FirmwareHash: import("@trezor/schema-utils").TObject<{
    hash: import("@trezor/schema-utils").TString;
}>;
export type AuthenticateDevice = Static<typeof AuthenticateDevice>;
export declare const AuthenticateDevice: import("@trezor/schema-utils").TObject<{
    challenge: import("@trezor/schema-utils").TString;
}>;
export type AuthenticityProof = Static<typeof AuthenticityProof>;
export declare const AuthenticityProof: import("@trezor/schema-utils").TObject<{
    certificates: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    signature: import("@trezor/schema-utils").TString;
}>;
export type WipeDevice = Static<typeof WipeDevice>;
export declare const WipeDevice: import("@trezor/schema-utils").TObject<{}>;
export type LoadDevice = Static<typeof LoadDevice>;
export declare const LoadDevice: import("@trezor/schema-utils").TObject<{
    mnemonics: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    pin: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    passphrase_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    skip_checksum: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    u2f_counter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    needs_backup: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    no_backup: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type ResetDevice = Static<typeof ResetDevice>;
export declare const ResetDevice: import("@trezor/schema-utils").TObject<{
    strength: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    passphrase_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    pin_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    u2f_counter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    skip_backup: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    no_backup: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    backup_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof Enum_BackupType>>;
    entropy_check: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type Slip39Group = Static<typeof Slip39Group>;
export declare const Slip39Group: import("@trezor/schema-utils").TObject<{
    member_threshold: import("@trezor/schema-utils").TNumber;
    member_count: import("@trezor/schema-utils").TNumber;
}>;
export type BackupDevice = Static<typeof BackupDevice>;
export declare const BackupDevice: import("@trezor/schema-utils").TObject<{
    group_threshold: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    groups: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        member_threshold: import("@trezor/schema-utils").TNumber;
        member_count: import("@trezor/schema-utils").TNumber;
    }>>>;
}>;
export type EntropyRequest = Static<typeof EntropyRequest>;
export declare const EntropyRequest: import("@trezor/schema-utils").TObject<{
    entropy_commitment: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    prev_entropy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type EntropyAck = Static<typeof EntropyAck>;
export declare const EntropyAck: import("@trezor/schema-utils").TObject<{
    entropy: import("@trezor/schema-utils").TString;
}>;
export type EntropyCheckReady = Static<typeof EntropyCheckReady>;
export declare const EntropyCheckReady: import("@trezor/schema-utils").TObject<{}>;
export type EntropyCheckContinue = Static<typeof EntropyCheckContinue>;
export declare const EntropyCheckContinue: import("@trezor/schema-utils").TObject<{
    finish: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export declare enum Enum_WordRequestType {
    WordRequestType_Plain = 0,
    WordRequestType_Matrix9 = 1,
    WordRequestType_Matrix6 = 2
}
export type EnumEnum_WordRequestType = Static<typeof EnumEnum_WordRequestType>;
export declare const EnumEnum_WordRequestType: import("@trezor/schema-utils").TEnum<typeof Enum_WordRequestType>;
export type WordRequestType = Static<typeof WordRequestType>;
export declare const WordRequestType: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_WordRequestType>;
export type WordRequest = Static<typeof WordRequest>;
export declare const WordRequest: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_WordRequestType>;
}>;
export type WordAck = Static<typeof WordAck>;
export declare const WordAck: import("@trezor/schema-utils").TObject<{
    word: import("@trezor/schema-utils").TString;
}>;
export type SetU2FCounter = Static<typeof SetU2FCounter>;
export declare const SetU2FCounter: import("@trezor/schema-utils").TObject<{
    u2f_counter: import("@trezor/schema-utils").TNumber;
}>;
export type GetNextU2FCounter = Static<typeof GetNextU2FCounter>;
export declare const GetNextU2FCounter: import("@trezor/schema-utils").TObject<{}>;
export type NextU2FCounter = Static<typeof NextU2FCounter>;
export declare const NextU2FCounter: import("@trezor/schema-utils").TObject<{
    u2f_counter: import("@trezor/schema-utils").TNumber;
}>;
export type DoPreauthorized = Static<typeof DoPreauthorized>;
export declare const DoPreauthorized: import("@trezor/schema-utils").TObject<{}>;
export type PreauthorizedRequest = Static<typeof PreauthorizedRequest>;
export declare const PreauthorizedRequest: import("@trezor/schema-utils").TObject<{}>;
export type CancelAuthorization = Static<typeof CancelAuthorization>;
export declare const CancelAuthorization: import("@trezor/schema-utils").TObject<{}>;
export declare enum BootCommand {
    STOP_AND_WAIT = 0,
    INSTALL_UPGRADE = 1
}
export type EnumBootCommand = Static<typeof EnumBootCommand>;
export declare const EnumBootCommand: import("@trezor/schema-utils").TEnum<typeof BootCommand>;
export type RebootToBootloader = Static<typeof RebootToBootloader>;
export declare const RebootToBootloader: import("@trezor/schema-utils").TObject<{
    boot_command: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof BootCommand>>;
    firmware_header: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    language_data_length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type GetNonce = Static<typeof GetNonce>;
export declare const GetNonce: import("@trezor/schema-utils").TObject<{}>;
export type Nonce = Static<typeof Nonce>;
export declare const Nonce: import("@trezor/schema-utils").TObject<{
    nonce: import("@trezor/schema-utils").TString;
}>;
export type UnlockPath = Static<typeof UnlockPath>;
export declare const UnlockPath: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type UnlockedPathRequest = Static<typeof UnlockedPathRequest>;
export declare const UnlockedPathRequest: import("@trezor/schema-utils").TObject<{
    mac: import("@trezor/schema-utils").TString;
}>;
export type ShowDeviceTutorial = Static<typeof ShowDeviceTutorial>;
export declare const ShowDeviceTutorial: import("@trezor/schema-utils").TObject<{}>;
export type UnlockBootloader = Static<typeof UnlockBootloader>;
export declare const UnlockBootloader: import("@trezor/schema-utils").TObject<{}>;
export type SetBrightness = Static<typeof SetBrightness>;
export declare const SetBrightness: import("@trezor/schema-utils").TObject<{
    value: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type NEMGetAddress = Static<typeof NEMGetAddress>;
export declare const NEMGetAddress: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type NEMAddress = Static<typeof NEMAddress>;
export declare const NEMAddress: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
}>;
export type NEMTransactionCommon = Static<typeof NEMTransactionCommon>;
export declare const NEMTransactionCommon: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    timestamp: import("@trezor/schema-utils").TNumber;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    deadline: import("@trezor/schema-utils").TNumber;
    signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type NEMMosaic = Static<typeof NEMMosaic>;
export declare const NEMMosaic: import("@trezor/schema-utils").TObject<{
    namespace: import("@trezor/schema-utils").TString;
    mosaic: import("@trezor/schema-utils").TString;
    quantity: import("@trezor/schema-utils").TNumber;
}>;
export type NEMTransfer = Static<typeof NEMTransfer>;
export declare const NEMTransfer: import("@trezor/schema-utils").TObject<{
    recipient: import("@trezor/schema-utils").TString;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        namespace: import("@trezor/schema-utils").TString;
        mosaic: import("@trezor/schema-utils").TString;
        quantity: import("@trezor/schema-utils").TNumber;
    }>>>;
}>;
export type NEMProvisionNamespace = Static<typeof NEMProvisionNamespace>;
export declare const NEMProvisionNamespace: import("@trezor/schema-utils").TObject<{
    namespace: import("@trezor/schema-utils").TString;
    parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    sink: import("@trezor/schema-utils").TString;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export declare enum NEMMosaicLevy {
    MosaicLevy_Absolute = 1,
    MosaicLevy_Percentile = 2
}
export type EnumNEMMosaicLevy = Static<typeof EnumNEMMosaicLevy>;
export declare const EnumNEMMosaicLevy: import("@trezor/schema-utils").TEnum<typeof NEMMosaicLevy>;
export type NEMMosaicDefinition = Static<typeof NEMMosaicDefinition>;
export declare const NEMMosaicDefinition: import("@trezor/schema-utils").TObject<{
    name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    ticker: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    namespace: import("@trezor/schema-utils").TString;
    mosaic: import("@trezor/schema-utils").TString;
    divisibility: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof NEMMosaicLevy>>;
    fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    levy_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    levy_namespace: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    levy_mosaic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    mutable_supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    transferable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    description: import("@trezor/schema-utils").TString;
    networks: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
}>;
export type NEMMosaicCreation = Static<typeof NEMMosaicCreation>;
export declare const NEMMosaicCreation: import("@trezor/schema-utils").TObject<{
    definition: import("@trezor/schema-utils").TObject<{
        name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ticker: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        namespace: import("@trezor/schema-utils").TString;
        mosaic: import("@trezor/schema-utils").TString;
        divisibility: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof NEMMosaicLevy>>;
        fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        levy_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        levy_namespace: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        levy_mosaic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        mutable_supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        transferable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        description: import("@trezor/schema-utils").TString;
        networks: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    }>;
    sink: import("@trezor/schema-utils").TString;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export declare enum NEMSupplyChangeType {
    SupplyChange_Increase = 1,
    SupplyChange_Decrease = 2
}
export type EnumNEMSupplyChangeType = Static<typeof EnumNEMSupplyChangeType>;
export declare const EnumNEMSupplyChangeType: import("@trezor/schema-utils").TEnum<typeof NEMSupplyChangeType>;
export type NEMMosaicSupplyChange = Static<typeof NEMMosaicSupplyChange>;
export declare const NEMMosaicSupplyChange: import("@trezor/schema-utils").TObject<{
    namespace: import("@trezor/schema-utils").TString;
    mosaic: import("@trezor/schema-utils").TString;
    type: import("@trezor/schema-utils").TEnum<typeof NEMSupplyChangeType>;
    delta: import("@trezor/schema-utils").TNumber;
}>;
export declare enum NEMModificationType {
    CosignatoryModification_Add = 1,
    CosignatoryModification_Delete = 2
}
export type EnumNEMModificationType = Static<typeof EnumNEMModificationType>;
export declare const EnumNEMModificationType: import("@trezor/schema-utils").TEnum<typeof NEMModificationType>;
export type NEMCosignatoryModification = Static<typeof NEMCosignatoryModification>;
export declare const NEMCosignatoryModification: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TEnum<typeof NEMModificationType>;
    public_key: import("@trezor/schema-utils").TString;
}>;
export type NEMAggregateModification = Static<typeof NEMAggregateModification>;
export declare const NEMAggregateModification: import("@trezor/schema-utils").TObject<{
    modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof NEMModificationType>;
        public_key: import("@trezor/schema-utils").TString;
    }>>>;
    relative_change: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export declare enum NEMImportanceTransferMode {
    ImportanceTransfer_Activate = 1,
    ImportanceTransfer_Deactivate = 2
}
export type EnumNEMImportanceTransferMode = Static<typeof EnumNEMImportanceTransferMode>;
export declare const EnumNEMImportanceTransferMode: import("@trezor/schema-utils").TEnum<typeof NEMImportanceTransferMode>;
export type NEMImportanceTransfer = Static<typeof NEMImportanceTransfer>;
export declare const NEMImportanceTransfer: import("@trezor/schema-utils").TObject<{
    mode: import("@trezor/schema-utils").TEnum<typeof NEMImportanceTransferMode>;
    public_key: import("@trezor/schema-utils").TString;
}>;
export type NEMSignTx = Static<typeof NEMSignTx>;
export declare const NEMSignTx: import("@trezor/schema-utils").TObject<{
    transaction: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        timestamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        timestamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
    transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        recipient: import("@trezor/schema-utils").TString;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            namespace: import("@trezor/schema-utils").TString;
            mosaic: import("@trezor/schema-utils").TString;
            quantity: import("@trezor/schema-utils").TNumber;
        }>>>;
    }>>;
    cosigning: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    provision_namespace: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        namespace: import("@trezor/schema-utils").TString;
        parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        sink: import("@trezor/schema-utils").TString;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>>;
    mosaic_creation: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        definition: import("@trezor/schema-utils").TObject<{
            name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            ticker: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            namespace: import("@trezor/schema-utils").TString;
            mosaic: import("@trezor/schema-utils").TString;
            divisibility: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof NEMMosaicLevy>>;
            fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            levy_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            levy_namespace: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            levy_mosaic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            mutable_supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
            transferable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
            description: import("@trezor/schema-utils").TString;
            networks: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        }>;
        sink: import("@trezor/schema-utils").TString;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>>;
    supply_change: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        namespace: import("@trezor/schema-utils").TString;
        mosaic: import("@trezor/schema-utils").TString;
        type: import("@trezor/schema-utils").TEnum<typeof NEMSupplyChangeType>;
        delta: import("@trezor/schema-utils").TNumber;
    }>>;
    aggregate_modification: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TEnum<typeof NEMModificationType>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        relative_change: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>>;
    importance_transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        mode: import("@trezor/schema-utils").TEnum<typeof NEMImportanceTransferMode>;
        public_key: import("@trezor/schema-utils").TString;
    }>>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type NEMSignedTx = Static<typeof NEMSignedTx>;
export declare const NEMSignedTx: import("@trezor/schema-utils").TObject<{
    data: import("@trezor/schema-utils").TString;
    signature: import("@trezor/schema-utils").TString;
}>;
export type NEMDecryptMessage = Static<typeof NEMDecryptMessage>;
export declare const NEMDecryptMessage: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type NEMDecryptedMessage = Static<typeof NEMDecryptedMessage>;
export declare const NEMDecryptedMessage: import("@trezor/schema-utils").TObject<{
    payload: import("@trezor/schema-utils").TString;
}>;
export type RippleGetAddress = Static<typeof RippleGetAddress>;
export declare const RippleGetAddress: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type RippleAddress = Static<typeof RippleAddress>;
export declare const RippleAddress: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type RipplePayment = Static<typeof RipplePayment>;
export declare const RipplePayment: import("@trezor/schema-utils").TObject<{
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    destination: import("@trezor/schema-utils").TString;
    destination_tag: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type RippleSignTx = Static<typeof RippleSignTx>;
export declare const RippleSignTx: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    sequence: import("@trezor/schema-utils").TNumber;
    last_ledger_sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    payment: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        destination: import("@trezor/schema-utils").TString;
        destination_tag: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        recipient_name: import("@trezor/schema-utils").TString;
        memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                text: import("@trezor/schema-utils").TString;
            }>>;
            refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                coin_type: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils").TString;
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
        }>>>;
        amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        signature: import("@trezor/schema-utils").TString;
    }>>;
}>;
export type RippleSignedTx = Static<typeof RippleSignedTx>;
export declare const RippleSignedTx: import("@trezor/schema-utils").TObject<{
    signature: import("@trezor/schema-utils").TString;
    serialized_tx: import("@trezor/schema-utils").TString;
}>;
export type SolanaGetPublicKey = Static<typeof SolanaGetPublicKey>;
export declare const SolanaGetPublicKey: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type SolanaPublicKey = Static<typeof SolanaPublicKey>;
export declare const SolanaPublicKey: import("@trezor/schema-utils").TObject<{
    public_key: import("@trezor/schema-utils").TString;
}>;
export type SolanaGetAddress = Static<typeof SolanaGetAddress>;
export declare const SolanaGetAddress: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type SolanaAddress = Static<typeof SolanaAddress>;
export declare const SolanaAddress: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type SolanaTxTokenAccountInfo = Static<typeof SolanaTxTokenAccountInfo>;
export declare const SolanaTxTokenAccountInfo: import("@trezor/schema-utils").TObject<{
    base_address: import("@trezor/schema-utils").TString;
    token_program: import("@trezor/schema-utils").TString;
    token_mint: import("@trezor/schema-utils").TString;
    token_account: import("@trezor/schema-utils").TString;
}>;
export type SolanaTxAdditionalInfo = Static<typeof SolanaTxAdditionalInfo>;
export declare const SolanaTxAdditionalInfo: import("@trezor/schema-utils").TObject<{
    token_accounts_infos: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        base_address: import("@trezor/schema-utils").TString;
        token_program: import("@trezor/schema-utils").TString;
        token_mint: import("@trezor/schema-utils").TString;
        token_account: import("@trezor/schema-utils").TString;
    }>>;
    encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
}>;
export type SolanaSignTx = Static<typeof SolanaSignTx>;
export declare const SolanaSignTx: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    serialized_tx: import("@trezor/schema-utils").TString;
    additional_info: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        token_accounts_infos: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            base_address: import("@trezor/schema-utils").TString;
            token_program: import("@trezor/schema-utils").TString;
            token_mint: import("@trezor/schema-utils").TString;
            token_account: import("@trezor/schema-utils").TString;
        }>>;
        encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    }>>;
    payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        recipient_name: import("@trezor/schema-utils").TString;
        memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                text: import("@trezor/schema-utils").TString;
            }>>;
            refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                coin_type: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils").TString;
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
        }>>>;
        amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        signature: import("@trezor/schema-utils").TString;
    }>>;
}>;
export type SolanaTxSignature = Static<typeof SolanaTxSignature>;
export declare const SolanaTxSignature: import("@trezor/schema-utils").TObject<{
    signature: import("@trezor/schema-utils").TString;
}>;
export declare enum StellarAssetType {
    NATIVE = 0,
    ALPHANUM4 = 1,
    ALPHANUM12 = 2
}
export type EnumStellarAssetType = Static<typeof EnumStellarAssetType>;
export declare const EnumStellarAssetType: import("@trezor/schema-utils").TEnum<typeof StellarAssetType>;
export type StellarAsset = Static<typeof StellarAsset>;
export declare const StellarAsset: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
    code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type StellarGetAddress = Static<typeof StellarGetAddress>;
export declare const StellarGetAddress: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type StellarAddress = Static<typeof StellarAddress>;
export declare const StellarAddress: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export declare enum StellarMemoType {
    NONE = 0,
    TEXT = 1,
    ID = 2,
    HASH = 3,
    RETURN = 4
}
export type EnumStellarMemoType = Static<typeof EnumStellarMemoType>;
export declare const EnumStellarMemoType: import("@trezor/schema-utils").TEnum<typeof StellarMemoType>;
export type StellarSignTx = Static<typeof StellarSignTx>;
export declare const StellarSignTx: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    network_passphrase: import("@trezor/schema-utils").TString;
    source_account: import("@trezor/schema-utils").TString;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    sequence_number: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    timebounds_start: import("@trezor/schema-utils").TNumber;
    timebounds_end: import("@trezor/schema-utils").TNumber;
    memo_type: import("@trezor/schema-utils").TEnum<typeof StellarMemoType>;
    memo_text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    memo_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    memo_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/buffer").TBuffer, import("@trezor/schema-utils").TString]>>;
    num_operations: import("@trezor/schema-utils").TNumber;
}>;
export type StellarTxOpRequest = Static<typeof StellarTxOpRequest>;
export declare const StellarTxOpRequest: import("@trezor/schema-utils").TObject<{}>;
export type StellarPaymentOp = Static<typeof StellarPaymentOp>;
export declare const StellarPaymentOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    destination_account: import("@trezor/schema-utils").TString;
    asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export type StellarCreateAccountOp = Static<typeof StellarCreateAccountOp>;
export declare const StellarCreateAccountOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    new_account: import("@trezor/schema-utils").TString;
    starting_balance: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export type StellarPathPaymentStrictReceiveOp = Static<typeof StellarPathPaymentStrictReceiveOp>;
export declare const StellarPathPaymentStrictReceiveOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    send_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    send_max: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    destination_account: import("@trezor/schema-utils").TString;
    destination_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    destination_amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    paths: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>>;
}>;
export type StellarPathPaymentStrictSendOp = Static<typeof StellarPathPaymentStrictSendOp>;
export declare const StellarPathPaymentStrictSendOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    send_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    send_amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    destination_account: import("@trezor/schema-utils").TString;
    destination_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    destination_min: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    paths: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>>;
}>;
export type StellarManageSellOfferOp = Static<typeof StellarManageSellOfferOp>;
export declare const StellarManageSellOfferOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    selling_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    buying_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    price_n: import("@trezor/schema-utils").TNumber;
    price_d: import("@trezor/schema-utils").TNumber;
    offer_id: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export type StellarManageBuyOfferOp = Static<typeof StellarManageBuyOfferOp>;
export declare const StellarManageBuyOfferOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    selling_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    buying_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    price_n: import("@trezor/schema-utils").TNumber;
    price_d: import("@trezor/schema-utils").TNumber;
    offer_id: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export type StellarCreatePassiveSellOfferOp = Static<typeof StellarCreatePassiveSellOfferOp>;
export declare const StellarCreatePassiveSellOfferOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    selling_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    buying_asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    price_n: import("@trezor/schema-utils").TNumber;
    price_d: import("@trezor/schema-utils").TNumber;
}>;
export declare enum StellarSignerType {
    ACCOUNT = 0,
    PRE_AUTH = 1,
    HASH = 2
}
export type EnumStellarSignerType = Static<typeof EnumStellarSignerType>;
export declare const EnumStellarSignerType: import("@trezor/schema-utils").TEnum<typeof StellarSignerType>;
export type StellarSetOptionsOp = Static<typeof StellarSetOptionsOp>;
export declare const StellarSetOptionsOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    inflation_destination_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    clear_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    set_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    master_weight: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    low_threshold: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    medium_threshold: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    high_threshold: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    home_domain: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    signer_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof StellarSignerType>>;
    signer_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/buffer").TBuffer, import("@trezor/schema-utils").TString]>>;
    signer_weight: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type StellarChangeTrustOp = Static<typeof StellarChangeTrustOp>;
export declare const StellarChangeTrustOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    asset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    limit: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export type StellarAllowTrustOp = Static<typeof StellarAllowTrustOp>;
export declare const StellarAllowTrustOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    trusted_account: import("@trezor/schema-utils").TString;
    asset_type: import("@trezor/schema-utils").TEnum<typeof StellarAssetType>;
    asset_code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    is_authorized: import("@trezor/schema-utils").TBoolean;
}>;
export type StellarAccountMergeOp = Static<typeof StellarAccountMergeOp>;
export declare const StellarAccountMergeOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    destination_account: import("@trezor/schema-utils").TString;
}>;
export type StellarManageDataOp = Static<typeof StellarManageDataOp>;
export declare const StellarManageDataOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    key: import("@trezor/schema-utils").TString;
    value: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/buffer").TBuffer, import("@trezor/schema-utils").TString]>>;
}>;
export type StellarBumpSequenceOp = Static<typeof StellarBumpSequenceOp>;
export declare const StellarBumpSequenceOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    bump_to: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export type StellarClaimClaimableBalanceOp = Static<typeof StellarClaimClaimableBalanceOp>;
export declare const StellarClaimClaimableBalanceOp: import("@trezor/schema-utils").TObject<{
    source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    balance_id: import("@trezor/schema-utils").TString;
}>;
export type StellarSignedTx = Static<typeof StellarSignedTx>;
export declare const StellarSignedTx: import("@trezor/schema-utils").TObject<{
    public_key: import("@trezor/schema-utils").TString;
    signature: import("@trezor/schema-utils").TString;
}>;
export type TezosGetAddress = Static<typeof TezosGetAddress>;
export declare const TezosGetAddress: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type TezosAddress = Static<typeof TezosAddress>;
export declare const TezosAddress: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type TezosGetPublicKey = Static<typeof TezosGetPublicKey>;
export declare const TezosGetPublicKey: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type TezosPublicKey = Static<typeof TezosPublicKey>;
export declare const TezosPublicKey: import("@trezor/schema-utils").TObject<{
    public_key: import("@trezor/schema-utils").TString;
}>;
export declare enum TezosContractType {
    Implicit = 0,
    Originated = 1
}
export type EnumTezosContractType = Static<typeof EnumTezosContractType>;
export declare const EnumTezosContractType: import("@trezor/schema-utils").TEnum<typeof TezosContractType>;
export type TezosContractID = Static<typeof TezosContractID>;
export declare const TezosContractID: import("@trezor/schema-utils").TObject<{
    tag: import("@trezor/schema-utils").TNumber;
    hash: import("@trezor/schema-utils").TUint8Array;
}>;
export type TezosRevealOp = Static<typeof TezosRevealOp>;
export declare const TezosRevealOp: import("@trezor/schema-utils").TObject<{
    source: import("@trezor/schema-utils").TUint8Array;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    counter: import("@trezor/schema-utils").TNumber;
    gas_limit: import("@trezor/schema-utils").TNumber;
    storage_limit: import("@trezor/schema-utils").TNumber;
    public_key: import("@trezor/schema-utils").TUint8Array;
}>;
export type TezosManagerTransfer = Static<typeof TezosManagerTransfer>;
export declare const TezosManagerTransfer: import("@trezor/schema-utils").TObject<{
    destination: import("@trezor/schema-utils").TObject<{
        tag: import("@trezor/schema-utils").TNumber;
        hash: import("@trezor/schema-utils").TUint8Array;
    }>;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
}>;
export type TezosParametersManager = Static<typeof TezosParametersManager>;
export declare const TezosParametersManager: import("@trezor/schema-utils").TObject<{
    set_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
    cancel_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        destination: import("@trezor/schema-utils").TObject<{
            tag: import("@trezor/schema-utils").TNumber;
            hash: import("@trezor/schema-utils").TUint8Array;
        }>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>>;
}>;
export type TezosTransactionOp = Static<typeof TezosTransactionOp>;
export declare const TezosTransactionOp: import("@trezor/schema-utils").TObject<{
    source: import("@trezor/schema-utils").TUint8Array;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    counter: import("@trezor/schema-utils").TNumber;
    gas_limit: import("@trezor/schema-utils").TNumber;
    storage_limit: import("@trezor/schema-utils").TNumber;
    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    destination: import("@trezor/schema-utils").TObject<{
        tag: import("@trezor/schema-utils").TNumber;
        hash: import("@trezor/schema-utils").TUint8Array;
    }>;
    parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    parameters_manager: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        set_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
        cancel_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            destination: import("@trezor/schema-utils").TObject<{
                tag: import("@trezor/schema-utils").TNumber;
                hash: import("@trezor/schema-utils").TUint8Array;
            }>;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        }>>;
    }>>;
}>;
export type TezosOriginationOp = Static<typeof TezosOriginationOp>;
export declare const TezosOriginationOp: import("@trezor/schema-utils").TObject<{
    source: import("@trezor/schema-utils").TUint8Array;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    counter: import("@trezor/schema-utils").TNumber;
    gas_limit: import("@trezor/schema-utils").TNumber;
    storage_limit: import("@trezor/schema-utils").TNumber;
    manager_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    balance: import("@trezor/schema-utils").TNumber;
    spendable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    delegatable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
    script: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
}>;
export type TezosDelegationOp = Static<typeof TezosDelegationOp>;
export declare const TezosDelegationOp: import("@trezor/schema-utils").TObject<{
    source: import("@trezor/schema-utils").TUint8Array;
    fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    counter: import("@trezor/schema-utils").TNumber;
    gas_limit: import("@trezor/schema-utils").TNumber;
    storage_limit: import("@trezor/schema-utils").TNumber;
    delegate: import("@trezor/schema-utils").TUint8Array;
}>;
export type TezosProposalOp = Static<typeof TezosProposalOp>;
export declare const TezosProposalOp: import("@trezor/schema-utils").TObject<{
    source: import("@trezor/schema-utils").TString;
    period: import("@trezor/schema-utils").TNumber;
    proposals: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
}>;
export declare enum TezosBallotType {
    Yay = 0,
    Nay = 1,
    Pass = 2
}
export type EnumTezosBallotType = Static<typeof EnumTezosBallotType>;
export declare const EnumTezosBallotType: import("@trezor/schema-utils").TEnum<typeof TezosBallotType>;
export type TezosBallotOp = Static<typeof TezosBallotOp>;
export declare const TezosBallotOp: import("@trezor/schema-utils").TObject<{
    source: import("@trezor/schema-utils").TString;
    period: import("@trezor/schema-utils").TNumber;
    proposal: import("@trezor/schema-utils").TString;
    ballot: import("@trezor/schema-utils").TEnum<typeof TezosBallotType>;
}>;
export type TezosSignTx = Static<typeof TezosSignTx>;
export declare const TezosSignTx: import("@trezor/schema-utils").TObject<{
    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    branch: import("@trezor/schema-utils").TUint8Array;
    reveal: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TUint8Array;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        counter: import("@trezor/schema-utils").TNumber;
        gas_limit: import("@trezor/schema-utils").TNumber;
        storage_limit: import("@trezor/schema-utils").TNumber;
        public_key: import("@trezor/schema-utils").TUint8Array;
    }>>;
    transaction: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TUint8Array;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        counter: import("@trezor/schema-utils").TNumber;
        gas_limit: import("@trezor/schema-utils").TNumber;
        storage_limit: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        destination: import("@trezor/schema-utils").TObject<{
            tag: import("@trezor/schema-utils").TNumber;
            hash: import("@trezor/schema-utils").TUint8Array;
        }>;
        parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        parameters_manager: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            set_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
            cancel_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
            transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                destination: import("@trezor/schema-utils").TObject<{
                    tag: import("@trezor/schema-utils").TNumber;
                    hash: import("@trezor/schema-utils").TUint8Array;
                }>;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            }>>;
        }>>;
    }>>;
    origination: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TUint8Array;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        counter: import("@trezor/schema-utils").TNumber;
        gas_limit: import("@trezor/schema-utils").TNumber;
        storage_limit: import("@trezor/schema-utils").TNumber;
        manager_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        balance: import("@trezor/schema-utils").TNumber;
        spendable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        delegatable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
        script: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
    }>>;
    delegation: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TUint8Array;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        counter: import("@trezor/schema-utils").TNumber;
        gas_limit: import("@trezor/schema-utils").TNumber;
        storage_limit: import("@trezor/schema-utils").TNumber;
        delegate: import("@trezor/schema-utils").TUint8Array;
    }>>;
    proposal: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TString;
        period: import("@trezor/schema-utils").TNumber;
        proposals: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
    ballot: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TString;
        period: import("@trezor/schema-utils").TNumber;
        proposal: import("@trezor/schema-utils").TString;
        ballot: import("@trezor/schema-utils").TEnum<typeof TezosBallotType>;
    }>>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type TezosSignedTx = Static<typeof TezosSignedTx>;
export declare const TezosSignedTx: import("@trezor/schema-utils").TObject<{
    signature: import("@trezor/schema-utils").TString;
    sig_op_contents: import("@trezor/schema-utils").TString;
    operation_hash: import("@trezor/schema-utils").TString;
}>;
export type MessageType = Static<typeof MessageType>;
export declare const MessageType: import("@trezor/schema-utils").TObject<{
    TextMemo: import("@trezor/schema-utils").TObject<{
        text: import("@trezor/schema-utils").TString;
    }>;
    RefundMemo: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        mac: import("@trezor/schema-utils").TString;
    }>;
    CoinPurchaseMemo: import("@trezor/schema-utils").TObject<{
        coin_type: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils").TString;
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        mac: import("@trezor/schema-utils").TString;
    }>;
    TextDetailsMemo: import("@trezor/schema-utils").TObject<{
        title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    PaymentRequestMemo: import("@trezor/schema-utils").TObject<{
        text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            text: import("@trezor/schema-utils").TString;
        }>>;
        refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            mac: import("@trezor/schema-utils").TString;
        }>>;
        coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            coin_type: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils").TString;
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            mac: import("@trezor/schema-utils").TString;
        }>>;
        text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>;
    PaymentRequest: import("@trezor/schema-utils").TObject<{
        nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        recipient_name: import("@trezor/schema-utils").TString;
        memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                text: import("@trezor/schema-utils").TString;
            }>>;
            refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                coin_type: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils").TString;
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                mac: import("@trezor/schema-utils").TString;
            }>>;
            text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
        }>>>;
        amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        signature: import("@trezor/schema-utils").TString;
    }>;
    HDNodeType: import("@trezor/schema-utils").TObject<{
        depth: import("@trezor/schema-utils").TNumber;
        fingerprint: import("@trezor/schema-utils").TNumber;
        child_num: import("@trezor/schema-utils").TNumber;
        chain_code: import("@trezor/schema-utils").TString;
        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        public_key: import("@trezor/schema-utils").TString;
    }>;
    HDNodePathType: import("@trezor/schema-utils").TObject<{
        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>, import("@trezor/schema-utils").TString]>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    }>;
    MultisigRedeemScriptType: import("@trezor/schema-utils").TObject<{
        pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>, import("@trezor/schema-utils").TString]>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        }>>;
        signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        m: import("@trezor/schema-utils").TNumber;
        nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
    }>;
    GetPublicKey: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        ecdsa_curve_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
        ignore_xpub_magic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    PublicKey: import("@trezor/schema-utils").TObject<{
        node: import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>;
        xpub: import("@trezor/schema-utils").TString;
        root_fingerprint: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        descriptor: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    GetAddress: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
        ignore_xpub_magic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    Address: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    GetOwnershipId: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
    }>;
    OwnershipId: import("@trezor/schema-utils").TObject<{
        ownership_id: import("@trezor/schema-utils").TString;
    }>;
    SignMessage: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        message: import("@trezor/schema-utils").TString;
        coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
        no_script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    MessageSignature: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        signature: import("@trezor/schema-utils").TString;
    }>;
    VerifyMessage: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        signature: import("@trezor/schema-utils").TString;
        message: import("@trezor/schema-utils").TString;
        coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    CoinJoinRequest: import("@trezor/schema-utils").TObject<{
        fee_rate: import("@trezor/schema-utils").TNumber;
        no_fee_threshold: import("@trezor/schema-utils").TNumber;
        min_registrable_amount: import("@trezor/schema-utils").TNumber;
        mask_public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    SignTx: import("@trezor/schema-utils").TObject<{
        outputs_count: import("@trezor/schema-utils").TNumber;
        inputs_count: import("@trezor/schema-utils").TNumber;
        coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        lock_time: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        expiry: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        overwintered: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        version_group_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        timestamp: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        branch_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        amount_unit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof AmountUnit>>;
        decred_staking_ticket: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        serialize: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        coinjoin_request: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            fee_rate: import("@trezor/schema-utils").TNumber;
            no_fee_threshold: import("@trezor/schema-utils").TNumber;
            min_registrable_amount: import("@trezor/schema-utils").TNumber;
            mask_public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    TxRequestDetailsType: import("@trezor/schema-utils").TObject<{
        request_index: import("@trezor/schema-utils").TNumber;
        tx_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        extra_data_offset: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    TxRequestSerializedType: import("@trezor/schema-utils").TObject<{
        signature_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        serialized_tx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    TxRequest: import("@trezor/schema-utils").TObject<{
        request_type: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RequestType>;
        details: import("@trezor/schema-utils").TObject<{
            request_index: import("@trezor/schema-utils").TNumber;
            tx_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            extra_data_offset: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>;
        serialized: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            signature_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            serialized_tx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>;
    TxInputType: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
        script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
    }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
        script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>, import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
        script_pubkey: import("@trezor/schema-utils").TString;
    }>]>]>;
    TxOutputBinType: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        script_pubkey: import("@trezor/schema-utils").TString;
        decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    TxOutputType: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
        op_return_data: import("@trezor/schema-utils").TString;
        script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
        orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>]>;
    PrevTx: import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TNumber;
        lock_time: import("@trezor/schema-utils").TNumber;
        inputs_count: import("@trezor/schema-utils").TNumber;
        outputs_count: import("@trezor/schema-utils").TNumber;
        extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        expiry: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        version_group_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        timestamp: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        branch_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    PrevInput: import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
        script_sig: import("@trezor/schema-utils").TString;
        sequence: import("@trezor/schema-utils").TNumber;
        decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    PrevOutput: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        script_pubkey: import("@trezor/schema-utils").TString;
        decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    TxAck: import("@trezor/schema-utils").TObject<{
        tx: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
            inputs: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
                prev_hash: import("@trezor/schema-utils").TString;
                prev_index: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
                script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>, import("@trezor/schema-utils").TObject<{
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
            }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
                prev_hash: import("@trezor/schema-utils").TString;
                prev_index: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
                script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>, import("@trezor/schema-utils").TObject<{
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
                script_pubkey: import("@trezor/schema-utils").TString;
            }>]>]>, import("@trezor/schema-utils").TObject<{
                prev_hash: import("@trezor/schema-utils").TString;
                prev_index: import("@trezor/schema-utils").TNumber;
                script_sig: import("@trezor/schema-utils").TString;
                sequence: import("@trezor/schema-utils").TNumber;
                decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>]>>;
        }>, import("@trezor/schema-utils").TObject<{
            bin_outputs: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                script_pubkey: import("@trezor/schema-utils").TString;
                decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>>;
        }>, import("@trezor/schema-utils").TObject<{
            outputs: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>, import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>, import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>, import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
                op_return_data: import("@trezor/schema-utils").TString;
                script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>]>>;
        }>, import("@trezor/schema-utils").TObject<{
            extra_data: import("@trezor/schema-utils").TString;
        }>, import("@trezor/schema-utils").TObject<{
            version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            lock_time: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            inputs_cnt: import("@trezor/schema-utils").TNumber;
            outputs_cnt: import("@trezor/schema-utils").TNumber;
            extra_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            timestamp: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            version_group_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            expiry: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            branch_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>]>;
    }>;
    TxAckInputWrapper: import("@trezor/schema-utils").TObject<{
        input: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            prev_hash: import("@trezor/schema-utils").TString;
            prev_index: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
            script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
        }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            prev_hash: import("@trezor/schema-utils").TString;
            prev_index: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
            script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
            script_pubkey: import("@trezor/schema-utils").TString;
        }>]>]>;
    }>;
    TxAckInput: import("@trezor/schema-utils").TObject<{
        tx: import("@trezor/schema-utils").TObject<{
            input: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
                prev_hash: import("@trezor/schema-utils").TString;
                prev_index: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
                script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>, import("@trezor/schema-utils").TObject<{
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"SPENDADDRESS">, import("@trezor/schema-utils").TLiteral<"SPENDMULTISIG">, import("@trezor/schema-utils").TLiteral<"SPENDWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"SPENDTAPROOT">]>>;
            }>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
                prev_hash: import("@trezor/schema-utils").TString;
                prev_index: import("@trezor/schema-utils").TNumber;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                decred_staking_spend: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof DecredStakingSpendType>>;
                script_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                coinjoin_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                script_sig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                witness: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                ownership_proof: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>, import("@trezor/schema-utils").TObject<{
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                script_type: import("@trezor/schema-utils").TLiteral<"EXTERNAL">;
                script_pubkey: import("@trezor/schema-utils").TString;
            }>]>]>;
        }>;
    }>;
    TxAckOutputWrapper: import("@trezor/schema-utils").TObject<{
        output: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>, import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>, import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>, import("@trezor/schema-utils").TString]>;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                }>>;
                signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                m: import("@trezor/schema-utils").TNumber;
                nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>>>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
            }>>;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>, import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
            amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
            op_return_data: import("@trezor/schema-utils").TString;
            script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
            orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>]>;
    }>;
    TxAckOutput: import("@trezor/schema-utils").TObject<{
        tx: import("@trezor/schema-utils").TObject<{
            output: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                script_type: import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>, import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>, import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"PAYTOADDRESS">, import("@trezor/schema-utils").TLiteral<"PAYTOSCRIPTHASH">, import("@trezor/schema-utils").TLiteral<"PAYTOMULTISIG">, import("@trezor/schema-utils").TLiteral<"PAYTOWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOP2SHWITNESS">, import("@trezor/schema-utils").TLiteral<"PAYTOTAPROOT">]>>;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                            depth: import("@trezor/schema-utils").TNumber;
                            fingerprint: import("@trezor/schema-utils").TNumber;
                            child_num: import("@trezor/schema-utils").TNumber;
                            chain_code: import("@trezor/schema-utils").TString;
                            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                            public_key: import("@trezor/schema-utils").TString;
                        }>, import("@trezor/schema-utils").TString]>;
                        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    }>>;
                    signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                    m: import("@trezor/schema-utils").TNumber;
                    nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                        depth: import("@trezor/schema-utils").TNumber;
                        fingerprint: import("@trezor/schema-utils").TNumber;
                        child_num: import("@trezor/schema-utils").TNumber;
                        chain_code: import("@trezor/schema-utils").TString;
                        private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                        public_key: import("@trezor/schema-utils").TString;
                    }>>>;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
                }>>;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>, import("@trezor/schema-utils").TObject<{
                address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
                amount: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"0">, import("@trezor/schema-utils").TLiteral<0>]>;
                op_return_data: import("@trezor/schema-utils").TString;
                script_type: import("@trezor/schema-utils").TLiteral<"PAYTOOPRETURN">;
                orig_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                orig_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                payment_req_index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>]>;
        }>;
    }>;
    TxAckPrevMeta: import("@trezor/schema-utils").TObject<{
        tx: import("@trezor/schema-utils").TObject<{
            version: import("@trezor/schema-utils").TNumber;
            lock_time: import("@trezor/schema-utils").TNumber;
            inputs_count: import("@trezor/schema-utils").TNumber;
            outputs_count: import("@trezor/schema-utils").TNumber;
            extra_data_len: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            expiry: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            version_group_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            timestamp: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            branch_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>;
    }>;
    TxAckPrevInputWrapper: import("@trezor/schema-utils").TObject<{
        input: import("@trezor/schema-utils").TObject<{
            prev_hash: import("@trezor/schema-utils").TString;
            prev_index: import("@trezor/schema-utils").TNumber;
            script_sig: import("@trezor/schema-utils").TString;
            sequence: import("@trezor/schema-utils").TNumber;
            decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>;
    }>;
    TxAckPrevInput: import("@trezor/schema-utils").TObject<{
        tx: import("@trezor/schema-utils").TObject<{
            input: import("@trezor/schema-utils").TObject<{
                prev_hash: import("@trezor/schema-utils").TString;
                prev_index: import("@trezor/schema-utils").TNumber;
                script_sig: import("@trezor/schema-utils").TString;
                sequence: import("@trezor/schema-utils").TNumber;
                decred_tree: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>;
        }>;
    }>;
    TxAckPrevOutputWrapper: import("@trezor/schema-utils").TObject<{
        output: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            script_pubkey: import("@trezor/schema-utils").TString;
            decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>;
    }>;
    TxAckPrevOutput: import("@trezor/schema-utils").TObject<{
        tx: import("@trezor/schema-utils").TObject<{
            output: import("@trezor/schema-utils").TObject<{
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                script_pubkey: import("@trezor/schema-utils").TString;
                decred_script_version: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            }>;
        }>;
    }>;
    TxAckPrevExtraDataWrapper: import("@trezor/schema-utils").TObject<{
        extra_data_chunk: import("@trezor/schema-utils").TString;
    }>;
    TxAckPrevExtraData: import("@trezor/schema-utils").TObject<{
        tx: import("@trezor/schema-utils").TObject<{
            extra_data_chunk: import("@trezor/schema-utils").TString;
        }>;
    }>;
    GetOwnershipProof: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pubkeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                node: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
                    depth: import("@trezor/schema-utils").TNumber;
                    fingerprint: import("@trezor/schema-utils").TNumber;
                    child_num: import("@trezor/schema-utils").TNumber;
                    chain_code: import("@trezor/schema-utils").TString;
                    private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    public_key: import("@trezor/schema-utils").TString;
                }>, import("@trezor/schema-utils").TString]>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            }>>;
            signatures: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            m: import("@trezor/schema-utils").TNumber;
            nodes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                depth: import("@trezor/schema-utils").TNumber;
                fingerprint: import("@trezor/schema-utils").TNumber;
                child_num: import("@trezor/schema-utils").TNumber;
                chain_code: import("@trezor/schema-utils").TString;
                private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            pubkeys_order: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof MultisigPubkeysOrder>>;
        }>>;
        user_confirmation: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        ownership_ids: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>>;
        commitment_data: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    OwnershipProof: import("@trezor/schema-utils").TObject<{
        ownership_proof: import("@trezor/schema-utils").TString;
        signature: import("@trezor/schema-utils").TString;
    }>;
    AuthorizeCoinJoin: import("@trezor/schema-utils").TObject<{
        coordinator: import("@trezor/schema-utils").TString;
        max_rounds: import("@trezor/schema-utils").TNumber;
        max_coordinator_fee_rate: import("@trezor/schema-utils").TNumber;
        max_fee_per_kvbyte: import("@trezor/schema-utils").TNumber;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        coin_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_InputScriptType>>;
        amount_unit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof AmountUnit>>;
    }>;
    BleUnpair: import("@trezor/schema-utils").TObject<{
        all: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        addr: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    FirmwareErase: import("@trezor/schema-utils").TObject<{
        length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    FirmwareRequest: import("@trezor/schema-utils").TObject<{
        offset: import("@trezor/schema-utils").TNumber;
        length: import("@trezor/schema-utils").TNumber;
    }>;
    FirmwareUpload: import("@trezor/schema-utils").TObject<{
        payload: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/buffer").TBuffer, import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer]>;
        hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    ProdTestT1: import("@trezor/schema-utils").TObject<{
        payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoBlockchainPointerType: import("@trezor/schema-utils").TObject<{
        block_index: import("@trezor/schema-utils").TNumber;
        tx_index: import("@trezor/schema-utils").TNumber;
        certificate_index: import("@trezor/schema-utils").TNumber;
    }>;
    CardanoNativeScript: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof CardanoNativeScriptType>;
        scripts: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TThis>>;
        key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        key_path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        required_signatures_count: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        invalid_before: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        invalid_hereafter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    }>>;
    CardanoGetNativeScriptHash: import("@trezor/schema-utils").TObject<{
        script: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TEnum<typeof CardanoNativeScriptType>;
            scripts: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TThis>>;
            key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            key_path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            required_signatures_count: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            invalid_before: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            invalid_hereafter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        }>>;
        display_format: import("@trezor/schema-utils").TEnum<typeof CardanoNativeScriptHashDisplayFormat>;
        derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
    }>;
    CardanoNativeScriptHash: import("@trezor/schema-utils").TObject<{
        script_hash: import("@trezor/schema-utils").TString;
    }>;
    CardanoAddressParametersType: import("@trezor/schema-utils").TObject<{
        address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            block_index: import("@trezor/schema-utils").TNumber;
            tx_index: import("@trezor/schema-utils").TNumber;
            certificate_index: import("@trezor/schema-utils").TNumber;
        }>>;
        script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoGetAddress: import("@trezor/schema-utils").TObject<{
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        protocol_magic: import("@trezor/schema-utils").TNumber;
        network_id: import("@trezor/schema-utils").TNumber;
        address_parameters: import("@trezor/schema-utils").TObject<{
            address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                block_index: import("@trezor/schema-utils").TNumber;
                tx_index: import("@trezor/schema-utils").TNumber;
                certificate_index: import("@trezor/schema-utils").TNumber;
            }>>;
            script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    CardanoAddress: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoGetPublicKey: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
    }>;
    CardanoPublicKey: import("@trezor/schema-utils").TObject<{
        xpub: import("@trezor/schema-utils").TString;
        node: import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>;
    }>;
    CardanoSignTxInit: import("@trezor/schema-utils").TObject<{
        signing_mode: import("@trezor/schema-utils").TEnum<typeof CardanoTxSigningMode>;
        protocol_magic: import("@trezor/schema-utils").TNumber;
        network_id: import("@trezor/schema-utils").TNumber;
        inputs_count: import("@trezor/schema-utils").TNumber;
        outputs_count: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        ttl: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        certificates_count: import("@trezor/schema-utils").TNumber;
        withdrawals_count: import("@trezor/schema-utils").TNumber;
        has_auxiliary_data: import("@trezor/schema-utils").TBoolean;
        validity_interval_start: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        witness_requests_count: import("@trezor/schema-utils").TNumber;
        minting_asset_groups_count: import("@trezor/schema-utils").TNumber;
        derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
        include_network_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        script_data_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        collateral_inputs_count: import("@trezor/schema-utils").TNumber;
        required_signers_count: import("@trezor/schema-utils").TNumber;
        has_collateral_return: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        total_collateral: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        reference_inputs_count: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        tag_cbor_sets: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            recipient_name: import("@trezor/schema-utils").TString;
            memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    text: import("@trezor/schema-utils").TString;
                }>>;
                refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    coin_type: import("@trezor/schema-utils").TNumber;
                    amount: import("@trezor/schema-utils").TString;
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                }>>;
            }>>>;
            amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            signature: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    CardanoTxInput: import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
    }>;
    CardanoTxOutput: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        address_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                block_index: import("@trezor/schema-utils").TNumber;
                tx_index: import("@trezor/schema-utils").TNumber;
                certificate_index: import("@trezor/schema-utils").TNumber;
            }>>;
            script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        asset_groups_count: import("@trezor/schema-utils").TNumber;
        datum_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        format: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof CardanoTxOutputSerializationFormat>>;
        inline_datum_size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        reference_script_size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    CardanoAssetGroup: import("@trezor/schema-utils").TObject<{
        policy_id: import("@trezor/schema-utils").TString;
        tokens_count: import("@trezor/schema-utils").TNumber;
    }>;
    CardanoToken: import("@trezor/schema-utils").TObject<{
        asset_name_bytes: import("@trezor/schema-utils").TString;
        amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        mint_amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
    }>;
    CardanoTxInlineDatumChunk: import("@trezor/schema-utils").TObject<{
        data: import("@trezor/schema-utils").TString;
    }>;
    CardanoTxReferenceScriptChunk: import("@trezor/schema-utils").TObject<{
        data: import("@trezor/schema-utils").TString;
    }>;
    CardanoPoolOwner: import("@trezor/schema-utils").TObject<{
        staking_key_path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoPoolRelayParameters: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof CardanoPoolRelayType>;
        ipv4_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ipv6_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        host_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        port: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    CardanoPoolMetadataType: import("@trezor/schema-utils").TObject<{
        url: import("@trezor/schema-utils").TString;
        hash: import("@trezor/schema-utils").TString;
    }>;
    CardanoPoolParametersType: import("@trezor/schema-utils").TObject<{
        pool_id: import("@trezor/schema-utils").TString;
        vrf_key_hash: import("@trezor/schema-utils").TString;
        pledge: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        cost: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        margin_numerator: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        margin_denominator: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        reward_account: import("@trezor/schema-utils").TString;
        metadata: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            url: import("@trezor/schema-utils").TString;
            hash: import("@trezor/schema-utils").TString;
        }>>;
        owners_count: import("@trezor/schema-utils").TNumber;
        relays_count: import("@trezor/schema-utils").TNumber;
    }>;
    CardanoDRep: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof CardanoDRepType>;
        key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        script_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoTxCertificate: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof CardanoCertificateType>;
        path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        pool: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        pool_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            pool_id: import("@trezor/schema-utils").TString;
            vrf_key_hash: import("@trezor/schema-utils").TString;
            pledge: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            cost: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            margin_numerator: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            margin_denominator: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            reward_account: import("@trezor/schema-utils").TString;
            metadata: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                url: import("@trezor/schema-utils").TString;
                hash: import("@trezor/schema-utils").TString;
            }>>;
            owners_count: import("@trezor/schema-utils").TNumber;
            relays_count: import("@trezor/schema-utils").TNumber;
        }>>;
        script_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        deposit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        drep: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TEnum<typeof CardanoDRepType>;
            key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            script_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>;
    CardanoTxWithdrawal: import("@trezor/schema-utils").TObject<{
        path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        script_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoCVoteRegistrationDelegation: import("@trezor/schema-utils").TObject<{
        vote_public_key: import("@trezor/schema-utils").TString;
        weight: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    CardanoCVoteRegistrationParametersType: import("@trezor/schema-utils").TObject<{
        vote_public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        staking_path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        payment_address_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                block_index: import("@trezor/schema-utils").TNumber;
                tx_index: import("@trezor/schema-utils").TNumber;
                certificate_index: import("@trezor/schema-utils").TNumber;
            }>>;
            script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
        nonce: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        format: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof CardanoCVoteRegistrationFormat>>;
        delegations: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            vote_public_key: import("@trezor/schema-utils").TString;
            weight: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        }>>>;
        voting_purpose: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        payment_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoTxAuxiliaryData: import("@trezor/schema-utils").TObject<{
        cvote_registration_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            vote_public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            staking_path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            payment_address_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
                address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    block_index: import("@trezor/schema-utils").TNumber;
                    tx_index: import("@trezor/schema-utils").TNumber;
                    certificate_index: import("@trezor/schema-utils").TNumber;
                }>>;
                script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
            nonce: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            format: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof CardanoCVoteRegistrationFormat>>;
            delegations: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                vote_public_key: import("@trezor/schema-utils").TString;
                weight: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            }>>>;
            voting_purpose: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            payment_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
        hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoTxMint: import("@trezor/schema-utils").TObject<{
        asset_groups_count: import("@trezor/schema-utils").TNumber;
    }>;
    CardanoTxCollateralInput: import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
    }>;
    CardanoTxRequiredSigner: import("@trezor/schema-utils").TObject<{
        key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        key_path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    }>;
    CardanoTxReferenceInput: import("@trezor/schema-utils").TObject<{
        prev_hash: import("@trezor/schema-utils").TString;
        prev_index: import("@trezor/schema-utils").TNumber;
    }>;
    CardanoTxItemAck: import("@trezor/schema-utils").TObject<{}>;
    CardanoTxAuxiliaryDataSupplement: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof CardanoTxAuxiliaryDataSupplementType>;
        auxiliary_data_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        cvote_registration_signature: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoTxWitnessRequest: import("@trezor/schema-utils").TObject<{
        path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    }>;
    CardanoTxWitnessResponse: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof CardanoTxWitnessType>;
        pub_key: import("@trezor/schema-utils").TString;
        signature: import("@trezor/schema-utils").TString;
        chain_code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CardanoTxHostAck: import("@trezor/schema-utils").TObject<{}>;
    CardanoTxBodyHash: import("@trezor/schema-utils").TObject<{
        tx_hash: import("@trezor/schema-utils").TString;
    }>;
    CardanoSignTxFinished: import("@trezor/schema-utils").TObject<{}>;
    CardanoSignMessageInit: import("@trezor/schema-utils").TObject<{
        protocol_magic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        network_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        signing_path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        payload_size: import("@trezor/schema-utils").TNumber;
        prefer_hex_display: import("@trezor/schema-utils").TBoolean;
        address_parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            address_type: import("@trezor/schema-utils").TEnum<typeof CardanoAddressType>;
            address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            address_n_staking: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
            staking_key_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            certificate_pointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                block_index: import("@trezor/schema-utils").TNumber;
                tx_index: import("@trezor/schema-utils").TNumber;
                certificate_index: import("@trezor/schema-utils").TNumber;
            }>>;
            script_payment_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            script_staking_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
        derivation_type: import("@trezor/schema-utils").TEnum<typeof CardanoDerivationType>;
    }>;
    CardanoMessageDataRequest: import("@trezor/schema-utils").TObject<{
        length: import("@trezor/schema-utils").TNumber;
        offset: import("@trezor/schema-utils").TNumber;
    }>;
    CardanoMessageDataResponse: import("@trezor/schema-utils").TObject<{
        data: import("@trezor/schema-utils").TString;
    }>;
    CardanoMessageSignature: import("@trezor/schema-utils").TObject<{
        signature: import("@trezor/schema-utils").TString;
        address: import("@trezor/schema-utils").TString;
        pub_key: import("@trezor/schema-utils").TString;
    }>;
    Success: import("@trezor/schema-utils").TObject<{
        message: import("@trezor/schema-utils").TString;
    }>;
    Failure: import("@trezor/schema-utils").TObject<{
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_FailureType>>;
        message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    ButtonRequest: import("@trezor/schema-utils").TObject<{
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_ButtonRequestType>>;
        pages: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    ButtonAck: import("@trezor/schema-utils").TObject<{}>;
    PinMatrixRequest: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_PinMatrixRequestType>>;
    }>;
    PinMatrixAck: import("@trezor/schema-utils").TObject<{
        pin: import("@trezor/schema-utils").TString;
    }>;
    PassphraseRequest: import("@trezor/schema-utils").TObject<{
        _on_device: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    PassphraseAck: import("@trezor/schema-utils").TObject<{
        passphrase: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        _state: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        on_device: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    Deprecated_PassphraseStateRequest: import("@trezor/schema-utils").TObject<{
        state: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    Deprecated_PassphraseStateAck: import("@trezor/schema-utils").TObject<{}>;
    CipherKeyValue: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        key: import("@trezor/schema-utils").TString;
        value: import("@trezor/schema-utils").TString;
        encrypt: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        ask_on_encrypt: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        ask_on_decrypt: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        iv: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    CipheredKeyValue: import("@trezor/schema-utils").TObject<{
        value: import("@trezor/schema-utils").TString;
    }>;
    IdentityType: import("@trezor/schema-utils").TObject<{
        proto: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        user: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        port: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    SignIdentity: import("@trezor/schema-utils").TObject<{
        identity: import("@trezor/schema-utils").TObject<{
            proto: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            user: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            port: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>;
        challenge_hidden: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        challenge_visual: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ecdsa_curve_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    SignedIdentity: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        public_key: import("@trezor/schema-utils").TString;
        signature: import("@trezor/schema-utils").TString;
    }>;
    GetECDHSessionKey: import("@trezor/schema-utils").TObject<{
        identity: import("@trezor/schema-utils").TObject<{
            proto: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            user: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            port: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            index: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>;
        peer_public_key: import("@trezor/schema-utils").TString;
        ecdsa_curve_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    ECDHSessionKey: import("@trezor/schema-utils").TObject<{
        session_key: import("@trezor/schema-utils").TString;
        public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    PaymentNotification: import("@trezor/schema-utils").TObject<{
        payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            recipient_name: import("@trezor/schema-utils").TString;
            memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    text: import("@trezor/schema-utils").TString;
                }>>;
                refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    coin_type: import("@trezor/schema-utils").TNumber;
                    amount: import("@trezor/schema-utils").TString;
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                }>>;
            }>>>;
            amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            signature: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    DebugLinkGetPairingInfo: import("@trezor/schema-utils").TObject<{
        channel_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        handshake_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        nfc_secret_host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    DebugLinkPairingInfo: import("@trezor/schema-utils").TObject<{
        channel_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        handshake_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        code_entry_code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        code_qr_code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        nfc_secret_trezor: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    DebugLinkResetDebugEvents: import("@trezor/schema-utils").TObject<{}>;
    DebugLinkOptigaSetSecMax: import("@trezor/schema-utils").TObject<{}>;
    DebugLinkGetGcInfo: import("@trezor/schema-utils").TObject<{}>;
    DebugLinkGcInfoItem: import("@trezor/schema-utils").TObject<{
        name: import("@trezor/schema-utils").TString;
        value: import("@trezor/schema-utils").TNumber;
    }>;
    DebugLinkGcInfo: import("@trezor/schema-utils").TObject<{
        items: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            name: import("@trezor/schema-utils").TString;
            value: import("@trezor/schema-utils").TNumber;
        }>>;
    }>;
    EthereumNetworkInfo: import("@trezor/schema-utils").TObject<{
        chain_id: import("@trezor/schema-utils").TNumber;
        symbol: import("@trezor/schema-utils").TString;
        slip44: import("@trezor/schema-utils").TNumber;
        name: import("@trezor/schema-utils").TString;
    }>;
    EthereumTokenInfo: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        chain_id: import("@trezor/schema-utils").TNumber;
        symbol: import("@trezor/schema-utils").TString;
        decimals: import("@trezor/schema-utils").TNumber;
        name: import("@trezor/schema-utils").TString;
    }>;
    SolanaTokenInfo: import("@trezor/schema-utils").TObject<{
        mint: import("@trezor/schema-utils").TString;
        symbol: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
    }>;
    EosGetPublicKey: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    EosPublicKey: import("@trezor/schema-utils").TObject<{
        wif_public_key: import("@trezor/schema-utils").TString;
        raw_public_key: import("@trezor/schema-utils").TString;
    }>;
    EosTxHeader: import("@trezor/schema-utils").TObject<{
        expiration: import("@trezor/schema-utils").TNumber;
        ref_block_num: import("@trezor/schema-utils").TNumber;
        ref_block_prefix: import("@trezor/schema-utils").TNumber;
        max_net_usage_words: import("@trezor/schema-utils").TNumber;
        max_cpu_usage_ms: import("@trezor/schema-utils").TNumber;
        delay_sec: import("@trezor/schema-utils").TNumber;
    }>;
    EosSignTx: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        chain_id: import("@trezor/schema-utils").TString;
        header: import("@trezor/schema-utils").TObject<{
            expiration: import("@trezor/schema-utils").TNumber;
            ref_block_num: import("@trezor/schema-utils").TNumber;
            ref_block_prefix: import("@trezor/schema-utils").TNumber;
            max_net_usage_words: import("@trezor/schema-utils").TNumber;
            max_cpu_usage_ms: import("@trezor/schema-utils").TNumber;
            delay_sec: import("@trezor/schema-utils").TNumber;
        }>;
        num_actions: import("@trezor/schema-utils").TNumber;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    EosTxActionRequest: import("@trezor/schema-utils").TObject<{
        data_size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    EosAsset: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        symbol: import("@trezor/schema-utils").TString;
    }>;
    EosPermissionLevel: import("@trezor/schema-utils").TObject<{
        actor: import("@trezor/schema-utils").TString;
        permission: import("@trezor/schema-utils").TString;
    }>;
    EosAuthorizationKey: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        key: import("@trezor/schema-utils").TString;
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        weight: import("@trezor/schema-utils").TNumber;
    }>;
    EosAuthorizationAccount: import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TObject<{
            actor: import("@trezor/schema-utils").TString;
            permission: import("@trezor/schema-utils").TString;
        }>;
        weight: import("@trezor/schema-utils").TNumber;
    }>;
    EosAuthorizationWait: import("@trezor/schema-utils").TObject<{
        wait_sec: import("@trezor/schema-utils").TNumber;
        weight: import("@trezor/schema-utils").TNumber;
    }>;
    EosAuthorization: import("@trezor/schema-utils").TObject<{
        threshold: import("@trezor/schema-utils").TNumber;
        keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            key: import("@trezor/schema-utils").TString;
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
        accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TObject<{
                actor: import("@trezor/schema-utils").TString;
                permission: import("@trezor/schema-utils").TString;
            }>;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
        waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            wait_sec: import("@trezor/schema-utils").TNumber;
            weight: import("@trezor/schema-utils").TNumber;
        }>>;
    }>;
    EosActionCommon: import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
        authorization: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            actor: import("@trezor/schema-utils").TString;
            permission: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    EosActionTransfer: import("@trezor/schema-utils").TObject<{
        sender: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
        memo: import("@trezor/schema-utils").TString;
    }>;
    EosActionDelegate: import("@trezor/schema-utils").TObject<{
        sender: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        net_quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
        cpu_quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
        transfer: import("@trezor/schema-utils").TBoolean;
    }>;
    EosActionUndelegate: import("@trezor/schema-utils").TObject<{
        sender: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        net_quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
        cpu_quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
    }>;
    EosActionRefund: import("@trezor/schema-utils").TObject<{
        owner: import("@trezor/schema-utils").TString;
    }>;
    EosActionBuyRam: import("@trezor/schema-utils").TObject<{
        payer: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        quantity: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            symbol: import("@trezor/schema-utils").TString;
        }>;
    }>;
    EosActionBuyRamBytes: import("@trezor/schema-utils").TObject<{
        payer: import("@trezor/schema-utils").TString;
        receiver: import("@trezor/schema-utils").TString;
        bytes: import("@trezor/schema-utils").TNumber;
    }>;
    EosActionSellRam: import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        bytes: import("@trezor/schema-utils").TNumber;
    }>;
    EosActionVoteProducer: import("@trezor/schema-utils").TObject<{
        voter: import("@trezor/schema-utils").TString;
        proxy: import("@trezor/schema-utils").TString;
        producers: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>;
    EosActionUpdateAuth: import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        permission: import("@trezor/schema-utils").TString;
        parent: import("@trezor/schema-utils").TString;
        auth: import("@trezor/schema-utils").TObject<{
            threshold: import("@trezor/schema-utils").TNumber;
            keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                key: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                account: import("@trezor/schema-utils").TObject<{
                    actor: import("@trezor/schema-utils").TString;
                    permission: import("@trezor/schema-utils").TString;
                }>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                wait_sec: import("@trezor/schema-utils").TNumber;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
        }>;
    }>;
    EosActionDeleteAuth: import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        permission: import("@trezor/schema-utils").TString;
    }>;
    EosActionLinkAuth: import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        code: import("@trezor/schema-utils").TString;
        type: import("@trezor/schema-utils").TString;
        requirement: import("@trezor/schema-utils").TString;
    }>;
    EosActionUnlinkAuth: import("@trezor/schema-utils").TObject<{
        account: import("@trezor/schema-utils").TString;
        code: import("@trezor/schema-utils").TString;
        type: import("@trezor/schema-utils").TString;
    }>;
    EosActionNewAccount: import("@trezor/schema-utils").TObject<{
        creator: import("@trezor/schema-utils").TString;
        name: import("@trezor/schema-utils").TString;
        owner: import("@trezor/schema-utils").TObject<{
            threshold: import("@trezor/schema-utils").TNumber;
            keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                key: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                account: import("@trezor/schema-utils").TObject<{
                    actor: import("@trezor/schema-utils").TString;
                    permission: import("@trezor/schema-utils").TString;
                }>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                wait_sec: import("@trezor/schema-utils").TNumber;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
        }>;
        active: import("@trezor/schema-utils").TObject<{
            threshold: import("@trezor/schema-utils").TNumber;
            keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                key: import("@trezor/schema-utils").TString;
                address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                account: import("@trezor/schema-utils").TObject<{
                    actor: import("@trezor/schema-utils").TString;
                    permission: import("@trezor/schema-utils").TString;
                }>;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
            waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                wait_sec: import("@trezor/schema-utils").TNumber;
                weight: import("@trezor/schema-utils").TNumber;
            }>>;
        }>;
    }>;
    EosActionUnknown: import("@trezor/schema-utils").TObject<{
        data_size: import("@trezor/schema-utils").TNumber;
        data_chunk: import("@trezor/schema-utils").TString;
    }>;
    EosTxActionAck: import("@trezor/schema-utils").TObject<{
        common: import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
            authorization: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                actor: import("@trezor/schema-utils").TString;
                permission: import("@trezor/schema-utils").TString;
            }>>;
        }>;
        transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            sender: import("@trezor/schema-utils").TString;
            receiver: import("@trezor/schema-utils").TString;
            quantity: import("@trezor/schema-utils").TObject<{
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                symbol: import("@trezor/schema-utils").TString;
            }>;
            memo: import("@trezor/schema-utils").TString;
        }>>;
        delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            sender: import("@trezor/schema-utils").TString;
            receiver: import("@trezor/schema-utils").TString;
            net_quantity: import("@trezor/schema-utils").TObject<{
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                symbol: import("@trezor/schema-utils").TString;
            }>;
            cpu_quantity: import("@trezor/schema-utils").TObject<{
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                symbol: import("@trezor/schema-utils").TString;
            }>;
            transfer: import("@trezor/schema-utils").TBoolean;
        }>>;
        undelegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            sender: import("@trezor/schema-utils").TString;
            receiver: import("@trezor/schema-utils").TString;
            net_quantity: import("@trezor/schema-utils").TObject<{
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                symbol: import("@trezor/schema-utils").TString;
            }>;
            cpu_quantity: import("@trezor/schema-utils").TObject<{
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                symbol: import("@trezor/schema-utils").TString;
            }>;
        }>>;
        refund: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            owner: import("@trezor/schema-utils").TString;
        }>>;
        buy_ram: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            payer: import("@trezor/schema-utils").TString;
            receiver: import("@trezor/schema-utils").TString;
            quantity: import("@trezor/schema-utils").TObject<{
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                symbol: import("@trezor/schema-utils").TString;
            }>;
        }>>;
        buy_ram_bytes: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            payer: import("@trezor/schema-utils").TString;
            receiver: import("@trezor/schema-utils").TString;
            bytes: import("@trezor/schema-utils").TNumber;
        }>>;
        sell_ram: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TString;
            bytes: import("@trezor/schema-utils").TNumber;
        }>>;
        vote_producer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            voter: import("@trezor/schema-utils").TString;
            proxy: import("@trezor/schema-utils").TString;
            producers: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        }>>;
        update_auth: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TString;
            permission: import("@trezor/schema-utils").TString;
            parent: import("@trezor/schema-utils").TString;
            auth: import("@trezor/schema-utils").TObject<{
                threshold: import("@trezor/schema-utils").TNumber;
                keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                    key: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    weight: import("@trezor/schema-utils").TNumber;
                }>>;
                accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    account: import("@trezor/schema-utils").TObject<{
                        actor: import("@trezor/schema-utils").TString;
                        permission: import("@trezor/schema-utils").TString;
                    }>;
                    weight: import("@trezor/schema-utils").TNumber;
                }>>;
                waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    wait_sec: import("@trezor/schema-utils").TNumber;
                    weight: import("@trezor/schema-utils").TNumber;
                }>>;
            }>;
        }>>;
        delete_auth: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TString;
            permission: import("@trezor/schema-utils").TString;
        }>>;
        link_auth: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TString;
            code: import("@trezor/schema-utils").TString;
            type: import("@trezor/schema-utils").TString;
            requirement: import("@trezor/schema-utils").TString;
        }>>;
        unlink_auth: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            account: import("@trezor/schema-utils").TString;
            code: import("@trezor/schema-utils").TString;
            type: import("@trezor/schema-utils").TString;
        }>>;
        new_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            creator: import("@trezor/schema-utils").TString;
            name: import("@trezor/schema-utils").TString;
            owner: import("@trezor/schema-utils").TObject<{
                threshold: import("@trezor/schema-utils").TNumber;
                keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                    key: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    weight: import("@trezor/schema-utils").TNumber;
                }>>;
                accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    account: import("@trezor/schema-utils").TObject<{
                        actor: import("@trezor/schema-utils").TString;
                        permission: import("@trezor/schema-utils").TString;
                    }>;
                    weight: import("@trezor/schema-utils").TNumber;
                }>>;
                waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    wait_sec: import("@trezor/schema-utils").TNumber;
                    weight: import("@trezor/schema-utils").TNumber;
                }>>;
            }>;
            active: import("@trezor/schema-utils").TObject<{
                threshold: import("@trezor/schema-utils").TNumber;
                keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                    key: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
                    weight: import("@trezor/schema-utils").TNumber;
                }>>;
                accounts: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    account: import("@trezor/schema-utils").TObject<{
                        actor: import("@trezor/schema-utils").TString;
                        permission: import("@trezor/schema-utils").TString;
                    }>;
                    weight: import("@trezor/schema-utils").TNumber;
                }>>;
                waits: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                    wait_sec: import("@trezor/schema-utils").TNumber;
                    weight: import("@trezor/schema-utils").TNumber;
                }>>;
            }>;
        }>>;
        unknown: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            data_size: import("@trezor/schema-utils").TNumber;
            data_chunk: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    EosSignedTx: import("@trezor/schema-utils").TObject<{
        signature: import("@trezor/schema-utils").TString;
    }>;
    EthereumDefinitions: import("@trezor/schema-utils").TObject<{
        encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    }>;
    EthereumSignTypedData: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        primary_type: import("@trezor/schema-utils").TString;
        metamask_v4_compat: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        definitions: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
            encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        }>>;
        show_message_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    EthereumTypedDataStructRequest: import("@trezor/schema-utils").TObject<{
        name: import("@trezor/schema-utils").TString;
    }>;
    EthereumFieldType: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
        data_type: import("@trezor/schema-utils").TEnum<typeof EthereumDataType>;
        size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        entry_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TThis>;
        struct_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
    EthereumStructMember: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
            data_type: import("@trezor/schema-utils").TEnum<typeof EthereumDataType>;
            size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            entry_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TThis>;
            struct_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
        name: import("@trezor/schema-utils").TString;
    }>;
    EthereumTypedDataStructAck: import("@trezor/schema-utils").TObject<{
        members: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TRecursive<import("@trezor/schema-utils").TObject<{
                data_type: import("@trezor/schema-utils").TEnum<typeof EthereumDataType>;
                size: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                entry_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TThis>;
                struct_name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
            name: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    EthereumTypedDataValueRequest: import("@trezor/schema-utils").TObject<{
        member_path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    }>;
    EthereumTypedDataValueAck: import("@trezor/schema-utils").TObject<{
        value: import("@trezor/schema-utils").TString;
    }>;
    EthereumGetPublicKey: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    EthereumPublicKey: import("@trezor/schema-utils").TObject<{
        node: import("@trezor/schema-utils").TObject<{
            depth: import("@trezor/schema-utils").TNumber;
            fingerprint: import("@trezor/schema-utils").TNumber;
            child_num: import("@trezor/schema-utils").TNumber;
            chain_code: import("@trezor/schema-utils").TString;
            private_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TString;
        }>;
        xpub: import("@trezor/schema-utils").TString;
    }>;
    EthereumGetAddress: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    EthereumAddress: import("@trezor/schema-utils").TObject<{
        _old_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        address: import("@trezor/schema-utils").TString;
        mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    EthereumSignTx: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        gas_price: import("@trezor/schema-utils").TString;
        gas_limit: import("@trezor/schema-utils").TString;
        to: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        value: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        data_initial_chunk: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        data_length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        chain_id: import("@trezor/schema-utils").TNumber;
        tx_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        definitions: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
            encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        }>>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            recipient_name: import("@trezor/schema-utils").TString;
            memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    text: import("@trezor/schema-utils").TString;
                }>>;
                refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    coin_type: import("@trezor/schema-utils").TNumber;
                    amount: import("@trezor/schema-utils").TString;
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                }>>;
            }>>>;
            amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            signature: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    EthereumAccessList: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        storage_keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>;
    EthereumSignTxEIP1559: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        nonce: import("@trezor/schema-utils").TString;
        max_gas_fee: import("@trezor/schema-utils").TString;
        max_priority_fee: import("@trezor/schema-utils").TString;
        gas_limit: import("@trezor/schema-utils").TString;
        to: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        value: import("@trezor/schema-utils").TString;
        data_initial_chunk: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        data_length: import("@trezor/schema-utils").TNumber;
        chain_id: import("@trezor/schema-utils").TNumber;
        access_list: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            address: import("@trezor/schema-utils").TString;
            storage_keys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        }>>;
        definitions: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
            encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        }>>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            recipient_name: import("@trezor/schema-utils").TString;
            memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    text: import("@trezor/schema-utils").TString;
                }>>;
                refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    coin_type: import("@trezor/schema-utils").TNumber;
                    amount: import("@trezor/schema-utils").TString;
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                }>>;
            }>>>;
            amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            signature: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    EthereumTxRequest: import("@trezor/schema-utils").TObject<{
        data_length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        signature_v: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        signature_r: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        signature_s: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    EthereumTxAck: import("@trezor/schema-utils").TObject<{
        data_chunk: import("@trezor/schema-utils").TString;
    }>;
    EthereumSignMessage: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        message: import("@trezor/schema-utils").TString;
        encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    EthereumMessageSignature: import("@trezor/schema-utils").TObject<{
        signature: import("@trezor/schema-utils").TString;
        address: import("@trezor/schema-utils").TString;
    }>;
    EthereumVerifyMessage: import("@trezor/schema-utils").TObject<{
        signature: import("@trezor/schema-utils").TString;
        message: import("@trezor/schema-utils").TString;
        address: import("@trezor/schema-utils").TString;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    EthereumSignTypedHash: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        domain_separator_hash: import("@trezor/schema-utils").TString;
        message_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        encoded_network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    }>;
    EthereumTypedDataSignature: import("@trezor/schema-utils").TObject<{
        signature: import("@trezor/schema-utils").TString;
        address: import("@trezor/schema-utils").TString;
    }>;
    EvoluGetNode: import("@trezor/schema-utils").TObject<{}>;
    EvoluNode: import("@trezor/schema-utils").TObject<{
        data: import("@trezor/schema-utils").TString;
    }>;
    Initialize: import("@trezor/schema-utils").TObject<{
        session_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        _skip_passphrase: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        derive_cardano: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    GetFeatures: import("@trezor/schema-utils").TObject<{}>;
    RecoveryDevice: import("@trezor/schema-utils").TObject<{
        word_count: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        passphrase_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        pin_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        enforce_wordlist: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        input_method: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof RecoveryDeviceInputMethod>>;
        u2f_counter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RecoveryType>>;
    }>;
    Features: import("@trezor/schema-utils").TObject<{
        vendor: import("@trezor/schema-utils").TString;
        major_version: import("@trezor/schema-utils").TNumber;
        minor_version: import("@trezor/schema-utils").TNumber;
        patch_version: import("@trezor/schema-utils").TNumber;
        bootloader_mode: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        device_id: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
        pin_protection: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        passphrase_protection: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        language: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
        label: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
        initialized: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        revision: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
        bootloader_hash: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
        imported: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        unlocked: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        _passphrase_cached: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        firmware_present: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        backup_availability: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_BackupAvailability>, import("@trezor/schema-utils").TNull]>;
        flags: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
        model: import("@trezor/schema-utils").TString;
        fw_major: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
        fw_minor: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
        fw_patch: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
        fw_vendor: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
        unfinished_backup: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        no_backup: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        recovery_status: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RecoveryStatus>, import("@trezor/schema-utils").TNull]>;
        capabilities: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_Capability>>;
        backup_type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_BackupType>, import("@trezor/schema-utils").TNull]>;
        sd_card_present: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        sd_protection: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        wipe_code_protection: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        session_id: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TNull]>;
        passphrase_always_on_device: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        safety_checks: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_SafetyCheckLevel>, import("@trezor/schema-utils").TNull]>;
        auto_lock_delay_ms: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TNull]>;
        display_rotation: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_DisplayRotation>, import("@trezor/schema-utils").TNull]>;
        experimental_features: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TBoolean, import("@trezor/schema-utils").TNull]>;
        busy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        homescreen_format: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_HomescreenFormat>>;
        hide_passphrase_from_host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        internal_model: import("@trezor/schema-utils").TEnum<typeof DeviceModelInternal>;
        unit_color: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        unit_btconly: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        homescreen_width: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        homescreen_height: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        bootloader_locked: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        language_version_matches: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        unit_packaging: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        haptic_feedback: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        recovery_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_RecoveryType>>;
        optiga_sec: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        soc: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    LockDevice: import("@trezor/schema-utils").TObject<{}>;
    SetBusy: import("@trezor/schema-utils").TObject<{
        expiry_ms: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    EndSession: import("@trezor/schema-utils").TObject<{}>;
    ApplySettings: import("@trezor/schema-utils").TObject<{
        language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        use_passphrase: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        homescreen: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        _passphrase_source: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        auto_lock_delay_ms: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        display_rotation: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_DisplayRotation>, import("@trezor/schema-utils").TEnum<typeof Enum_DisplayRotation>]>>;
        passphrase_always_on_device: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        safety_checks: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_SafetyCheckLevel>>;
        experimental_features: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        hide_passphrase_from_host: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        haptic_feedback: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        homescreen_length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    ChangeLanguage: import("@trezor/schema-utils").TObject<{
        data_length: import("@trezor/schema-utils").TNumber;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    DataChunkRequest: import("@trezor/schema-utils").TObject<{
        data_length: import("@trezor/schema-utils").TNumber;
        data_offset: import("@trezor/schema-utils").TNumber;
    }>;
    DataChunkAck: import("@trezor/schema-utils").TObject<{
        data_chunk: import("@trezor/schema-utils").TString;
    }>;
    ApplyFlags: import("@trezor/schema-utils").TObject<{
        flags: import("@trezor/schema-utils").TNumber;
    }>;
    ChangePin: import("@trezor/schema-utils").TObject<{
        remove: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    ChangeWipeCode: import("@trezor/schema-utils").TObject<{
        remove: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    SdProtect: import("@trezor/schema-utils").TObject<{
        operation: import("@trezor/schema-utils").TEnum<typeof SdProtectOperationType>;
    }>;
    Ping: import("@trezor/schema-utils").TObject<{
        message: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        button_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    Cancel: import("@trezor/schema-utils").TObject<{}>;
    GetEntropy: import("@trezor/schema-utils").TObject<{
        size: import("@trezor/schema-utils").TNumber;
    }>;
    Entropy: import("@trezor/schema-utils").TObject<{
        entropy: import("@trezor/schema-utils").TString;
    }>;
    GetFirmwareHash: import("@trezor/schema-utils").TObject<{
        challenge: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    FirmwareHash: import("@trezor/schema-utils").TObject<{
        hash: import("@trezor/schema-utils").TString;
    }>;
    AuthenticateDevice: import("@trezor/schema-utils").TObject<{
        challenge: import("@trezor/schema-utils").TString;
    }>;
    AuthenticityProof: import("@trezor/schema-utils").TObject<{
        certificates: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        signature: import("@trezor/schema-utils").TString;
    }>;
    WipeDevice: import("@trezor/schema-utils").TObject<{}>;
    LoadDevice: import("@trezor/schema-utils").TObject<{
        mnemonics: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        pin: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        passphrase_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        skip_checksum: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        u2f_counter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        needs_backup: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        no_backup: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    ResetDevice: import("@trezor/schema-utils").TObject<{
        strength: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        passphrase_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        pin_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        u2f_counter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        skip_backup: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        no_backup: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        backup_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof Enum_BackupType>>;
        entropy_check: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    Slip39Group: import("@trezor/schema-utils").TObject<{
        member_threshold: import("@trezor/schema-utils").TNumber;
        member_count: import("@trezor/schema-utils").TNumber;
    }>;
    BackupDevice: import("@trezor/schema-utils").TObject<{
        group_threshold: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        groups: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            member_threshold: import("@trezor/schema-utils").TNumber;
            member_count: import("@trezor/schema-utils").TNumber;
        }>>>;
    }>;
    EntropyRequest: import("@trezor/schema-utils").TObject<{
        entropy_commitment: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        prev_entropy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    EntropyAck: import("@trezor/schema-utils").TObject<{
        entropy: import("@trezor/schema-utils").TString;
    }>;
    EntropyCheckReady: import("@trezor/schema-utils").TObject<{}>;
    EntropyCheckContinue: import("@trezor/schema-utils").TObject<{
        finish: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    WordRequest: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof Enum_WordRequestType>;
    }>;
    WordAck: import("@trezor/schema-utils").TObject<{
        word: import("@trezor/schema-utils").TString;
    }>;
    SetU2FCounter: import("@trezor/schema-utils").TObject<{
        u2f_counter: import("@trezor/schema-utils").TNumber;
    }>;
    GetNextU2FCounter: import("@trezor/schema-utils").TObject<{}>;
    NextU2FCounter: import("@trezor/schema-utils").TObject<{
        u2f_counter: import("@trezor/schema-utils").TNumber;
    }>;
    DoPreauthorized: import("@trezor/schema-utils").TObject<{}>;
    PreauthorizedRequest: import("@trezor/schema-utils").TObject<{}>;
    CancelAuthorization: import("@trezor/schema-utils").TObject<{}>;
    RebootToBootloader: import("@trezor/schema-utils").TObject<{
        boot_command: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof BootCommand>>;
        firmware_header: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        language_data_length: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    GetNonce: import("@trezor/schema-utils").TObject<{}>;
    Nonce: import("@trezor/schema-utils").TObject<{
        nonce: import("@trezor/schema-utils").TString;
    }>;
    UnlockPath: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    UnlockedPathRequest: import("@trezor/schema-utils").TObject<{
        mac: import("@trezor/schema-utils").TString;
    }>;
    ShowDeviceTutorial: import("@trezor/schema-utils").TObject<{}>;
    UnlockBootloader: import("@trezor/schema-utils").TObject<{}>;
    SetBrightness: import("@trezor/schema-utils").TObject<{
        value: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    NEMGetAddress: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    NEMAddress: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
    }>;
    NEMTransactionCommon: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        timestamp: import("@trezor/schema-utils").TNumber;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        deadline: import("@trezor/schema-utils").TNumber;
        signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    NEMMosaic: import("@trezor/schema-utils").TObject<{
        namespace: import("@trezor/schema-utils").TString;
        mosaic: import("@trezor/schema-utils").TString;
        quantity: import("@trezor/schema-utils").TNumber;
    }>;
    NEMTransfer: import("@trezor/schema-utils").TObject<{
        recipient: import("@trezor/schema-utils").TString;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            namespace: import("@trezor/schema-utils").TString;
            mosaic: import("@trezor/schema-utils").TString;
            quantity: import("@trezor/schema-utils").TNumber;
        }>>>;
    }>;
    NEMProvisionNamespace: import("@trezor/schema-utils").TObject<{
        namespace: import("@trezor/schema-utils").TString;
        parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        sink: import("@trezor/schema-utils").TString;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    NEMMosaicDefinition: import("@trezor/schema-utils").TObject<{
        name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        ticker: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        namespace: import("@trezor/schema-utils").TString;
        mosaic: import("@trezor/schema-utils").TString;
        divisibility: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof NEMMosaicLevy>>;
        fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        levy_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        levy_namespace: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        levy_mosaic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        mutable_supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        transferable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        description: import("@trezor/schema-utils").TString;
        networks: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
    }>;
    NEMMosaicCreation: import("@trezor/schema-utils").TObject<{
        definition: import("@trezor/schema-utils").TObject<{
            name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            ticker: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            namespace: import("@trezor/schema-utils").TString;
            mosaic: import("@trezor/schema-utils").TString;
            divisibility: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof NEMMosaicLevy>>;
            fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            levy_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            levy_namespace: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            levy_mosaic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            mutable_supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
            transferable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
            description: import("@trezor/schema-utils").TString;
            networks: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        }>;
        sink: import("@trezor/schema-utils").TString;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    NEMMosaicSupplyChange: import("@trezor/schema-utils").TObject<{
        namespace: import("@trezor/schema-utils").TString;
        mosaic: import("@trezor/schema-utils").TString;
        type: import("@trezor/schema-utils").TEnum<typeof NEMSupplyChangeType>;
        delta: import("@trezor/schema-utils").TNumber;
    }>;
    NEMCosignatoryModification: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof NEMModificationType>;
        public_key: import("@trezor/schema-utils").TString;
    }>;
    NEMAggregateModification: import("@trezor/schema-utils").TObject<{
        modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TEnum<typeof NEMModificationType>;
            public_key: import("@trezor/schema-utils").TString;
        }>>>;
        relative_change: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    NEMImportanceTransfer: import("@trezor/schema-utils").TObject<{
        mode: import("@trezor/schema-utils").TEnum<typeof NEMImportanceTransferMode>;
        public_key: import("@trezor/schema-utils").TString;
    }>;
    NEMSignTx: import("@trezor/schema-utils").TObject<{
        transaction: import("@trezor/schema-utils").TObject<{
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            timestamp: import("@trezor/schema-utils").TNumber;
            fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            deadline: import("@trezor/schema-utils").TNumber;
            signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        multisig: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            address_n: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
            timestamp: import("@trezor/schema-utils").TNumber;
            fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            deadline: import("@trezor/schema-utils").TNumber;
            signer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
        transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            recipient: import("@trezor/schema-utils").TString;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            mosaics: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                namespace: import("@trezor/schema-utils").TString;
                mosaic: import("@trezor/schema-utils").TString;
                quantity: import("@trezor/schema-utils").TNumber;
            }>>>;
        }>>;
        cosigning: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        provision_namespace: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            namespace: import("@trezor/schema-utils").TString;
            parent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            sink: import("@trezor/schema-utils").TString;
            fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        }>>;
        mosaic_creation: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            definition: import("@trezor/schema-utils").TObject<{
                name: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                ticker: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                namespace: import("@trezor/schema-utils").TString;
                mosaic: import("@trezor/schema-utils").TString;
                divisibility: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                levy: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof NEMMosaicLevy>>;
                fee: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
                levy_address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                levy_namespace: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                levy_mosaic: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                mutable_supply: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
                transferable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
                description: import("@trezor/schema-utils").TString;
                networks: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            }>;
            sink: import("@trezor/schema-utils").TString;
            fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        }>>;
        supply_change: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            namespace: import("@trezor/schema-utils").TString;
            mosaic: import("@trezor/schema-utils").TString;
            type: import("@trezor/schema-utils").TEnum<typeof NEMSupplyChangeType>;
            delta: import("@trezor/schema-utils").TNumber;
        }>>;
        aggregate_modification: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            modifications: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TEnum<typeof NEMModificationType>;
                public_key: import("@trezor/schema-utils").TString;
            }>>>;
            relative_change: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>>;
        importance_transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            mode: import("@trezor/schema-utils").TEnum<typeof NEMImportanceTransferMode>;
            public_key: import("@trezor/schema-utils").TString;
        }>>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    NEMSignedTx: import("@trezor/schema-utils").TObject<{
        data: import("@trezor/schema-utils").TString;
        signature: import("@trezor/schema-utils").TString;
    }>;
    NEMDecryptMessage: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        public_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        payload: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    NEMDecryptedMessage: import("@trezor/schema-utils").TObject<{
        payload: import("@trezor/schema-utils").TString;
    }>;
    RippleGetAddress: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    RippleAddress: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    RipplePayment: import("@trezor/schema-utils").TObject<{
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        destination: import("@trezor/schema-utils").TString;
        destination_tag: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    RippleSignTx: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        sequence: import("@trezor/schema-utils").TNumber;
        last_ledger_sequence: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        payment: import("@trezor/schema-utils").TObject<{
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            destination: import("@trezor/schema-utils").TString;
            destination_tag: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        }>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            recipient_name: import("@trezor/schema-utils").TString;
            memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    text: import("@trezor/schema-utils").TString;
                }>>;
                refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    coin_type: import("@trezor/schema-utils").TNumber;
                    amount: import("@trezor/schema-utils").TString;
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                }>>;
            }>>>;
            amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            signature: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    RippleSignedTx: import("@trezor/schema-utils").TObject<{
        signature: import("@trezor/schema-utils").TString;
        serialized_tx: import("@trezor/schema-utils").TString;
    }>;
    SolanaGetPublicKey: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    SolanaPublicKey: import("@trezor/schema-utils").TObject<{
        public_key: import("@trezor/schema-utils").TString;
    }>;
    SolanaGetAddress: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    SolanaAddress: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    SolanaTxTokenAccountInfo: import("@trezor/schema-utils").TObject<{
        base_address: import("@trezor/schema-utils").TString;
        token_program: import("@trezor/schema-utils").TString;
        token_mint: import("@trezor/schema-utils").TString;
        token_account: import("@trezor/schema-utils").TString;
    }>;
    SolanaTxAdditionalInfo: import("@trezor/schema-utils").TObject<{
        token_accounts_infos: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            base_address: import("@trezor/schema-utils").TString;
            token_program: import("@trezor/schema-utils").TString;
            token_mint: import("@trezor/schema-utils").TString;
            token_account: import("@trezor/schema-utils").TString;
        }>>;
        encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
    }>;
    SolanaSignTx: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        serialized_tx: import("@trezor/schema-utils").TString;
        additional_info: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            token_accounts_infos: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                base_address: import("@trezor/schema-utils").TString;
                token_program: import("@trezor/schema-utils").TString;
                token_mint: import("@trezor/schema-utils").TString;
                token_account: import("@trezor/schema-utils").TString;
            }>>;
            encoded_token: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/array-buffer").TArrayBuffer>;
        }>>;
        payment_req: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            nonce: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            recipient_name: import("@trezor/schema-utils").TString;
            memos: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                text_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    text: import("@trezor/schema-utils").TString;
                }>>;
                refund_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                coin_purchase_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    coin_type: import("@trezor/schema-utils").TNumber;
                    amount: import("@trezor/schema-utils").TString;
                    address: import("@trezor/schema-utils").TString;
                    address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
                    mac: import("@trezor/schema-utils").TString;
                }>>;
                text_details_memo: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    title: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                    text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                }>>;
            }>>>;
            amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
            signature: import("@trezor/schema-utils").TString;
        }>>;
    }>;
    SolanaTxSignature: import("@trezor/schema-utils").TObject<{
        signature: import("@trezor/schema-utils").TString;
    }>;
    StellarAsset: import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
        code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    StellarGetAddress: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    StellarAddress: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    StellarSignTx: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        network_passphrase: import("@trezor/schema-utils").TString;
        source_account: import("@trezor/schema-utils").TString;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        sequence_number: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        timebounds_start: import("@trezor/schema-utils").TNumber;
        timebounds_end: import("@trezor/schema-utils").TNumber;
        memo_type: import("@trezor/schema-utils").TEnum<typeof StellarMemoType>;
        memo_text: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        memo_id: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        memo_hash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/buffer").TBuffer, import("@trezor/schema-utils").TString]>>;
        num_operations: import("@trezor/schema-utils").TNumber;
    }>;
    StellarTxOpRequest: import("@trezor/schema-utils").TObject<{}>;
    StellarPaymentOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        destination_account: import("@trezor/schema-utils").TString;
        asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    StellarCreateAccountOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        new_account: import("@trezor/schema-utils").TString;
        starting_balance: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    StellarPathPaymentStrictReceiveOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        send_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        send_max: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        destination_account: import("@trezor/schema-utils").TString;
        destination_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        destination_amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        paths: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>>;
    }>;
    StellarPathPaymentStrictSendOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        send_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        send_amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        destination_account: import("@trezor/schema-utils").TString;
        destination_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        destination_min: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        paths: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>>;
    }>;
    StellarManageSellOfferOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        selling_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        buying_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        price_n: import("@trezor/schema-utils").TNumber;
        price_d: import("@trezor/schema-utils").TNumber;
        offer_id: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    StellarManageBuyOfferOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        selling_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        buying_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        price_n: import("@trezor/schema-utils").TNumber;
        price_d: import("@trezor/schema-utils").TNumber;
        offer_id: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    StellarCreatePassiveSellOfferOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        selling_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        buying_asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        price_n: import("@trezor/schema-utils").TNumber;
        price_d: import("@trezor/schema-utils").TNumber;
    }>;
    StellarSetOptionsOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        inflation_destination_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        clear_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        set_flags: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
        master_weight: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        low_threshold: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        medium_threshold: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        high_threshold: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/uint").TUint>;
        home_domain: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        signer_type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof StellarSignerType>>;
        signer_key: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/buffer").TBuffer, import("@trezor/schema-utils").TString]>>;
        signer_weight: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    StellarChangeTrustOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        asset: import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<0>, import("@trezor/schema-utils").TLiteral<1>, import("@trezor/schema-utils").TLiteral<2>, import("@trezor/schema-utils").TLiteral<"NATIVE">, import("@trezor/schema-utils").TLiteral<"ALPHANUM4">, import("@trezor/schema-utils").TLiteral<"ALPHANUM12">]>;
            code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            issuer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>;
        limit: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    StellarAllowTrustOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        trusted_account: import("@trezor/schema-utils").TString;
        asset_type: import("@trezor/schema-utils").TEnum<typeof StellarAssetType>;
        asset_code: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        is_authorized: import("@trezor/schema-utils").TBoolean;
    }>;
    StellarAccountMergeOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        destination_account: import("@trezor/schema-utils").TString;
    }>;
    StellarManageDataOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        key: import("@trezor/schema-utils").TString;
        value: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils/lib/custom-types/buffer").TBuffer, import("@trezor/schema-utils").TString]>>;
    }>;
    StellarBumpSequenceOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        bump_to: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    StellarClaimClaimableBalanceOp: import("@trezor/schema-utils").TObject<{
        source_account: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        balance_id: import("@trezor/schema-utils").TString;
    }>;
    StellarSignedTx: import("@trezor/schema-utils").TObject<{
        public_key: import("@trezor/schema-utils").TString;
        signature: import("@trezor/schema-utils").TString;
    }>;
    TezosGetAddress: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    TezosAddress: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        mac: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>;
    TezosGetPublicKey: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        show_display: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    TezosPublicKey: import("@trezor/schema-utils").TObject<{
        public_key: import("@trezor/schema-utils").TString;
    }>;
    TezosContractID: import("@trezor/schema-utils").TObject<{
        tag: import("@trezor/schema-utils").TNumber;
        hash: import("@trezor/schema-utils").TUint8Array;
    }>;
    TezosRevealOp: import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TUint8Array;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        counter: import("@trezor/schema-utils").TNumber;
        gas_limit: import("@trezor/schema-utils").TNumber;
        storage_limit: import("@trezor/schema-utils").TNumber;
        public_key: import("@trezor/schema-utils").TUint8Array;
    }>;
    TezosManagerTransfer: import("@trezor/schema-utils").TObject<{
        destination: import("@trezor/schema-utils").TObject<{
            tag: import("@trezor/schema-utils").TNumber;
            hash: import("@trezor/schema-utils").TUint8Array;
        }>;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
    }>;
    TezosParametersManager: import("@trezor/schema-utils").TObject<{
        set_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
        cancel_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            destination: import("@trezor/schema-utils").TObject<{
                tag: import("@trezor/schema-utils").TNumber;
                hash: import("@trezor/schema-utils").TUint8Array;
            }>;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        }>>;
    }>;
    TezosTransactionOp: import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TUint8Array;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        counter: import("@trezor/schema-utils").TNumber;
        gas_limit: import("@trezor/schema-utils").TNumber;
        storage_limit: import("@trezor/schema-utils").TNumber;
        amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        destination: import("@trezor/schema-utils").TObject<{
            tag: import("@trezor/schema-utils").TNumber;
            hash: import("@trezor/schema-utils").TUint8Array;
        }>;
        parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
        parameters_manager: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            set_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
            cancel_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
            transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                destination: import("@trezor/schema-utils").TObject<{
                    tag: import("@trezor/schema-utils").TNumber;
                    hash: import("@trezor/schema-utils").TUint8Array;
                }>;
                amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            }>>;
        }>>;
    }>;
    TezosOriginationOp: import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TUint8Array;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        counter: import("@trezor/schema-utils").TNumber;
        gas_limit: import("@trezor/schema-utils").TNumber;
        storage_limit: import("@trezor/schema-utils").TNumber;
        manager_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        balance: import("@trezor/schema-utils").TNumber;
        spendable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        delegatable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
        script: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
    }>;
    TezosDelegationOp: import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TUint8Array;
        fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
        counter: import("@trezor/schema-utils").TNumber;
        gas_limit: import("@trezor/schema-utils").TNumber;
        storage_limit: import("@trezor/schema-utils").TNumber;
        delegate: import("@trezor/schema-utils").TUint8Array;
    }>;
    TezosProposalOp: import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TString;
        period: import("@trezor/schema-utils").TNumber;
        proposals: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>;
    TezosBallotOp: import("@trezor/schema-utils").TObject<{
        source: import("@trezor/schema-utils").TString;
        period: import("@trezor/schema-utils").TNumber;
        proposal: import("@trezor/schema-utils").TString;
        ballot: import("@trezor/schema-utils").TEnum<typeof TezosBallotType>;
    }>;
    TezosSignTx: import("@trezor/schema-utils").TObject<{
        address_n: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
        branch: import("@trezor/schema-utils").TUint8Array;
        reveal: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            source: import("@trezor/schema-utils").TUint8Array;
            fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            counter: import("@trezor/schema-utils").TNumber;
            gas_limit: import("@trezor/schema-utils").TNumber;
            storage_limit: import("@trezor/schema-utils").TNumber;
            public_key: import("@trezor/schema-utils").TUint8Array;
        }>>;
        transaction: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            source: import("@trezor/schema-utils").TUint8Array;
            fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            counter: import("@trezor/schema-utils").TNumber;
            gas_limit: import("@trezor/schema-utils").TNumber;
            storage_limit: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            destination: import("@trezor/schema-utils").TObject<{
                tag: import("@trezor/schema-utils").TNumber;
                hash: import("@trezor/schema-utils").TUint8Array;
            }>;
            parameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>>;
            parameters_manager: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                set_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
                cancel_delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
                transfer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                    destination: import("@trezor/schema-utils").TObject<{
                        tag: import("@trezor/schema-utils").TNumber;
                        hash: import("@trezor/schema-utils").TUint8Array;
                    }>;
                    amount: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
                }>>;
            }>>;
        }>>;
        origination: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            source: import("@trezor/schema-utils").TUint8Array;
            fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            counter: import("@trezor/schema-utils").TNumber;
            gas_limit: import("@trezor/schema-utils").TNumber;
            storage_limit: import("@trezor/schema-utils").TNumber;
            manager_pubkey: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            balance: import("@trezor/schema-utils").TNumber;
            spendable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
            delegatable: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
            delegate: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUint8Array>;
            script: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
        }>>;
        delegation: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            source: import("@trezor/schema-utils").TUint8Array;
            fee: import("@trezor/schema-utils/lib/custom-types/uint").TUint;
            counter: import("@trezor/schema-utils").TNumber;
            gas_limit: import("@trezor/schema-utils").TNumber;
            storage_limit: import("@trezor/schema-utils").TNumber;
            delegate: import("@trezor/schema-utils").TUint8Array;
        }>>;
        proposal: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            source: import("@trezor/schema-utils").TString;
            period: import("@trezor/schema-utils").TNumber;
            proposals: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        }>>;
        ballot: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            source: import("@trezor/schema-utils").TString;
            period: import("@trezor/schema-utils").TNumber;
            proposal: import("@trezor/schema-utils").TString;
            ballot: import("@trezor/schema-utils").TEnum<typeof TezosBallotType>;
        }>>;
        chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    }>;
    TezosSignedTx: import("@trezor/schema-utils").TObject<{
        signature: import("@trezor/schema-utils").TString;
        sig_op_contents: import("@trezor/schema-utils").TString;
        operation_hash: import("@trezor/schema-utils").TString;
    }>;
}>;
export type MessageKey = keyof MessageType;
export type MessagePayload<T extends MessageKey = MessageKey> = MessageType[T];
export type MessageResponse<T extends MessageKey = MessageKey> = T extends any ? {
    type: T;
    message: MessagePayload<T>;
} : never;
export type TypedCall = {
    <T extends MessageKey, R extends MessageKey[]>(type: T, resType: R, message?: MessagePayload<T>): Promise<MessageResponse<R[number]>>;
    <T extends MessageKey, R extends MessageKey>(type: T, resType: R, message?: MessagePayload<T>): Promise<MessageResponse<R>>;
};
//# sourceMappingURL=messages-schema.d.ts.map