"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOnionDomain = exports.getHost = exports.getOrigin = void 0;
const utils_1 = require("@trezor/utils");
const getOrigin = (url) => {
    if (typeof url !== 'string')
        return 'unknown';
    if (url.indexOf('file://') === 0)
        return 'file://';
    const [origin] = url.match(/^https?:\/\/[^/]+/) ?? [];
    return origin ?? 'unknown';
};
exports.getOrigin = getOrigin;
const getHost = (url) => {
    if (typeof url !== 'string')
        return;
    const [, , uri] = url.match(/^(https?):\/\/([^:/]+)?/i) ?? [];
    if (uri) {
        const parts = uri.split('.');
        if (parts[parts.length - 1] === 'localhost')
            return 'localhost';
        return parts.length > 2
            ?
                parts.slice(parts.length - 2, parts.length).join('.')
            : uri;
    }
};
exports.getHost = getHost;
const getOnionDomain = (url, dict) => {
    if (Array.isArray(url))
        return url.map(u => (0, utils_1.urlToOnion)(u, dict) ?? u);
    if (typeof url === 'string')
        return (0, utils_1.urlToOnion)(url, dict) ?? url;
    return url;
};
exports.getOnionDomain = getOnionDomain;
//# sourceMappingURL=urlUtils.js.map