import type { CoinInfo } from '../types';
export declare const formatAmount: (n: string, coinInfo: CoinInfo) => string;
export declare const formatTime: (n: number) => string;
export declare const btckb2satoshib: (n: string) => string;
export declare const hasHexPrefix: (str: string) => boolean;
export declare const stripHexPrefix: (str: string) => string;
export declare const addHexPrefix: (str: string) => `0x${string}`;
export declare const isHexString: (value: string, length?: number) => boolean;
export declare const messageToHex: (message: string) => string;
export declare const hexToText: (hex: string) => string;
export declare const deepTransform: <V>(transform: (str: string) => V) => <T>(value: T) => DeepTransformed<T, V>;
type DeepTransformed<T, V> = T extends string ? V : T extends (infer U)[] ? DeepTransformed<U, V>[] : T extends object ? {
    [K in keyof T]: DeepTransformed<T[K], V>;
} : T;
export {};
//# sourceMappingURL=formatUtils.d.ts.map