"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isUtxoBased = exports.getPublicKeyLabel = exports.getAccountLabel = exports.getAccountAddressN = void 0;
const pathUtils_1 = require("./pathUtils");
const constants_1 = require("../constants");
const coinInfo_1 = require("../data/coinInfo");
const getAccountAddressN = (coinInfo, accountIndex, bip44) => {
    if (!coinInfo) {
        throw constants_1.ERRORS.TypedError('Method_UnknownCoin');
    }
    const index = typeof accountIndex === 'number' ? accountIndex : 0;
    const options = {
        purpose: 44,
        coinType: coinInfo.slip44,
        ...bip44,
    };
    if (coinInfo.type === 'bitcoin') {
        return [(0, pathUtils_1.toHardened)(options.purpose), (0, pathUtils_1.toHardened)(options.coinType), (0, pathUtils_1.toHardened)(index)];
    }
    if (coinInfo.shortcut === 'ADA' || coinInfo.shortcut === 'tADA') {
        return [(0, pathUtils_1.toHardened)(1852), (0, pathUtils_1.toHardened)(options.coinType), (0, pathUtils_1.toHardened)(index)];
    }
    if (coinInfo.type === 'ethereum') {
        return [(0, pathUtils_1.toHardened)(options.purpose), (0, pathUtils_1.toHardened)(options.coinType), (0, pathUtils_1.toHardened)(0), 0, index];
    }
    if (coinInfo.shortcut === 'tXRP') {
        return [(0, pathUtils_1.toHardened)(options.purpose), (0, pathUtils_1.toHardened)(144), (0, pathUtils_1.toHardened)(index), 0, 0];
    }
    return [(0, pathUtils_1.toHardened)(options.purpose), (0, pathUtils_1.toHardened)(options.coinType), (0, pathUtils_1.toHardened)(index), 0, 0];
};
exports.getAccountAddressN = getAccountAddressN;
const getAccountLabel = (path, coinInfo) => {
    if (coinInfo.type === 'bitcoin') {
        const accountType = (0, pathUtils_1.fromHardened)(path[0]);
        const account = (0, pathUtils_1.fromHardened)(path[2]);
        let prefix = '';
        if (accountType === 48) {
            prefix = 'multisig';
        }
        else if (accountType === 49 && coinInfo.segwit) {
            prefix = 'segwit';
        }
        else if (accountType === 44 && coinInfo.segwit) {
            prefix = 'legacy';
        }
        return `${prefix} account #${account + 1}`;
    }
    const account = (0, pathUtils_1.fromHardened)(path[4]);
    return `account #${account + 1}`;
};
exports.getAccountLabel = getAccountLabel;
const getPublicKeyLabel = (path, coinInfo) => {
    let hasSegwit = false;
    let coinLabel = 'Unknown coin';
    if (coinInfo) {
        coinLabel = coinInfo.label;
        hasSegwit = coinInfo.segwit;
    }
    else {
        coinLabel = (0, coinInfo_1.getCoinName)(path);
    }
    const p1 = (0, pathUtils_1.fromHardened)(path[0]);
    let account = path.length >= 3 ? (0, pathUtils_1.fromHardened)(path[2]) : -1;
    let realAccountId = account + 1;
    let prefix = 'Export public key';
    let accountType = '';
    if (p1 === 45342) {
        const p2 = (0, pathUtils_1.fromHardened)(path[1]);
        account = (0, pathUtils_1.fromHardened)(path[3]);
        realAccountId = account + 1;
        prefix = 'Export Copay ID of';
        if (p2 === 48) {
            accountType = 'multisig';
        }
        else if (p2 === 44) {
            accountType = 'legacy';
        }
    }
    else if (p1 === 48) {
        accountType = `${coinLabel} multisig`;
    }
    else if (p1 === 44 && hasSegwit) {
        accountType = `${coinLabel} legacy`;
    }
    else if (p1 === 84 && hasSegwit) {
        accountType = `${coinLabel} native segwit`;
    }
    else {
        accountType = coinLabel;
    }
    if (realAccountId > 0) {
        return `${prefix} of ${accountType} account #${realAccountId}`;
    }
    return prefix;
};
exports.getPublicKeyLabel = getPublicKeyLabel;
const isUtxoBased = (coinInfo) => coinInfo.type === 'bitcoin' || coinInfo.shortcut === 'ADA' || coinInfo.shortcut === 'tADA';
exports.isUtxoBased = isUtxoBased;
//# sourceMappingURL=accountUtils.js.map