import { Static, TSchema } from '@trezor/schema-utils';
import { DeviceState, DeviceUniquePath } from './device';
import { ErrorCode } from '../constants/errors';
export interface DeviceIdentity {
    path?: DeviceUniquePath;
    state?: DeviceState;
    instance?: number;
}
export interface CommonParams {
    device?: DeviceIdentity & {
        state?: DeviceState | string;
    };
    useEmptyPassphrase?: boolean;
    useEventListener?: boolean;
    allowSeedlessDevice?: boolean;
    keepSession?: boolean;
    override?: boolean;
    skipFinalReload?: boolean;
    useCardanoDerivation?: boolean;
    chunkify?: boolean;
    __info?: boolean;
    __precomposed?: boolean;
}
export type Params<T> = CommonParams & T & {
    bundle?: undefined;
};
interface Bundle<T> {
    bundle: T[];
}
export declare const Bundle: <T extends TSchema>(type: T) => import("@trezor/schema-utils").TObject<{
    bundle: import("@trezor/schema-utils").TArray<T>;
}>;
export type BundledParams<T> = CommonParams & Bundle<T>;
export interface CommonParamsWithCoin extends CommonParams {
    coin: string;
    identity?: string;
}
export interface Unsuccessful {
    success: false;
    payload: {
        error: string;
        code?: ErrorCode;
    };
}
export interface Success<T> {
    success: true;
    payload: T;
}
export interface SuccessWithDevice<T> extends Success<T> {
    device?: DeviceIdentity;
}
export type Response<T> = Promise<SuccessWithDevice<T> | Unsuccessful>;
export type DerivationPath = string | number[];
export declare const DerivationPath: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
type ProtoWithExtendedAddressN<T, A, R> = Omit<Extract<T, {
    address_n: A;
}>, 'address_n'> & {
    address_n: R;
};
type ProtoWithoutAddressN<T, A> = Exclude<T, {
    address_n: A;
}>;
export type ProtoWithDerivationPath<T> = ProtoWithoutAddressN<T, number[]> | ProtoWithExtendedAddressN<T, number[], DerivationPath>;
export type ProtoWithAddressN<P extends ProtoWithDerivationPath<any>> = P extends ProtoWithDerivationPath<infer T> ? T : unknown;
export type GetAddress = Static<typeof GetAddress>;
export declare const GetAddress: import("@trezor/schema-utils").TObject<{
    path: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
    address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    showOnTrezor: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    useEventListener: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export interface Address {
    address: string;
    path: number[];
    serializedPath: string;
    mac?: string;
}
export type GetPublicKey = Static<typeof GetPublicKey>;
export declare const GetPublicKey: import("@trezor/schema-utils").TObject<{
    path: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
    showOnTrezor: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    suppressBackupWarning: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    chunkify: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type PublicKey = Static<typeof PublicKey>;
export declare const PublicKey: import("@trezor/schema-utils").TObject<{
    publicKey: import("@trezor/schema-utils").TString;
    path: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>;
    serializedPath: import("@trezor/schema-utils").TString;
}>;
export {};
//# sourceMappingURL=params.d.ts.map