import { Static } from '@trezor/schema-utils';
export type Bip32 = Static<typeof Bip32>;
export declare const Bip32: import("@trezor/schema-utils").TObject<{
    public: import("@trezor/schema-utils").TNumber;
    private: import("@trezor/schema-utils").TNumber;
}>;
export type Network = Static<typeof Network>;
export declare const Network: import("@trezor/schema-utils").TObject<{
    messagePrefix: import("@trezor/schema-utils").TString;
    bech32: import("@trezor/schema-utils").TString;
    bip32: import("@trezor/schema-utils").TObject<{
        public: import("@trezor/schema-utils").TNumber;
        private: import("@trezor/schema-utils").TNumber;
    }>;
    pubKeyHash: import("@trezor/schema-utils").TNumber;
    scriptHash: import("@trezor/schema-utils").TNumber;
    wif: import("@trezor/schema-utils").TNumber;
    forkId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
}>;
export type CoinObj = Static<typeof CoinObj>;
export declare const CoinObj: import("@trezor/schema-utils").TObject<{
    coin: import("@trezor/schema-utils").TString;
    identity: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CoinSupport = Static<typeof CoinSupport>;
export declare const CoinSupport: import("@trezor/schema-utils").TObject<{
    connect: import("@trezor/schema-utils").TBoolean;
    T1B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    T2T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    T2B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    T3B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    T3T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    T3W1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    UNKNOWN: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
}>;
export type BlockchainLink = Static<typeof BlockchainLink>;
export declare const BlockchainLink: import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TString;
    url: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
}>;
export type BitcoinNetworkInfo = Static<typeof BitcoinNetworkInfo>;
export declare const BitcoinNetworkInfo: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    label: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
    shortcut: import("@trezor/schema-utils").TString;
    slip44: import("@trezor/schema-utils").TNumber;
    support: import("@trezor/schema-utils").TObject<{
        connect: import("@trezor/schema-utils").TBoolean;
        T1B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3W1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        UNKNOWN: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    }>;
    decimals: import("@trezor/schema-utils").TNumber;
    blockchainLink: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TString;
        url: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
    blockTime: import("@trezor/schema-utils").TNumber;
    minFee: import("@trezor/schema-utils").TNumber;
    maxFee: import("@trezor/schema-utils").TNumber;
    minPriorityFee: import("@trezor/schema-utils").TNumber;
    defaultFees: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        label: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"high">, import("@trezor/schema-utils").TLiteral<"normal">, import("@trezor/schema-utils").TLiteral<"economy">, import("@trezor/schema-utils").TLiteral<"low">, import("@trezor/schema-utils").TLiteral<"custom">]>;
        blocks: import("@trezor/schema-utils").TNumber;
        feePerUnit: import("@trezor/schema-utils").TString;
        feePerTx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        feeLimit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        baseFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxPriorityFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<"bitcoin">;
    cashAddrPrefix: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    curveName: import("@trezor/schema-utils").TString;
    dustLimit: import("@trezor/schema-utils").TNumber;
    forceBip143: import("@trezor/schema-utils").TBoolean;
    hashGenesisBlock: import("@trezor/schema-utils").TString;
    maxAddressLength: import("@trezor/schema-utils").TNumber;
    maxFeeSatoshiKb: import("@trezor/schema-utils").TNumber;
    minAddressLength: import("@trezor/schema-utils").TNumber;
    minFeeSatoshiKb: import("@trezor/schema-utils").TNumber;
    segwit: import("@trezor/schema-utils").TBoolean;
    xPubMagic: import("@trezor/schema-utils").TNumber;
    xPubMagicSegwitNative: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    xPubMagicSegwit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    taproot: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    network: import("@trezor/schema-utils").TObject<{
        messagePrefix: import("@trezor/schema-utils").TString;
        bech32: import("@trezor/schema-utils").TString;
        bip32: import("@trezor/schema-utils").TObject<{
            public: import("@trezor/schema-utils").TNumber;
            private: import("@trezor/schema-utils").TNumber;
        }>;
        pubKeyHash: import("@trezor/schema-utils").TNumber;
        scriptHash: import("@trezor/schema-utils").TNumber;
        wif: import("@trezor/schema-utils").TNumber;
        forkId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    isBitcoin: import("@trezor/schema-utils").TBoolean;
}>]>;
export type EthereumNetworkInfo = Static<typeof EthereumNetworkInfo>;
export declare const EthereumNetworkInfo: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    label: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
    shortcut: import("@trezor/schema-utils").TString;
    slip44: import("@trezor/schema-utils").TNumber;
    support: import("@trezor/schema-utils").TObject<{
        connect: import("@trezor/schema-utils").TBoolean;
        T1B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3W1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        UNKNOWN: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    }>;
    decimals: import("@trezor/schema-utils").TNumber;
    blockchainLink: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TString;
        url: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
    blockTime: import("@trezor/schema-utils").TNumber;
    minFee: import("@trezor/schema-utils").TNumber;
    maxFee: import("@trezor/schema-utils").TNumber;
    minPriorityFee: import("@trezor/schema-utils").TNumber;
    defaultFees: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        label: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"high">, import("@trezor/schema-utils").TLiteral<"normal">, import("@trezor/schema-utils").TLiteral<"economy">, import("@trezor/schema-utils").TLiteral<"low">, import("@trezor/schema-utils").TLiteral<"custom">]>;
        blocks: import("@trezor/schema-utils").TNumber;
        feePerUnit: import("@trezor/schema-utils").TString;
        feePerTx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        feeLimit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        baseFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxPriorityFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<"ethereum">;
    chainId: import("@trezor/schema-utils").TNumber;
    network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
}>]>;
export type EthereumNetworkInfoDefinitionValues = Static<typeof EthereumNetworkInfoDefinitionValues>;
export declare const EthereumNetworkInfoDefinitionValues: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    label: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
    shortcut: import("@trezor/schema-utils").TString;
    slip44: import("@trezor/schema-utils").TNumber;
    support: import("@trezor/schema-utils").TObject<{
        connect: import("@trezor/schema-utils").TBoolean;
        T1B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3W1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        UNKNOWN: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    }>;
    decimals: import("@trezor/schema-utils").TNumber;
    blockchainLink: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TString;
        url: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<"ethereum">;
    network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    chainId: import("@trezor/schema-utils").TNumber;
}>]>;
export type MiscNetworkInfo = Static<typeof MiscNetworkInfo>;
export declare const MiscNetworkInfo: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    label: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
    shortcut: import("@trezor/schema-utils").TString;
    slip44: import("@trezor/schema-utils").TNumber;
    support: import("@trezor/schema-utils").TObject<{
        connect: import("@trezor/schema-utils").TBoolean;
        T1B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3W1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        UNKNOWN: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    }>;
    decimals: import("@trezor/schema-utils").TNumber;
    blockchainLink: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TString;
        url: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
    blockTime: import("@trezor/schema-utils").TNumber;
    minFee: import("@trezor/schema-utils").TNumber;
    maxFee: import("@trezor/schema-utils").TNumber;
    minPriorityFee: import("@trezor/schema-utils").TNumber;
    defaultFees: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        label: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"high">, import("@trezor/schema-utils").TLiteral<"normal">, import("@trezor/schema-utils").TLiteral<"economy">, import("@trezor/schema-utils").TLiteral<"low">, import("@trezor/schema-utils").TLiteral<"custom">]>;
        blocks: import("@trezor/schema-utils").TNumber;
        feePerUnit: import("@trezor/schema-utils").TString;
        feePerTx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        feeLimit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        baseFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxPriorityFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"misc">, import("@trezor/schema-utils").TLiteral<"nem">]>;
    curve: import("@trezor/schema-utils").TString;
    network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
}>]>;
export type CoinInfo = Static<typeof CoinInfo>;
export declare const CoinInfo: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    label: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
    shortcut: import("@trezor/schema-utils").TString;
    slip44: import("@trezor/schema-utils").TNumber;
    support: import("@trezor/schema-utils").TObject<{
        connect: import("@trezor/schema-utils").TBoolean;
        T1B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3W1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        UNKNOWN: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    }>;
    decimals: import("@trezor/schema-utils").TNumber;
    blockchainLink: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TString;
        url: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
    blockTime: import("@trezor/schema-utils").TNumber;
    minFee: import("@trezor/schema-utils").TNumber;
    maxFee: import("@trezor/schema-utils").TNumber;
    minPriorityFee: import("@trezor/schema-utils").TNumber;
    defaultFees: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        label: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"high">, import("@trezor/schema-utils").TLiteral<"normal">, import("@trezor/schema-utils").TLiteral<"economy">, import("@trezor/schema-utils").TLiteral<"low">, import("@trezor/schema-utils").TLiteral<"custom">]>;
        blocks: import("@trezor/schema-utils").TNumber;
        feePerUnit: import("@trezor/schema-utils").TString;
        feePerTx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        feeLimit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        baseFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxPriorityFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<"bitcoin">;
    cashAddrPrefix: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    curveName: import("@trezor/schema-utils").TString;
    dustLimit: import("@trezor/schema-utils").TNumber;
    forceBip143: import("@trezor/schema-utils").TBoolean;
    hashGenesisBlock: import("@trezor/schema-utils").TString;
    maxAddressLength: import("@trezor/schema-utils").TNumber;
    maxFeeSatoshiKb: import("@trezor/schema-utils").TNumber;
    minAddressLength: import("@trezor/schema-utils").TNumber;
    minFeeSatoshiKb: import("@trezor/schema-utils").TNumber;
    segwit: import("@trezor/schema-utils").TBoolean;
    xPubMagic: import("@trezor/schema-utils").TNumber;
    xPubMagicSegwitNative: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    xPubMagicSegwit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    taproot: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    network: import("@trezor/schema-utils").TObject<{
        messagePrefix: import("@trezor/schema-utils").TString;
        bech32: import("@trezor/schema-utils").TString;
        bip32: import("@trezor/schema-utils").TObject<{
            public: import("@trezor/schema-utils").TNumber;
            private: import("@trezor/schema-utils").TNumber;
        }>;
        pubKeyHash: import("@trezor/schema-utils").TNumber;
        scriptHash: import("@trezor/schema-utils").TNumber;
        wif: import("@trezor/schema-utils").TNumber;
        forkId: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    }>;
    isBitcoin: import("@trezor/schema-utils").TBoolean;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    label: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
    shortcut: import("@trezor/schema-utils").TString;
    slip44: import("@trezor/schema-utils").TNumber;
    support: import("@trezor/schema-utils").TObject<{
        connect: import("@trezor/schema-utils").TBoolean;
        T1B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3W1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        UNKNOWN: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    }>;
    decimals: import("@trezor/schema-utils").TNumber;
    blockchainLink: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TString;
        url: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
    blockTime: import("@trezor/schema-utils").TNumber;
    minFee: import("@trezor/schema-utils").TNumber;
    maxFee: import("@trezor/schema-utils").TNumber;
    minPriorityFee: import("@trezor/schema-utils").TNumber;
    defaultFees: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        label: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"high">, import("@trezor/schema-utils").TLiteral<"normal">, import("@trezor/schema-utils").TLiteral<"economy">, import("@trezor/schema-utils").TLiteral<"low">, import("@trezor/schema-utils").TLiteral<"custom">]>;
        blocks: import("@trezor/schema-utils").TNumber;
        feePerUnit: import("@trezor/schema-utils").TString;
        feePerTx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        feeLimit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        baseFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxPriorityFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TLiteral<"ethereum">;
    chainId: import("@trezor/schema-utils").TNumber;
    network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
}>]>, import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
    label: import("@trezor/schema-utils").TString;
    name: import("@trezor/schema-utils").TString;
    shortcut: import("@trezor/schema-utils").TString;
    slip44: import("@trezor/schema-utils").TNumber;
    support: import("@trezor/schema-utils").TObject<{
        connect: import("@trezor/schema-utils").TBoolean;
        T1B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T2B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3B1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3T1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        T3W1: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
        UNKNOWN: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TLiteral<false>]>;
    }>;
    decimals: import("@trezor/schema-utils").TNumber;
    blockchainLink: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TString;
        url: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
    }>>;
    blockTime: import("@trezor/schema-utils").TNumber;
    minFee: import("@trezor/schema-utils").TNumber;
    maxFee: import("@trezor/schema-utils").TNumber;
    minPriorityFee: import("@trezor/schema-utils").TNumber;
    defaultFees: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        label: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"high">, import("@trezor/schema-utils").TLiteral<"normal">, import("@trezor/schema-utils").TLiteral<"economy">, import("@trezor/schema-utils").TLiteral<"low">, import("@trezor/schema-utils").TLiteral<"custom">]>;
        blocks: import("@trezor/schema-utils").TNumber;
        feePerUnit: import("@trezor/schema-utils").TString;
        feePerTx: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        feeLimit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        baseFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        maxPriorityFeePerGas: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>;
}>, import("@trezor/schema-utils").TObject<{
    type: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<"misc">, import("@trezor/schema-utils").TLiteral<"nem">]>;
    curve: import("@trezor/schema-utils").TString;
    network: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
}>]>]>;
//# sourceMappingURL=coinInfo.d.ts.map