import { Static } from '@trezor/schema-utils';
import { PROTO } from '../../constants';
import type { Params, Response } from '../params';
export type RecoveryDevice = Static<typeof RecoveryDevice>;
export declare const RecoveryDevice: import("@trezor/schema-utils").TObject<{
    language: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    label: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    pin_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    passphrase_protection: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    type: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils/lib/custom-types/keyof-enum").TKeyOfEnum<typeof PROTO.Enum_RecoveryType>>;
    u2f_counter: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
    word_count: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TNumber, import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TLiteral<12>, import("@trezor/schema-utils").TLiteral<18>, import("@trezor/schema-utils").TLiteral<24>]>]>>;
    enforce_wordlist: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
    input_method: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.RecoveryDeviceInputMethod>>;
}>;
export declare function recoveryDevice(params: Params<RecoveryDevice>): Response<PROTO.Success>;
//# sourceMappingURL=recoveryDevice.d.ts.map