import { Static } from '@trezor/schema-utils';
import { PROTO } from '../../constants';
import { BundledParams, Params, Response } from '../params';
export type GetAccountDescriptorParams = Static<typeof GetAccountDescriptorParams>;
export declare const GetAccountDescriptorParams: import("@trezor/schema-utils").TObject<{
    path: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
    coin: import("@trezor/schema-utils").TString;
    derivationType: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TEnum<typeof PROTO.CardanoDerivationType>>;
    suppressBackupWarning: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export interface GetAccountDescriptorResponse {
    descriptor: string;
    path: string;
    legacyXpub?: string;
}
export declare function getAccountDescriptor(params: Params<GetAccountDescriptorParams>): Response<GetAccountDescriptorResponse>;
export declare function getAccountDescriptor(params: BundledParams<GetAccountDescriptorParams>): Response<(GetAccountDescriptorResponse | null)[]>;
//# sourceMappingURL=getAccountDescriptor.d.ts.map