import type { Address as AccountAddress, AccountAddresses, Utxo as AccountUtxo } from '@trezor/blockchain-link';
import type { ComposeInput as ComposeInputBase, ComposeOutput as ComposeOutputBase, ComposeResultError as ComposeResultErrorBase, ComposeResultFinal as ComposeResultFinalBase, ComposeResultNonFinal as ComposeResultNonFinalBase, TransactionInputOutputSortingStrategy } from '@trezor/utxo-lib';
import type { PROTO } from '../../constants';
import type { Params, Response } from '../params';
export type ComposeOutputPayment = Omit<Extract<ComposeOutputBase, {
    type: 'payment';
}>, 'type'> & {
    type?: 'payment';
};
export type ComposeOutput = Exclude<ComposeOutputBase, {
    type: 'payment';
}> | ComposeOutputPayment;
type SortingStrategyPropsWithBackCompatibility = {
    skipPermutation?: boolean;
    sortingStrategy?: undefined;
} | {
    skipPermutation?: undefined;
    sortingStrategy?: TransactionInputOutputSortingStrategy;
};
export type ComposeParams = {
    outputs: ComposeOutput[];
    coin: string;
    identity?: string;
    account?: undefined;
    feeLevels?: undefined;
    push?: boolean;
    sequence?: number;
    baseFee?: number;
    floorBaseFee?: boolean;
} & SortingStrategyPropsWithBackCompatibility;
export type SignedTransaction = {
    signatures: string[];
    serializedTx: string;
    txid?: string;
};
export type ComposeUtxo = AccountUtxo & Partial<ComposeInputBase>;
export type PrecomposeParams = {
    outputs: ComposeOutput[];
    coin: string;
    identity?: string;
    account: {
        path: string;
        addresses: AccountAddresses;
        utxo: ComposeUtxo[];
    };
    feeLevels: {
        feePerUnit: string;
    }[];
    push?: undefined;
    baseFee?: number;
    floorBaseFee?: boolean;
    sequence?: number;
} & SortingStrategyPropsWithBackCompatibility;
export type ComposedInputs = AccountUtxo & ComposeInputBase;
export type ComposeResultError = ComposeResultErrorBase | {
    type: 'error';
    error: 'ADDRESSES-NOT-SET';
};
export type ComposeResultFinal = ComposeResultFinalBase<ComposedInputs, ComposeOutputBase, AccountAddress>;
export type ComposeResultNonFinal = ComposeResultNonFinalBase<ComposedInputs>;
export type ComposeResult = ComposeResultError | ComposeResultNonFinal | ComposeResultFinal;
export type PrecomposeResultError = ComposeResultError;
export type PrecomposeResultNonFinal = Omit<ComposeResultNonFinal, 'inputs'> & {
    inputs: PROTO.TxInputType[];
};
export type PrecomposeResultFinal = Omit<ComposeResultFinal, 'inputs' | 'outputs'> & {
    inputs: PROTO.TxInputType[];
    outputs: PROTO.TxOutputType[];
};
export type PrecomposedResult = PrecomposeResultError | PrecomposeResultNonFinal | PrecomposeResultFinal;
export declare function composeTransaction(params: Params<ComposeParams>): Response<SignedTransaction>;
export declare function composeTransaction(params: Params<PrecomposeParams>): Response<PrecomposedResult[]>;
export {};
//# sourceMappingURL=composeTransaction.d.ts.map