import type { trezorUtils, types } from '@fivebinaries/coin-selection';
import { Static } from '@trezor/schema-utils';
import { PROTO } from '../../exports';
import type { AccountUtxo } from '../../exports';
import { type Params, type Response } from '../params';
import { CardanoCertificate } from './cardano';
import type { CardanoInput, CardanoOutput } from './cardano';
import type { PrecomposeResultError, PrecomposeResultFinal, PrecomposeResultNonFinal } from './composeTransaction';
export type PrecomposedTransactionFinalCardano = Omit<PrecomposeResultFinal, 'inputs' | 'outputs' | 'outputsPermutation'> & {
    deposit?: string;
    ttl?: number;
    inputs: CardanoInput[];
    outputs: CardanoOutput[];
    unsignedTx: {
        body: string;
        hash: string;
    };
};
export type PrecomposedTransactionNonFinalCardano = Omit<PrecomposeResultNonFinal, 'inputs'> & {
    deposit?: string;
};
export type PrecomposedTransactionErrorCardano = PrecomposeResultError | {
    type: 'error';
    error: 'UTXO_BALANCE_INSUFFICIENT' | 'UTXO_VALUE_TOO_SMALL';
};
export type PrecomposedTransactionCardano = PrecomposedTransactionFinalCardano | PrecomposedTransactionNonFinalCardano | PrecomposedTransactionErrorCardano;
export declare const AccountAddress: import("@trezor/schema-utils").TObject<{
    address: import("@trezor/schema-utils").TString;
    path: import("@trezor/schema-utils").TString;
    transfers: import("@trezor/schema-utils").TNumber;
    balance: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    sent: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    received: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
}>;
export type CardanoComposeTransactionParams = {
    account: {
        descriptor: string;
        utxo: AccountUtxo[];
    };
    feeLevels?: {
        feePerUnit?: string;
    }[];
    outputs?: types.UserOutput[];
    certificates?: CardanoCertificate[];
    withdrawals?: types.Withdrawal[];
    changeAddress: {
        address: string;
        path: string;
    };
    addressParameters: Parameters<(typeof trezorUtils)['transformToTrezorOutputs']>[1];
    testnet?: boolean;
};
export type CardanoComposeTransactionParamsSchema = Static<typeof CardanoComposeTransactionParamsSchema>;
export declare const CardanoComposeTransactionParamsSchema: import("@trezor/schema-utils").TObject<{
    account: import("@trezor/schema-utils").TObject<{
        descriptor: import("@trezor/schema-utils").TString;
        utxo: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            txid: import("@trezor/schema-utils").TString;
            vout: import("@trezor/schema-utils").TNumber;
            amount: import("@trezor/schema-utils").TString;
            blockHeight: import("@trezor/schema-utils").TNumber;
            address: import("@trezor/schema-utils").TString;
            path: import("@trezor/schema-utils").TString;
            confirmations: import("@trezor/schema-utils").TNumber;
            coinbase: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
            cardanoSpecific: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                unit: import("@trezor/schema-utils").TString;
            }>>;
        }>>;
    }>;
    feeLevels: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        feePerUnit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
    }>>>;
    outputs: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        isChange: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
        assets: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
            unit: import("@trezor/schema-utils").TString;
            quantity: import("@trezor/schema-utils").TString;
        }>>;
    }>, import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        amount: import("@trezor/schema-utils").TString;
        setMax: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TLiteral<false>>;
    }>, import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        amount: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        setMax: import("@trezor/schema-utils").TBoolean;
    }>]>]>>>;
    certificates: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        type: import("@trezor/schema-utils").TEnum<typeof PROTO.CardanoCertificateType>;
        path: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>>;
        pool: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        poolParameters: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            poolId: import("@trezor/schema-utils").TString;
            vrfKeyHash: import("@trezor/schema-utils").TString;
            pledge: import("@trezor/schema-utils").TString;
            cost: import("@trezor/schema-utils").TString;
            margin: import("@trezor/schema-utils").TObject<{
                numerator: import("@trezor/schema-utils").TString;
                denominator: import("@trezor/schema-utils").TString;
            }>;
            rewardAccount: import("@trezor/schema-utils").TString;
            owners: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                stakingKeyPath: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>>;
                stakingKeyHash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
            relays: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
                type: import("@trezor/schema-utils").TEnum<typeof PROTO.CardanoPoolRelayType>;
                ipv4Address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                ipv6Address: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
                port: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TNumber>;
                hostName: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            }>>;
            metadata: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                url: import("@trezor/schema-utils").TString;
                hash: import("@trezor/schema-utils").TString;
            }>>;
        }>>;
        scriptHash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        keyHash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        deposit: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        dRep: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            type: import("@trezor/schema-utils").TEnum<typeof PROTO.CardanoDRepType>;
            keyHash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
            scriptHash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        }>>;
    }>>>;
    withdrawals: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TObject<{
        stakeAddress: import("@trezor/schema-utils").TString;
        amount: import("@trezor/schema-utils").TString;
    }>>>;
    changeAddress: import("@trezor/schema-utils").TObject<{
        address: import("@trezor/schema-utils").TString;
        path: import("@trezor/schema-utils").TString;
    }>;
    addressParameters: import("@trezor/schema-utils").TObject<{
        addressType: import("@trezor/schema-utils").TEnum<typeof PROTO.CardanoAddressType>;
        path: import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>;
        stakingPath: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUnion<[import("@trezor/schema-utils").TString, import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TNumber>]>>;
        stakingKeyHash: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TString>;
        certificatePointer: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
            blockIndex: import("@trezor/schema-utils").TNumber;
            txIndex: import("@trezor/schema-utils").TNumber;
            certificateIndex: import("@trezor/schema-utils").TNumber;
        }>>;
    }>;
    testnet: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export declare function cardanoComposeTransaction(params: Params<CardanoComposeTransactionParams>): Response<PrecomposedTransactionCardano[]>;
//# sourceMappingURL=cardanoComposeTransaction.d.ts.map