import { Static } from '@trezor/schema-utils';
import type { Params, Response } from '../params';
export type AuthenticateDeviceParams = Static<typeof AuthenticateDeviceParams>;
export declare const AuthenticateDeviceParams: import("@trezor/schema-utils").TObject<{
    config: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
        T2B1: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            rootPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            caPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            debug: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                rootPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                caPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            }>>;
        }>]>;
        T3B1: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            rootPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            caPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            debug: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                rootPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                caPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            }>>;
        }>]>;
        T3T1: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            rootPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            caPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            debug: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                rootPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                caPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            }>>;
        }>]>;
        T3W1: import("@trezor/schema-utils").TIntersect<[import("@trezor/schema-utils").TObject<{
            rootPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            caPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
        }>, import("@trezor/schema-utils").TObject<{
            debug: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TObject<{
                rootPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
                caPubKeys: import("@trezor/schema-utils").TArray<import("@trezor/schema-utils").TString>;
            }>>;
        }>]>;
    }>, import("@trezor/schema-utils").TObject<{
        T1B1: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        T2T1: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
        UNKNOWN: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TUndefined>;
    }>]>, import("@trezor/schema-utils").TObject<{
        version: import("@trezor/schema-utils").TNumber;
        timestamp: import("@trezor/schema-utils").TString;
    }>]>>;
    allowDebugKeys: import("@trezor/schema-utils").TOptional<import("@trezor/schema-utils").TBoolean>;
}>;
export type AuthenticateDeviceResult = {
    valid: true;
    caPubKey: string;
    debugKey?: boolean;
    configExpired?: typeof undefined;
    error?: typeof undefined;
} | {
    valid: false;
    caPubKey: string;
    debugKey?: boolean;
    configExpired?: boolean;
    error: 'ROOT_PUBKEY_NOT_FOUND' | 'CA_PUBKEY_NOT_FOUND' | 'INVALID_DEVICE_MODEL' | 'INVALID_DEVICE_CERTIFICATE' | 'INVALID_DEVICE_SIGNATURE';
};
export declare function authenticateDevice(params: Params<AuthenticateDeviceParams>): Response<AuthenticateDeviceResult>;
//# sourceMappingURL=authenticateDevice.d.ts.map