import { POPUP } from './popup';
import { UI_EVENT } from './ui-request';
import type { Device } from '../types/device';
import type { LocalFirmwares } from '../types/settings';
import type { MessageFactoryFn } from '../types/utils';
export declare const UI_RESPONSE: {
    readonly RECEIVE_PERMISSION: "ui-receive_permission";
    readonly RECEIVE_CONFIRMATION: "ui-receive_confirmation";
    readonly RECEIVE_FIRMWARE: "ui-receive_firmware";
    readonly RECEIVE_PIN: "ui-receive_pin";
    readonly RECEIVE_PASSPHRASE: "ui-receive_passphrase";
    readonly RECEIVE_THP_PAIRING_TAG: "ui-receive_thp_pairing_tag";
    readonly RECEIVE_DEVICE: "ui-receive_device";
    readonly RECEIVE_ACCOUNT: "ui-receive_account";
    readonly RECEIVE_FEE: "ui-receive_fee";
    readonly RECEIVE_WORD: "ui-receive_word";
    readonly INVALID_PASSPHRASE_ACTION: "ui-invalid_passphrase_action";
    readonly CHANGE_SETTINGS: "ui-change_settings";
    readonly LOGIN_CHALLENGE_RESPONSE: "ui-login_challenge_response";
};
export interface UiResponsePopupHandshake {
    type: typeof POPUP.HANDSHAKE;
    payload?: typeof undefined;
}
export interface UiResponsePermission {
    type: typeof UI_RESPONSE.RECEIVE_PERMISSION;
    payload: {
        granted: boolean;
        remember: boolean;
    };
}
export interface UiResponseConfirmation {
    type: typeof UI_RESPONSE.RECEIVE_CONFIRMATION;
    payload: boolean;
}
export interface UiResponseFirmwares {
    type: typeof UI_RESPONSE.RECEIVE_FIRMWARE;
    payload: LocalFirmwares;
}
export interface UiResponseDevice {
    type: typeof UI_RESPONSE.RECEIVE_DEVICE;
    payload: {
        device: Device;
        remember?: boolean;
    };
}
export interface UiResponsePin {
    type: typeof UI_RESPONSE.RECEIVE_PIN;
    payload: string;
}
export interface UiResponseWord {
    type: typeof UI_RESPONSE.RECEIVE_WORD;
    payload: string;
}
export interface UiResponsePassphrase {
    type: typeof UI_RESPONSE.RECEIVE_PASSPHRASE;
    payload: {
        value: string;
        passphraseOnDevice?: boolean;
        save?: boolean;
    };
}
export interface UiResponseThpPairingTag {
    type: typeof UI_RESPONSE.RECEIVE_THP_PAIRING_TAG;
    payload: {
        source: 'code-entry' | 'qr-code' | 'nfc';
        tag: string;
    } | {
        selectedMethod: number;
    };
}
export interface UiResponsePassphraseAction {
    type: typeof UI_RESPONSE.INVALID_PASSPHRASE_ACTION;
    payload: boolean;
}
export interface UiResponseAccount {
    type: typeof UI_RESPONSE.RECEIVE_ACCOUNT;
    payload: number;
}
export interface UiResponseFee {
    type: typeof UI_RESPONSE.RECEIVE_FEE;
    payload: {
        type: 'compose-custom';
        value: string;
    } | {
        type: 'change-account';
    } | {
        type: 'send';
        value: string;
    };
}
export interface UiResponseLoginChallenge {
    type: typeof UI_RESPONSE.LOGIN_CHALLENGE_RESPONSE;
    payload: {
        challengeHidden: string;
        challengeVisual: string;
    };
}
export type UiResponseEvent = UiResponsePopupHandshake | UiResponsePermission | UiResponseConfirmation | UiResponseDevice | UiResponsePin | UiResponseWord | UiResponsePassphrase | UiResponseThpPairingTag | UiResponsePassphraseAction | UiResponseAccount | UiResponseFee | UiResponseLoginChallenge | UiResponseFirmwares;
export type UiResponseMessage = UiResponseEvent & {
    event: typeof UI_EVENT;
};
export declare const createUiResponse: MessageFactoryFn<typeof UI_EVENT, UiResponseEvent>;
//# sourceMappingURL=ui-response.d.ts.map