import type { TransportInfo } from './transport';
import { UI_EVENT } from './ui-request';
import type { ConnectSettings, SystemInfo } from '../types';
import type { MessageFactoryFn } from '../types/utils';
export declare const POPUP: {
    readonly BOOTSTRAP: "popup-bootstrap";
    readonly LOADED: "popup-loaded";
    readonly CORE_LOADED: "popup-core-loaded";
    readonly INIT: "popup-init";
    readonly ERROR: "popup-error";
    readonly EXTENSION_USB_PERMISSIONS: "open-usb-permissions";
    readonly HANDSHAKE: "popup-handshake";
    readonly CLOSED: "popup-closed";
    readonly CANCEL_POPUP_REQUEST: "ui-cancel-popup-request";
    readonly CLOSE_WINDOW: "window.close";
    readonly ANALYTICS_RESPONSE: "popup-analytics-response";
    readonly CONTENT_SCRIPT_LOADED: "popup-content-script-loaded";
    readonly METHOD_INFO: "popup-method-info";
};
export interface PopupInit {
    type: typeof POPUP.INIT;
    payload: {
        settings: ConnectSettings;
        useBroadcastChannel: boolean;
        systemInfo: SystemInfo;
        useCore?: boolean;
    };
}
export interface PopupHandshake {
    type: typeof POPUP.HANDSHAKE;
    payload: {
        settings: ConnectSettings;
        transports?: TransportInfo[];
    };
}
export interface PopupError {
    type: typeof POPUP.ERROR;
    payload: {
        error: string;
    };
}
export interface PopupClosedMessage {
    type: typeof POPUP.CLOSED;
    payload: {
        error: any;
    } | null;
}
export interface PopupAnalyticsResponse {
    type: typeof POPUP.ANALYTICS_RESPONSE;
    payload: {
        enabled: boolean;
    };
}
export interface PopupMethodInfo {
    type: typeof POPUP.METHOD_INFO;
    payload: {
        info: string;
        method: string;
    };
}
export interface PopupContentScriptLoaded {
    type: typeof POPUP.CONTENT_SCRIPT_LOADED;
    payload: {
        id: string;
        contentScriptVersion: number;
    };
}
export interface PopupExtensionUsbPermissions {
    type: typeof POPUP.EXTENSION_USB_PERMISSIONS;
    payload: typeof undefined;
}
export interface PopupBootstrap {
    type: typeof POPUP.BOOTSTRAP;
    payload: typeof undefined;
}
export interface PopupCloseWindow {
    type: typeof POPUP.CLOSE_WINDOW;
    payload: typeof undefined;
}
export type PopupEvent = {
    type: typeof POPUP.LOADED | typeof POPUP.CORE_LOADED | typeof POPUP.CANCEL_POPUP_REQUEST;
    payload?: typeof undefined;
} | PopupInit | PopupHandshake | PopupError | PopupContentScriptLoaded | PopupMethodInfo | PopupExtensionUsbPermissions | PopupBootstrap | PopupCloseWindow | PopupClosedMessage;
export type PopupEventMessage = PopupEvent & {
    event: typeof UI_EVENT;
};
export declare const createPopupMessage: MessageFactoryFn<typeof UI_EVENT, PopupEvent>;
//# sourceMappingURL=popup.d.ts.map