"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getThpChannel = exports.createThpSession = exports.getThpCredentials = exports.abortThpWorkflow = void 0;
const handshake_1 = require("./handshake");
const pairing_1 = require("./pairing");
var thpCall_1 = require("./thpCall");
Object.defineProperty(exports, "abortThpWorkflow", { enumerable: true, get: function () { return thpCall_1.abortThpWorkflow; } });
var pairing_2 = require("./pairing");
Object.defineProperty(exports, "getThpCredentials", { enumerable: true, get: function () { return pairing_2.getThpCredentials; } });
var session_1 = require("./session");
Object.defineProperty(exports, "createThpSession", { enumerable: true, get: function () { return session_1.createThpSession; } });
const getThpChannel = async (device, withInteraction) => {
    const thpState = device.getThpState();
    try {
        if (thpState?.phase === 'handshake') {
            await (0, handshake_1.createThpChannel)(device);
            await (0, handshake_1.thpHandshake)(device);
        }
        if (thpState?.phase === 'pairing' && withInteraction) {
            await (0, pairing_1.thpPairing)(device);
        }
    }
    catch (error) {
        thpState?.resetState();
        throw error;
    }
};
exports.getThpChannel = getThpChannel;
//# sourceMappingURL=index.js.map