"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebextensionStateStorage = void 0;
const connect_common_1 = require("@trezor/connect-common");
class WebextensionStateStorage {
    origin;
    constructor(origin) {
        this.origin = origin;
    }
    loadState(device) {
        if (!device.getState()?.sessionId) {
            const { preferredDevice } = connect_common_1.storage.loadForOrigin(this.origin) || {};
            if (preferredDevice?.internalState &&
                preferredDevice?.internalStateExpiration &&
                preferredDevice.internalStateExpiration > new Date().getTime()) {
                return { sessionId: preferredDevice.internalState };
            }
        }
        return undefined;
    }
    saveState(device, state) {
        const expirationDelay = Math.max(1000 * 60 * 15, device.features.auto_lock_delay_ms ?? 0);
        connect_common_1.storage.saveForOrigin(store => ({
            ...store,
            preferredDevice: store.preferredDevice
                ? {
                    ...store.preferredDevice,
                    state: state.staticSessionId,
                    internalState: state.sessionId,
                    internalStateExpiration: Date.now() + expirationDelay,
                }
                : undefined,
        }), this.origin);
    }
}
exports.WebextensionStateStorage = WebextensionStateStorage;
//# sourceMappingURL=StateStorage.js.map