import { FirmwareRelease } from '@trezor/device-utils';
import { TransportProtocol, thp as protocolThp } from '@trezor/protocol';
import { Session } from '@trezor/transport';
import { type Descriptor, type Transport } from '@trezor/transport';
import { TypedEmitter } from '@trezor/utils';
import { PROTO } from '../constants';
import { TypedCallProvider } from './DeviceCurrentSession';
import { IStateStorage } from './StateStorage';
import { DEVICE, DeviceButtonRequestPayload, DeviceThpCredentialsChangedPayload, DeviceThpPairingPayload, DeviceVersionChanged, UiResponsePassphrase, UiResponsePin, UiResponseThpPairingTag, UiResponseWord } from '../events';
import { DeviceFirmwareStatus, DeviceState, Device as DeviceTyped, DeviceUniquePath, FirmwareHashCheckResult, FirmwareReleaseConfigInfo, FirmwareType, UnavailableCapabilities, VersionArray } from '../types';
type RunOptions = {
    skipFinalReload?: boolean;
    keepSession?: boolean;
    useCardanoDerivation?: boolean;
    skipFirmwareChecks?: boolean;
    skipLanguageChecks?: boolean;
};
type Result<T> = {
    success: true;
    payload: T;
} | {
    success: false;
    error: Error;
};
export interface DeviceEvents {
    [DEVICE.PIN]: {
        type: PROTO.PinMatrixRequestType | undefined;
        callback: (response: Result<UiResponsePin['payload']>) => void;
    };
    [DEVICE.WORD]: {
        type: PROTO.WordRequestType;
        callback: (response: Result<UiResponseWord['payload']>) => void;
    };
    [DEVICE.PASSPHRASE]: {
        callback: (response: Result<UiResponsePassphrase['payload']>) => void;
    };
    [DEVICE.PASSPHRASE_ON_DEVICE]: void;
    [DEVICE.BUTTON]: {
        device: Device;
        payload: DeviceButtonRequestPayload;
    };
    [DEVICE.FIRMWARE_VERSION_CHANGED]: DeviceVersionChanged['payload'];
    [DEVICE.THP_PAIRING]: {
        payload: DeviceThpPairingPayload;
        callback: (response: Result<UiResponseThpPairingTag['payload']>) => void;
    };
    [DEVICE.THP_CREDENTIALS_CHANGED]: DeviceThpCredentialsChangedPayload;
}
interface DeviceLifecycleEvents {
    [DEVICE.CONNECT]: void;
    [DEVICE.CONNECT_UNACQUIRED]: void;
    [DEVICE.CHANGED]: void;
    [DEVICE.DISCONNECT]: void;
}
type DeviceParams = {
    id: DeviceUniquePath;
    transport: Transport;
    descriptor: Descriptor;
};
export declare class Device extends TypedEmitter<DeviceEvents> {
    readonly transport: Transport;
    readonly transportPath: import("@trezor/transport/lib/types").PathPublic;
    readonly bluetoothProps: {
        id: string;
    } | undefined;
    private thp;
    private readonly possibleHIDdevice;
    private sessionAcquired;
    private _protocol;
    get protocol(): TransportProtocol;
    getThpState(): protocolThp.ThpState | undefined;
    private unreadableError?;
    private _firmwareStatus;
    get firmwareStatus(): DeviceFirmwareStatus;
    private _currentRelease?;
    get currentRelease(): FirmwareRelease | undefined;
    private _firmwareReleaseConfigInfo?;
    get firmwareReleaseConfigInfo(): FirmwareReleaseConfigInfo | undefined;
    private _features;
    get features(): {
        busy?: boolean | undefined;
        _passphrase_cached?: boolean | undefined;
        homescreen_format?: "Toif" | "Jpeg" | "ToiG" | undefined;
        hide_passphrase_from_host?: boolean | undefined;
        unit_color?: number | undefined;
        unit_btconly?: boolean | undefined;
        homescreen_width?: number | undefined;
        homescreen_height?: number | undefined;
        bootloader_locked?: boolean | undefined;
        language_version_matches?: boolean | undefined;
        unit_packaging?: number | undefined;
        haptic_feedback?: boolean | undefined;
        recovery_type?: "NormalRecovery" | "DryRun" | "UnlockRepeatedBackup" | undefined;
        optiga_sec?: number | undefined;
        soc?: number | undefined;
        vendor: string;
        major_version: number;
        minor_version: number;
        patch_version: number;
        bootloader_mode: boolean | null;
        device_id: string | null;
        pin_protection: boolean | null;
        passphrase_protection: boolean | null;
        language: string | null;
        label: string | null;
        initialized: boolean | null;
        revision: string | null;
        bootloader_hash: string | null;
        imported: boolean | null;
        unlocked: boolean | null;
        firmware_present: boolean | null;
        backup_availability: "NotAvailable" | "Required" | "Available" | null;
        flags: number | null;
        model: string;
        fw_major: number | null;
        fw_minor: number | null;
        fw_patch: number | null;
        fw_vendor: string | null;
        unfinished_backup: boolean | null;
        no_backup: boolean | null;
        recovery_status: "Nothing" | "Recovery" | "Backup" | null;
        capabilities: ("Capability_Bitcoin" | "Capability_Bitcoin_like" | "Capability_Binance" | "Capability_Cardano" | "Capability_Crypto" | "Capability_EOS" | "Capability_Ethereum" | "Capability_Lisk" | "Capability_Monero" | "Capability_NEM" | "Capability_Ripple" | "Capability_Stellar" | "Capability_Tezos" | "Capability_U2F" | "Capability_Shamir" | "Capability_ShamirGroups" | "Capability_PassphraseEntry" | "Capability_Solana" | "Capability_Translations" | "Capability_Brightness" | "Capability_Haptic" | "Capability_BLE" | "Capability_NFC")[];
        backup_type: "Bip39" | "Slip39_Basic" | "Slip39_Advanced" | "Slip39_Single_Extendable" | "Slip39_Basic_Extendable" | "Slip39_Advanced_Extendable" | null;
        sd_card_present: boolean | null;
        sd_protection: boolean | null;
        wipe_code_protection: boolean | null;
        session_id: string | null;
        passphrase_always_on_device: boolean | null;
        safety_checks: "Strict" | "PromptAlways" | "PromptTemporarily" | null;
        auto_lock_delay_ms: number | null;
        display_rotation: "North" | "East" | "South" | "West" | null;
        experimental_features: boolean | null;
        internal_model: PROTO.DeviceModelInternal;
    };
    private wasUsedElsewhere;
    private acquirePromise?;
    private releasePromise?;
    private runAbort?;
    private runPromise?;
    private keepTransportSession;
    private currentSession?;
    private instance;
    private state;
    private stateStorage?;
    private busy?;
    private _unavailableCapabilities;
    get unavailableCapabilities(): Readonly<UnavailableCapabilities>;
    private _firmwareType?;
    get firmwareType(): FirmwareType | undefined;
    private name;
    private color?;
    private availableTranslations;
    private authenticityChecks;
    private readonly uniquePath;
    readonly lifecycle: TypedEmitter<DeviceLifecycleEvents>;
    private sessionDfd?;
    constructor({ id, transport, descriptor }: DeviceParams);
    private readonly onTransportStopped;
    private readonly onTransportDeviceEvent;
    private getSessionChangePromise;
    private waitAndCompareSession;
    acquire(): import("@trezor/transport/lib/types").AsyncResultWithTypedError<Session, "Network request failed" | "Wrong result type." | "device disconnected during action" | "unexpected error" | "Aborted by timeout" | "Aborted by signal" | "This transport can not be used in this environment" | "device not found" | "Unable to open device" | "wrong previous session" | "LIBUSB_ERROR_ACCESS">;
    release(): import("@trezor/transport/lib/types").AsyncResultWithTypedError<null, "Network request failed" | "Wrong result type." | "device disconnected during action" | "unexpected error" | "session not found" | "Aborted by timeout" | "Aborted by signal" | "This transport can not be used in this environment" | "device not found" | "Unable to open device" | "wrong previous session"> | undefined;
    setupThp(): Promise<void>;
    handshake(): Promise<boolean>;
    private updateDescriptor;
    run(fn?: () => Promise<void>, options?: RunOptions): Promise<void>;
    interrupt(reason: Error): Promise<void>;
    get currentRun(): Promise<void> | undefined;
    private usedElsewhere;
    private _runInner;
    getCurrentSession(): TypedCallProvider;
    getCommands(): {
        unlockPath: (params?: PROTO.UnlockPath) => Promise<{
            type: "UnlockedPathRequest";
            message: {
                mac: string;
            };
        }>;
        getPublicKey: (params: PROTO.GetPublicKey, unlock?: PROTO.UnlockPath) => Promise<{
            descriptor?: string | undefined;
            root_fingerprint?: number | undefined;
            node: {
                private_key?: string | undefined;
                depth: number;
                fingerprint: number;
                child_num: number;
                chain_code: string;
                public_key: string;
            };
            xpub: string;
        }>;
        getAddress: ({ address_n, show_display, multisig, script_type, chunkify }: PROTO.GetAddress, coinInfo: import("../types").BitcoinNetworkInfo) => Promise<{
            mac?: string | undefined;
            address: string;
        }>;
        ethereumGetPublicKey: ({ address_n, show_display, }: PROTO.EthereumGetPublicKey) => Promise<{
            node: {
                private_key?: string | undefined;
                depth: number;
                fingerprint: number;
                child_num: number;
                chain_code: string;
                public_key: string;
            };
            xpub: string;
        }>;
        ethereumGetAddress: (params: PROTO.EthereumGetAddress) => Promise<{
            mac?: string | undefined;
            _old_address?: string | undefined;
            address: string;
        }>;
        getHDNode: (params: PROTO.GetPublicKey, options: {
            coinInfo: import("../types").BitcoinNetworkInfo;
            validation?: boolean;
            unlockPath?: PROTO.UnlockPath;
        }) => Promise<{
            path: number[];
            publicKey: string;
            serializedPath: string;
        } & {
            descriptor?: string | undefined;
            xpubSegwit?: string | undefined;
            descriptorChecksum?: string | undefined;
            depth: number;
            fingerprint: number;
            chainCode: string;
            childNum: number;
            xpub: string;
        }>;
        preauthorize: (throwError: boolean) => Promise<boolean>;
        getAccountDescriptor: (coinInfo: import("../types").CoinInfo, address_n: number[], derivationType?: PROTO.CardanoDerivationType) => Promise<import("./DeviceCommands").AccountDescriptor>;
        typedCall: PROTO.TypedCall;
    };
    setInstance(instance?: number): void;
    getInstance(): number;
    getState(): DeviceState | undefined;
    setState(state?: Partial<DeviceState>): void;
    initialize(useCardanoDerivation: boolean): Promise<void>;
    initStorage(storage: IStateStorage): void;
    getFeatures(): Promise<void>;
    getAuthenticityChecks(): {
        firmwareRevision: import("../types").FirmwareRevisionCheckResult | null;
        firmwareHash: FirmwareHashCheckResult | null;
    };
    setAuthenticityChecks(firmwareHash: FirmwareHashCheckResult | null): void;
    private checkFirmwareRevisionWithRetries;
    private checkFirmwareRevision;
    changeLanguage({ language, binary, }: {
        language?: undefined;
        binary: ArrayBuffer;
    } | {
        language: string;
        binary?: undefined;
    }): Promise<{
        message: string;
    }>;
    private _uploadTranslationData;
    private _updateCurrentRelease;
    private _updateFeatures;
    prompt<T extends typeof DEVICE.PIN | typeof DEVICE.PASSPHRASE | typeof DEVICE.WORD | typeof DEVICE.THP_PAIRING>(type: T, args: Omit<DeviceEvents[T], 'callback'>): Promise<Parameters<DeviceEvents[T]["callback"]>[0]>;
    isUnacquired(): boolean;
    isUnreadable(): boolean;
    private disconnect;
    isBootloader(): boolean;
    isInitialized(): boolean;
    isSeedless(): boolean;
    getVersion(): VersionArray | undefined;
    atLeast(versions: string[] | string): boolean;
    isUsed(): boolean;
    isUsedHere(): boolean;
    isUsedElsewhere(): boolean;
    getUniquePath(): DeviceUniquePath;
    isT1(): boolean;
    hasUnexpectedMode(allow: string[], require: string[]): "ui-device_bootloader_mode" | "ui-device_not_in_bootloader_mode" | "ui-device_not_initialized" | "ui-device_seedless" | null;
    private getStatus;
    toMessageObject(): DeviceTyped;
}
export {};
//# sourceMappingURL=Device.d.ts.map