import { ConditionalRelease, DeviceModelInternal, FirmwareRelease, FirmwareReleaseConfig, IntermediaryReleaseConfig, VersionArray } from '@trezor/device-utils';
import { Features, FirmwareReleaseConfigInfo, FirmwareType } from '../types';
export type FirmwareUpdateSource = 'production' | 'test-unsigned' | 'test-signed' | 'localhost-unsigned' | 'localhost-signed';
export declare const getOnlineFirmwareBaseUrl: () => {
    env: FirmwareUpdateSource;
    BASE_URL: string;
    MIDDLE_PATH: string;
};
export declare const getBundledRelease: (deviceModel: DeviceModelInternal, firmwareType: FirmwareType) => FirmwareRelease | undefined;
export declare const getOnlineReleaseByVersion: (deviceModel: DeviceModelInternal, firmwareVersion: VersionArray, firmwareType: FirmwareType) => Promise<FirmwareRelease | undefined>;
export declare const getReleaseConfig: (features: Features, firmwareType: FirmwareType) => ConditionalRelease | undefined;
export declare const getReleaseByVersion: (features: Features, firmwareVersion: VersionArray, firmwareType: FirmwareType) => Promise<FirmwareRelease | undefined>;
export declare const createLocalFirmwareConfig: (baseConfig: FirmwareReleaseConfig) => any;
export declare const createRemoteFirmwareConfig: (config: FirmwareReleaseConfig) => Promise<any>;
export declare const initializeFirmwareConfig: (config: FirmwareReleaseConfig, isRemote: boolean) => Promise<{
    releases: any;
    intermediaries: Record<DeviceModelInternal, IntermediaryReleaseConfig[]>;
}>;
export declare const getLanguage: (languageBinPath: string) => Promise<ArrayBuffer | Buffer<ArrayBufferLike>>;
export type CurrentVersion = {
    bootloaderVersion: VersionArray | null;
    firmwareVersion: VersionArray | null;
};
interface GetReleaseInfoParams {
    features: Features;
    release: FirmwareRelease;
    conditions: ConditionalRelease['conditions'];
    intermediary: IntermediaryReleaseConfig | undefined;
    firmwareType: FirmwareType;
    isBitcoinOnlyAvailable: boolean;
}
export declare const getReleaseInfo: ({ features, release, conditions, intermediary, firmwareType, isBitcoinOnlyAvailable, }: GetReleaseInfoParams) => FirmwareReleaseConfigInfo;
export declare const getFirmwareReleaseConfigInfo: (features: Features, firmwareType: FirmwareType) => FirmwareReleaseConfigInfo | undefined;
export declare const getFirmwareStatus: (features: Features, firmwareType: FirmwareType) => "valid" | "outdated" | "required" | "unknown" | "custom" | "none";
type GetFirmwareLocationParam = {
    firmwareVersion: VersionArray;
    remotePath: string;
    deviceModel: DeviceModelInternal;
    firmwareType: FirmwareType;
    intermediaryVersion?: number;
};
export declare const getFirmwareLocation: ({ firmwareVersion, remotePath, deviceModel, firmwareType, intermediaryVersion, }: GetFirmwareLocationParam) => {
    baseUrl: string;
    path: string;
};
export {};
//# sourceMappingURL=firmwareInfo.d.ts.map