"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getOrInitBitcoinFeeLevels = exports.getOrInitFeeLevels = void 0;
const type_utils_1 = require("@trezor/type-utils");
const BitcoinFeeLevels_1 = require("./BitcoinFeeLevels");
const EthereumFeeLevels_1 = require("./EthereumFeeLevels");
const MiscFeeLevels_1 = require("./MiscFeeLevels");
const instancesPerCoin = {};
const feeLevelsPerTypeFactory = (coinInfo) => {
    const { type } = coinInfo;
    switch (type) {
        case 'bitcoin':
            return new BitcoinFeeLevels_1.BitcoinFeeLevels(coinInfo);
        case 'ethereum':
            return new EthereumFeeLevels_1.EthereumFeeLevels(coinInfo);
        case 'misc':
        case 'nem':
            return new MiscFeeLevels_1.MiscFeeLevels(coinInfo);
        default:
            return (0, type_utils_1.exhaustive)(type);
    }
};
const getOrInitFeeLevels = (coinInfo) => {
    const { shortcut } = coinInfo;
    if (!Object.prototype.hasOwnProperty.call(instancesPerCoin, shortcut)) {
        instancesPerCoin[shortcut] = feeLevelsPerTypeFactory(coinInfo);
    }
    return instancesPerCoin[shortcut];
};
exports.getOrInitFeeLevels = getOrInitFeeLevels;
const getOrInitBitcoinFeeLevels = (coinInfo) => (0, exports.getOrInitFeeLevels)(coinInfo);
exports.getOrInitBitcoinFeeLevels = getOrInitBitcoinFeeLevels;
//# sourceMappingURL=index.js.map