"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.dispose = exports.reconnectAllBackends = exports.initBlockchain = exports.isBackendSupported = exports.setCustomBackend = exports.findBackend = exports.Blockchain = void 0;
const BackendManager_1 = require("./BackendManager");
var Blockchain_1 = require("./Blockchain");
Object.defineProperty(exports, "Blockchain", { enumerable: true, get: function () { return Blockchain_1.Blockchain; } });
const backends = new BackendManager_1.BackendManager();
const findBackend = (coin, identity) => backends.get(coin, identity);
exports.findBackend = findBackend;
const setCustomBackend = (coinInfo, blockchainLink) => backends.setCustom(coinInfo.shortcut, blockchainLink?.url.length ? blockchainLink : coinInfo.blockchainLink);
exports.setCustomBackend = setCustomBackend;
const isBackendSupported = (coinInfo) => backends.isSupported(coinInfo);
exports.isBackendSupported = isBackendSupported;
const initBlockchain = (coinInfo, postMessage, identity) => backends.getOrConnect({ coinInfo, identity, postMessage });
exports.initBlockchain = initBlockchain;
const reconnectAllBackends = (coinInfo) => backends.reconnectAll(coinInfo);
exports.reconnectAllBackends = reconnectAllBackends;
const dispose = () => backends.dispose();
exports.dispose = dispose;
//# sourceMappingURL=BlockchainLink.js.map