import BlockchainLink, { BlockchainLinkParams, ServerInfo, SubscriptionAccountInfo } from '@trezor/blockchain-link';
import { CoreEventMessage } from '../events';
import type { CoinInfo, Proxy } from '../types';
import { PushTransaction } from '../types/api/pushTransaction';
export type BlockchainOptions = {
    coinInfo: CoinInfo;
    postMessage: (message: CoreEventMessage) => void;
    proxy?: Proxy;
    debug?: boolean;
    identity?: string;
    onDisconnected?: (pendingSubscriptions?: boolean) => void;
};
export declare class Blockchain {
    readonly link: BlockchainLink;
    serverInfo?: ServerInfo;
    readonly identity?: string;
    readonly coinInfo: BlockchainOptions['coinInfo'];
    readonly postMessage: BlockchainOptions['postMessage'];
    private onDisconnected;
    private initPromise?;
    constructor(options: BlockchainOptions);
    private onBackendDisconnected;
    private initLink;
    init(): Promise<ServerInfo>;
    getTransactions(txs: string[]): Promise<import("@trezor/blockchain-link").Transaction[]>;
    getTransactionHexes(txids: string[]): Promise<string[]>;
    getCurrentFiatRates(params: {
        currencies?: string[];
        token?: string;
    }): Promise<{
        ts: number;
        rates: import("@trezor/blockchain-link").FiatRatesBySymbol;
    }>;
    getFiatRatesForTimestamps(params: {
        currencies?: string[];
        timestamps: number[];
        token?: string;
    }): Promise<{
        tickers: {
            ts: number;
            rates: import("@trezor/blockchain-link").FiatRatesBySymbol;
        }[];
    }>;
    getAccountBalanceHistory(params: BlockchainLinkParams<'getAccountBalanceHistory'>): Promise<import("@trezor/blockchain-link").AccountBalanceHistory[]>;
    getNetworkInfo(): Promise<ServerInfo>;
    getAccountInfo(request: BlockchainLinkParams<'getAccountInfo'>): Promise<import("@trezor/blockchain-link").AccountInfo>;
    getAccountUtxo(descriptor: string): Promise<import("@trezor/blockchain-link").Utxo[]>;
    rpcCall(params: BlockchainLinkParams<'rpcCall'>): Promise<{
        data: string;
    }>;
    estimateFee(request: Parameters<typeof this.link.estimateFee>[0]): Promise<{
        feePerUnit: string;
        feePerTx?: string;
        feePayer?: string;
        feeLimit?: string;
        eip1559?: import("@trezor/blockchain-link-types/lib/blockbook-api").Eip1559Fees;
    }[]>;
    subscribeBlocks(): Promise<{
        subscribed: boolean;
    }>;
    subscribeAccounts(accounts: SubscriptionAccountInfo[]): Promise<{
        subscribed: boolean;
    }>;
    subscribeFiatRates(_currency?: string): Promise<{
        subscribed: boolean;
    }>;
    unsubscribeBlocks(): Promise<{
        subscribed: boolean;
    }>;
    unsubscribeAccounts(accounts: SubscriptionAccountInfo[]): Promise<{
        subscribed: boolean;
    }>;
    unsubscribeFiatRates(): Promise<{
        subscribed: boolean;
    }>;
    unsubscribeAll(): Promise<{
        subscribed: boolean;
    }>;
    pushTransaction(tx: PushTransaction['tx']): Promise<string>;
    disconnect(): void;
}
//# sourceMappingURL=Blockchain.d.ts.map