"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const AbstractMethod_1 = require("../core/AbstractMethod");
const events_1 = require("../events");
const paramsValidator_1 = require("./common/paramsValidator");
class WipeDevice extends AbstractMethod_1.AbstractMethod {
    init() {
        this.allowDeviceMode = [events_1.UI.INITIALIZE, events_1.UI.SEEDLESS, events_1.UI.BOOTLOADER];
        this.useDeviceState = false;
        this.requiredPermissions = ['management'];
        this.skipFinalReload = this.payload.skipFinalReload ?? false;
        this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, null, this.firmwareRange);
    }
    get confirmation() {
        return {
            view: 'device-management',
            customConfirmButton: {
                className: 'wipe',
                label: `Wipe`,
            },
            label: 'Are you sure you want to wipe your device?',
        };
    }
    get info() {
        return 'Wipe device';
    }
    async run() {
        const cmd = this.device.getCommands();
        if (this.device.isBootloader()) {
            this.device.emit(events_1.DEVICE.BUTTON, {
                device: this.device,
                payload: { code: 'ButtonRequest_WipeDevice' },
            });
        }
        const response = await cmd.typedCall('WipeDevice', 'Success');
        const thpState = this.device.getThpState();
        if (thpState) {
            thpState.resetState();
        }
        return response.message;
    }
}
exports.default = WipeDevice;
//# sourceMappingURL=wipeDevice.js.map