import { AbstractMethod } from '../../../core/AbstractMethod';
import { CoinInfo } from '../../../types';
import { SolanaComposeTransaction as SolanaComposeTransactionSchema } from '../../../types/api/solana';
type SolanaComposeTransactionParams = SolanaComposeTransactionSchema & {
    coinInfo: CoinInfo;
};
export default class SolanaComposeTransaction extends AbstractMethod<'solanaComposeTransaction', SolanaComposeTransactionParams> {
    init(): void;
    get info(): string;
    run(): Promise<{
        serializedTx: string;
        additionalInfo: {
            newAccountProgramName: "spl-token" | "spl-token-2022" | undefined;
            tokenAccountInfo: {
                baseAddress: string;
                tokenProgram: string;
                tokenMint: string;
                tokenAccount: string;
            } | undefined;
        };
    }>;
}
export {};
//# sourceMappingURL=solanaComposeTransaction.d.ts.map