import type { PROTO } from '../constants';
import { AbstractMethod } from '../core/AbstractMethod';
import type { BitcoinNetworkInfo } from '../types';
export default class SignMessage extends AbstractMethod<'signMessage', PROTO.SignMessage> {
    coinInfo: BitcoinNetworkInfo | undefined;
    init(): void;
    get info(): string;
    getButtonRequestData(code: string, name?: string): {
        type: "message";
        serializedPath: string;
        coin: string;
        message: string;
    } | undefined;
    run(): Promise<{
        address: string;
        signature: string;
    }>;
}
//# sourceMappingURL=signMessage.d.ts.map