"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const constants_1 = require("../constants");
const AbstractMethod_1 = require("../core/AbstractMethod");
class SetBrightness extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['management'];
        this.skipFinalReload = false;
        this.useDeviceState = false;
        const { payload } = this;
        (0, schema_utils_1.Assert)(constants_1.PROTO.SetBrightness, payload);
        this.params = {
            value: payload.value,
        };
    }
    async run() {
        const cmd = this.device.getCommands();
        const response = await cmd.typedCall('SetBrightness', 'Success', this.params);
        return response.message;
    }
}
exports.default = SetBrightness;
//# sourceMappingURL=setBrightness.js.map