"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const BlockchainLink_1 = require("../backend/BlockchainLink");
const constants_1 = require("../constants");
const AbstractMethod_1 = require("../core/AbstractMethod");
const coinInfo_1 = require("../data/coinInfo");
const pushTransaction_1 = require("../types/api/pushTransaction");
class PushTransaction extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['push_tx'];
        this.useUi = false;
        this.useDevice = false;
        const { payload } = this;
        (0, schema_utils_1.Assert)(pushTransaction_1.PushTransaction, payload);
        const coinInfo = (0, coinInfo_1.getCoinInfo)(payload.coin);
        if (!coinInfo) {
            throw constants_1.ERRORS.TypedError('Method_UnknownCoin');
        }
        (0, BlockchainLink_1.isBackendSupported)(coinInfo);
        if (coinInfo.type === 'bitcoin' &&
            (typeof payload.tx !== 'string' || !/^[0-9A-Fa-f]*$/.test(payload.tx))) {
            throw constants_1.ERRORS.TypedError('Method_InvalidParameter', 'Transaction must be hexadecimal');
        }
        this.params = {
            tx: payload.tx,
            coinInfo,
            identity: payload.identity,
        };
    }
    async run() {
        const backend = await (0, BlockchainLink_1.initBlockchain)(this.params.coinInfo, this.postMessage, this.params.identity);
        const txid = await backend.pushTransaction(this.params.tx);
        return {
            txid,
        };
    }
}
exports.default = PushTransaction;
//# sourceMappingURL=pushTransaction.js.map