import { PROTO } from '../../../constants';
import { AbstractMethod } from '../../../core/AbstractMethod';
type Params = PROTO.NEMGetAddress & {
    address?: string;
};
export default class NEMGetAddress extends AbstractMethod<'nemGetAddress', Params[]> {
    hasBundle?: boolean;
    progress: number;
    init(): void;
    get info(): string;
    getButtonRequestData(code: string): {
        type: "address";
        serializedPath: string;
        address: string;
    } | undefined;
    get confirmation(): {
        view: "export-address";
        label: string;
    };
    _call({ address_n, network, show_display, chunkify }: Params): Promise<{
        address: string;
    }>;
    run(): Promise<import("../../../types").Address | import("../../../types").Address[]>;
}
export {};
//# sourceMappingURL=nemGetAddress.d.ts.map