"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseFirmwareHeaders = void 0;
const parseFirmwareHeaders = (buff) => {
    const vendorHeader = buff.subarray(0, 4).toString('utf8');
    let trezorImageHeader = '';
    let restbuff;
    if (vendorHeader === 'TRZV') {
        const vendorHeaderLength = buff.readUInt32LE(4);
        trezorImageHeader = buff
            .subarray(vendorHeaderLength, vendorHeaderLength + 4)
            .toString('utf8');
        restbuff = buff.subarray(vendorHeaderLength + 4);
    }
    else if (vendorHeader === 'TRZR') {
        restbuff = buff.subarray(256 + 4);
        trezorImageHeader = buff.subarray(256, 256 + 4).toString('utf8');
    }
    else {
        restbuff = buff.subarray(4);
        trezorImageHeader = buff.subarray(0, 4).toString('utf8');
    }
    if (trezorImageHeader !== 'TRZF') {
        throw new Error(`unexpected header ${vendorHeader}`);
    }
    const version_major = restbuff.readInt8(12);
    const version_minor = restbuff.readInt8(13);
    const version_patch = restbuff.readInt8(14);
    const version = [version_major, version_minor, version_patch];
    return {
        version,
    };
};
exports.parseFirmwareHeaders = parseFirmwareHeaders;
//# sourceMappingURL=parseFirmwareHeaders.js.map