"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const AbstractMethod_1 = require("../../../core/AbstractMethod");
const types_1 = require("../../../types");
const formatUtils_1 = require("../../../utils/formatUtils");
const paramsValidator_1 = require("../../common/paramsValidator");
class EthereumVerifyMessage extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['read', 'write'];
        this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, null, this.firmwareRange);
        this.requiredDeviceCapabilities = ['Capability_Ethereum'];
        const { payload } = this;
        (0, schema_utils_1.Assert)(types_1.EthereumVerifyMessage, payload);
        const messageHex = payload.hex
            ? (0, formatUtils_1.messageToHex)(payload.message)
            : Buffer.from(payload.message, 'utf8').toString('hex');
        this.params = {
            address: (0, formatUtils_1.stripHexPrefix)(payload.address),
            signature: (0, formatUtils_1.stripHexPrefix)(payload.signature),
            message: messageHex,
        };
    }
    get info() {
        return 'Verify message';
    }
    async run() {
        const cmd = this.device.getCommands();
        const response = await cmd.typedCall('EthereumVerifyMessage', 'Success', this.params);
        return response.message;
    }
}
exports.default = EthereumVerifyMessage;
//# sourceMappingURL=ethereumVerifyMessage.js.map