"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const constants_1 = require("../constants");
const AbstractMethod_1 = require("../core/AbstractMethod");
class ChangePin extends AbstractMethod_1.AbstractMethod {
    init() {
        this.requiredPermissions = ['management'];
        this.useDeviceState = false;
        this.skipFinalReload = false;
        const { payload } = this;
        (0, schema_utils_1.Assert)(constants_1.PROTO.ChangePin, payload);
        this.params = {
            remove: payload.remove,
        };
    }
    async run() {
        const cmd = this.device.getCommands();
        const response = await cmd.typedCall('ChangePin', 'Success', this.params);
        return response.message;
    }
}
exports.default = ChangePin;
//# sourceMappingURL=changePin.js.map