"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const AbstractMethod_1 = require("../core/AbstractMethod");
const events_1 = require("../events");
const changeLanguage_1 = require("../types/api/changeLanguage");
class ChangeLanguage extends AbstractMethod_1.AbstractMethod {
    init() {
        this.allowDeviceMode = [events_1.UI.INITIALIZE, events_1.UI.SEEDLESS];
        this.useEmptyPassphrase = true;
        this.requiredPermissions = ['management'];
        this.skipFinalReload = false;
        this.useDeviceState = false;
        const { payload } = this;
        (0, schema_utils_1.Assert)(changeLanguage_1.ChangeLanguage, payload);
        this.params = payload;
    }
    get confirmation() {
        return {
            view: 'device-management',
            customConfirmButton: {
                className: 'confirm',
                label: 'Proceed',
            },
            label: 'Do you want to change language?',
        };
    }
    run() {
        const { language, binary } = this.params;
        if (binary) {
            return this.device.changeLanguage({ binary });
        }
        else {
            return this.device.changeLanguage({ language });
        }
    }
}
exports.default = ChangeLanguage;
//# sourceMappingURL=changeLanguage.js.map