"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gatherWitnessPaths = void 0;
const constants_1 = require("../../constants");
const gatherWitnessPaths = (inputsWithPath, certificatesWithPoolOwnersAndRelays, withdrawals, collateralInputsWithPath, requiredSigners, additionalWitnessRequests, signingMode) => {
    const witnessPaths = new Map();
    function _insert(path) {
        const pathKey = JSON.stringify(path);
        witnessPaths.set(pathKey, path);
    }
    if (signingMode !== constants_1.PROTO.CardanoTxSigningMode.MULTISIG_TRANSACTION) {
        inputsWithPath.forEach(({ path }) => {
            if (path)
                _insert(path);
        });
        certificatesWithPoolOwnersAndRelays.forEach(({ certificate, poolOwners }) => {
            if (certificate.path &&
                (certificate.type === constants_1.PROTO.CardanoCertificateType.STAKE_DELEGATION ||
                    certificate.type === constants_1.PROTO.CardanoCertificateType.STAKE_DEREGISTRATION ||
                    certificate.type === constants_1.PROTO.CardanoCertificateType.STAKE_REGISTRATION_CONWAY ||
                    certificate.type === constants_1.PROTO.CardanoCertificateType.STAKE_DEREGISTRATION_CONWAY ||
                    certificate.type === constants_1.PROTO.CardanoCertificateType.VOTE_DELEGATION)) {
                _insert(certificate.path);
            }
            poolOwners.forEach(poolOwner => {
                if (poolOwner.staking_key_path)
                    _insert(poolOwner.staking_key_path);
            });
        });
        withdrawals.forEach(({ path }) => {
            if (path)
                _insert(path);
        });
    }
    if (signingMode === constants_1.PROTO.CardanoTxSigningMode.PLUTUS_TRANSACTION) {
        collateralInputsWithPath.forEach(({ path }) => {
            if (path)
                _insert(path);
        });
    }
    requiredSigners.forEach(({ key_path }) => {
        if (key_path)
            _insert(key_path);
    });
    additionalWitnessRequests.forEach(path => {
        _insert(path);
    });
    return Array.from(witnessPaths.values());
};
exports.gatherWitnessPaths = gatherWitnessPaths;
//# sourceMappingURL=cardanoWitnesses.js.map