"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.transformReferenceInput = exports.transformCollateralInput = exports.transformInput = exports.InputWithPathParam = exports.InputWithPath = exports.Path = void 0;
const schema_utils_1 = require("@trezor/schema-utils");
const constants_1 = require("../../constants");
const exports_1 = require("../../exports");
const pathUtils_1 = require("../../utils/pathUtils");
exports.Path = schema_utils_1.Type.Array(schema_utils_1.Type.Number());
exports.InputWithPath = schema_utils_1.Type.Object({
    input: constants_1.PROTO.CardanoTxInput,
    path: schema_utils_1.Type.Optional(exports.Path),
});
exports.InputWithPathParam = schema_utils_1.Type.Composite([
    constants_1.PROTO.CardanoTxInput,
    schema_utils_1.Type.Object({
        path: schema_utils_1.Type.Optional(exports_1.DerivationPath),
    }),
]);
const transformInput = (input) => {
    (0, schema_utils_1.Assert)(exports.InputWithPathParam, input);
    return {
        input: {
            prev_hash: input.prev_hash,
            prev_index: input.prev_index,
        },
        path: input.path ? (0, pathUtils_1.validatePath)(input.path, 5) : undefined,
    };
};
exports.transformInput = transformInput;
const transformCollateralInput = (collateralInput) => {
    (0, schema_utils_1.Assert)(exports.InputWithPathParam, collateralInput);
    return {
        collateralInput: {
            prev_hash: collateralInput.prev_hash,
            prev_index: collateralInput.prev_index,
        },
        path: collateralInput.path ? (0, pathUtils_1.validatePath)(collateralInput.path, 5) : undefined,
    };
};
exports.transformCollateralInput = transformCollateralInput;
const transformReferenceInput = (referenceInput) => {
    (0, schema_utils_1.Assert)(constants_1.PROTO.CardanoTxInput, referenceInput);
    return {
        prev_hash: referenceInput.prev_hash,
        prev_index: referenceInput.prev_index,
    };
};
exports.transformReferenceInput = transformReferenceInput;
//# sourceMappingURL=cardanoInputs.js.map