"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const schema_utils_1 = require("@trezor/schema-utils");
const AbstractMethod_1 = require("../core/AbstractMethod");
const paramsValidator_1 = require("./common/paramsValidator");
const cancelCoinjoinAuthorization_1 = require("../types/api/cancelCoinjoinAuthorization");
class CancelCoinjoinAuthorization extends AbstractMethod_1.AbstractMethod {
    init() {
        const { payload } = this;
        (0, schema_utils_1.Assert)(cancelCoinjoinAuthorization_1.CancelCoinjoinAuthorization, payload);
        this.firmwareRange = (0, paramsValidator_1.getFirmwareRange)(this.name, null, this.firmwareRange);
        this.preauthorized =
            typeof payload.preauthorized === 'boolean' ? payload.preauthorized : true;
    }
    get info() {
        return 'Cancel Coinjoin Authorization';
    }
    async run() {
        const cmd = this.device.getCommands();
        if (!this.preauthorized) {
            if (!(await cmd.preauthorize(false))) {
                return { message: 'Not authorized' };
            }
        }
        const response = await cmd.typedCall('CancelAuthorization', 'Success');
        return response.message;
    }
}
exports.default = CancelCoinjoinAuthorization;
//# sourceMappingURL=cancelCoinjoinAuthorization.js.map