"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const constants_1 = require("../constants");
const AbstractMethod_1 = require("../core/AbstractMethod");
const paramsValidator_1 = require("./common/paramsValidator");
const BlockchainLink_1 = require("../backend/BlockchainLink");
const coinInfo_1 = require("../data/coinInfo");
class BlockchainUnsubscribe extends AbstractMethod_1.AbstractMethod {
    init() {
        this.useDevice = false;
        this.useUi = false;
        const { payload } = this;
        (0, paramsValidator_1.validateParams)(payload, [
            { name: 'accounts', type: 'array', allowEmpty: true },
            { name: 'blocks', type: 'boolean' },
            { name: 'coin', type: 'string', required: true },
            { name: 'identity', type: 'string' },
        ]);
        if (payload.accounts) {
            payload.accounts.forEach(account => {
                (0, paramsValidator_1.validateParams)(account, [{ name: 'descriptor', type: 'string', required: true }]);
            });
        }
        const coinInfo = (0, coinInfo_1.getCoinInfo)(payload.coin);
        if (!coinInfo) {
            throw constants_1.ERRORS.TypedError('Method_UnknownCoin');
        }
        (0, BlockchainLink_1.isBackendSupported)(coinInfo);
        this.params = {
            accounts: payload.accounts,
            coinInfo,
            identity: payload.identity,
            blocks: payload.blocks ?? false,
        };
    }
    async run() {
        const backend = await (0, BlockchainLink_1.initBlockchain)(this.params.coinInfo, this.postMessage, this.params.identity);
        const { accounts } = this.params;
        if (this.params.blocks) {
            return backend.unsubscribeBlocks();
        }
        if (accounts) {
            return backend.unsubscribeAccounts(accounts);
        }
        return backend.unsubscribeAll();
    }
}
exports.default = BlockchainUnsubscribe;
//# sourceMappingURL=blockchainUnsubscribe.js.map