import { AbstractMethod, Payload } from '../core/AbstractMethod';
import type { CoinInfo } from '../types';
type Params = {
    coinInfo: CoinInfo;
    identity?: string;
    currencies: Payload<'blockchainGetFiatRatesForTimestamps'>['currencies'];
    timestamps: Payload<'blockchainGetFiatRatesForTimestamps'>['timestamps'];
    token: Payload<'blockchainGetFiatRatesForTimestamps'>['token'];
};
export default class BlockchainGetFiatRatesForTimestamps extends AbstractMethod<'blockchainGetFiatRatesForTimestamps', Params> {
    init(): void;
    run(): Promise<{
        tickers: {
            ts: number;
            rates: import("@trezor/blockchain-link-types/lib/common").FiatRatesBySymbol;
        }[];
    }>;
}
export {};
//# sourceMappingURL=blockchainGetFiatRatesForTimestamps.d.ts.map