"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTransactionVbytes = void 0;
exports.mapOutputScriptToKey = mapOutputScriptToKey;
const tslib_1 = require("tslib");
const baddress = tslib_1.__importStar(require("@trezor/utxo-lib/lib/address"));
const txWeightCalculator_1 = require("@trezor/utxo-lib/lib/txWeightCalculator");
const pathUtils_1 = require("../../utils/pathUtils");
function mapOutputScriptToKey(script_type) {
    switch (script_type) {
        case 'PAYTOADDRESS':
            return 'p2pkh';
        case 'PAYTOSCRIPTHASH':
            return 'p2sh';
        case 'PAYTOWITNESS':
            return 'p2wpkh';
        case 'PAYTOP2SHWITNESS':
            return 'p2sh';
        case 'PAYTOTAPROOT':
            return 'p2tr';
        default:
            return undefined;
    }
}
const getTransactionVbytes = (inputs, outputs, coinInfo) => {
    const calc = new txWeightCalculator_1.TxWeightCalculator();
    let cannotProcess = false;
    inputs.forEach(input => {
        const script_type = input.script_type ?? (0, pathUtils_1.getScriptType)(input.address_n);
        if (script_type && !input.witness) {
            calc.addInput({
                script_type,
                multisig: input.multisig,
                ownership_proof: input.ownership_proof,
            });
        }
        else {
            cannotProcess = true;
        }
    });
    outputs.forEach(out => {
        if (out.script_type === 'PAYTOOPRETURN') {
            if (!out.op_return_data) {
                cannotProcess = true;
                return;
            }
            calc.addOutput({ length: 2 + out.op_return_data.length / 2 });
            return;
        }
        else if (out.address) {
            calc.addOutput({
                length: baddress.toOutputScript(out.address, coinInfo.network).length,
            });
            return;
        }
        else if (out.address_n || out.script_type) {
            const script_type = out.script_type ?? (0, pathUtils_1.getOutputScriptType)(out.address_n);
            if (script_type) {
                const script_key = mapOutputScriptToKey(script_type);
                if (script_key) {
                    calc.addOutputByKey(script_key);
                    return;
                }
            }
        }
        cannotProcess = true;
    });
    if (cannotProcess) {
        return undefined;
    }
    return calc.getVirtualBytes();
};
exports.getTransactionVbytes = getTransactionVbytes;
//# sourceMappingURL=transactionBytes.js.map